/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

@Immutable
public abstract class AbstractProjection
implements Projection {
    protected static final double EARTH_RADIUS = 6371.229;
    protected static final int INDEX_LAT = 0;
    protected static final int INDEX_LON = 1;
    protected static final int INDEX_X = 0;
    protected static final int INDEX_Y = 1;
    protected static final double TOLERANCE = 1.0E-6;
    protected static final double PI = Math.PI;
    protected static final double PI_OVER_2 = 1.5707963267948966;
    protected static final double PI_OVER_4 = 0.7853981633974483;
    protected final String name;
    protected final boolean isLatLon;
    protected final List<Parameter> atts = new ArrayList<Parameter>();

    public abstract Projection constructCopy();

    protected AbstractProjection(String name, boolean isLatLon) {
        this.name = name;
        this.isLatLon = isLatLon;
    }

    @Override
    public String getClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    @Override
    public abstract String paramsToString();

    public String getProjectionTypeLabel() {
        return this.getClassName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    public ImmutableList<Parameter> getProjectionParameters() {
        return ImmutableList.copyOf(this.atts);
    }

    @Override
    public AttributeContainer getProjectionAttributes() {
        AttributeContainerMutable attc = new AttributeContainerMutable(this.getName());
        for (Parameter p : this.atts) {
            attc.addAttribute(Attribute.fromParameter(p));
        }
        return attc.toImmutable();
    }

    @Deprecated
    public Parameter findProjectionParameter(String want) {
        for (Parameter p : this.atts) {
            if (!p.getName().equals(want)) continue;
            return p;
        }
        return null;
    }

    protected void addParameter(String name, String value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(String name, double value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(Attribute att) {
        this.atts.add(Attribute.toParameter(att));
    }

    @Deprecated
    protected void addParameter(Parameter p) {
        this.atts.add(p);
    }

    @Override
    public boolean isLatLon() {
        return this.isLatLon;
    }

    public static String getHeader() {
        StringBuilder headerB = new StringBuilder(60);
        headerB.append("Name");
        Format.tab(headerB, 20, true);
        headerB.append("Class");
        Format.tab(headerB, 40, true);
        headerB.append("Parameters");
        return headerB.toString();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect latlonRect) {
        LatLonPoint ll = latlonRect.getLowerLeftPoint();
        LatLonPoint ur = latlonRect.getUpperRightPoint();
        ProjectionPoint w1 = this.latLonToProj(ll);
        ProjectionPoint w2 = this.latLonToProj(ur);
        ProjectionRect.Builder world = ProjectionRect.builder(w1.getX(), w1.getY(), w2.getX(), w2.getY());
        LatLonPoint la = LatLonPoint.create(ur.getLatitude(), ll.getLongitude());
        LatLonPoint lb = LatLonPoint.create(ll.getLatitude(), ur.getLongitude());
        world.add(this.latLonToProj(la));
        world.add(this.latLonToProj(lb));
        return world.build();
    }

    @Override
    public LatLonRect projToLatLonBB(ProjectionRect bb) {
        LatLonRect llbb;
        LatLonPoint llpt = this.projToLatLon(bb.getLowerLeftPoint());
        LatLonPoint lrpt = this.projToLatLon(bb.getLowerRightPoint());
        LatLonPoint urpt = this.projToLatLon(bb.getUpperRightPoint());
        LatLonPoint ulpt = this.projToLatLon(bb.getUpperLeftPoint());
        boolean includesNorthPole = false;
        boolean includesSouthPole = false;
        if (includesNorthPole && !includesSouthPole) {
            LatLonRect.Builder builder = LatLonRect.builder(llpt, LatLonPoint.create(90.0, 0.0));
            builder.extend(lrpt);
            builder.extend(urpt);
            builder.extend(ulpt);
            llbb = builder.build();
        } else if (includesSouthPole && !includesNorthPole) {
            LatLonRect.Builder builder = LatLonRect.builder(llpt, LatLonPoint.create(-90.0, -180.0));
            builder.extend(lrpt);
            builder.extend(urpt);
            builder.extend(ulpt);
            llbb = builder.build();
        } else {
            double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
            double lonMin = AbstractProjection.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            double lonMax = AbstractProjection.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
            LatLonPoint ll = LatLonPoint.create(latMin, lonMin);
            LatLonPoint ur = LatLonPoint.create(latMax, lonMax);
            llbb = LatLonRect.builder(ll, ur).build();
        }
        return llbb;
    }

    ProjectionRect latLonToProjBB2(LatLonRect latlonRect) {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonPoint llpt = latlonRect.getLowerLeftPoint();
        LatLonPoint urpt = latlonRect.getUpperRightPoint();
        LatLonPoint lrpt = latlonRect.getLowerRightPoint();
        LatLonPoint ulpt = latlonRect.getUpperLeftPoint();
        if (this.isLatLon()) {
            minx = AbstractProjection.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = AbstractProjection.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionPoint ll = this.latLonToProj(llpt);
            ProjectionPoint ur = this.latLonToProj(urpt);
            ProjectionPoint lr = this.latLonToProj(lrpt);
            ProjectionPoint ul = this.latLonToProj(ulpt);
            minx = Math.min(ll.getX(), ul.getX());
            miny = Math.min(ll.getY(), lr.getY());
            maxx = Math.max(ur.getX(), lr.getX());
            maxy = Math.max(ul.getY(), ur.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }

    protected static double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPoints.lonNormal(lon1, midpoint);
        lon2 = LatLonPoints.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }
}

