/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.util.Parameter;

@Immutable
public class AlbersEqualArea
extends AbstractProjection {
    private final double lat0;
    private final double lon0;
    private final double par1;
    private final double par2;
    private final double falseEasting;
    private final double falseNorthing;
    private final double earth_radius;
    private final double _lat0;
    private final double _lon0;
    private final double n;
    private final double C;
    private final double rho0;
    private final double lon0Degrees;

    @Override
    public Projection constructCopy() {
        return new AlbersEqualArea(this.getOriginLat(), this.getOriginLon(), this.getParallelOne(), this.getParallelTwo(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
    }

    public AlbersEqualArea() {
        this(23.0, -96.0, 29.5, 45.5);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2) {
        this(lat0, lon0, par1, par2, 0.0, 0.0, 6371.229);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing) {
        this(lat0, lon0, par1, par2, falseEasting, falseNorthing, 6371.229);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing, double earth_radius) {
        super("AlbersEqualArea", false);
        this._lat0 = lat0;
        this._lon0 = lon0;
        this.lon0Degrees = lon0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.par1 = par1;
        this.par2 = par2;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth_radius = earth_radius;
        double par1r = Math.toRadians(this.par1);
        double par2r = Math.toRadians(this.par2);
        this.n = Math.abs(par2 - par1) < 1.0E-6 ? Math.sin(par1r) : (Math.sin(par1r) + Math.sin(par2r)) / 2.0;
        double c2 = Math.pow(Math.cos(par1r), 2.0);
        this.C = c2 + 2.0 * this.n * Math.sin(par1r);
        this.rho0 = this.computeRho(this.lat0);
        this.addParameter("grid_mapping_name", "albers_conical_equal_area");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (par2 == par1) {
            this.addParameter("standard_parallel", par1);
        } else {
            double[] data = new double[]{par1, par2};
            this.addParameter(new Parameter("standard_parallel", data));
        }
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("earth_radius", earth_radius * 1000.0);
    }

    private double computeRho(double lat) {
        return this.earth_radius * Math.sqrt(this.C - 2.0 * this.n * Math.sin(lat)) / this.n;
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPoints.lonNormal(Math.toDegrees(lon) - this.lon0Degrees);
        return this.n * Math.toRadians(dlon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlbersEqualArea that = (AlbersEqualArea)o;
        if (Double.compare(that.earth_radius, this.earth_radius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(that.lon0, this.lon0) != 0) {
            return false;
        }
        if (Double.compare(that.par1, this.par1) != 0) {
            return false;
        }
        return Double.compare(that.par2, this.par2) == 0;
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.par1 != 0.0 ? Double.doubleToLongBits(this.par1) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.par2 != 0.0 ? Double.doubleToLongBits(this.par2) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.earth_radius != 0.0 ? Double.doubleToLongBits(this.earth_radius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getParallelTwo() {
        return this.par2;
    }

    public double getParallelOne() {
        return this.par1;
    }

    public double getOriginLon() {
        return this._lon0;
    }

    public double getOriginLat() {
        return this._lat0;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getEarthRadius() {
        return this.earth_radius;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Albers Equal Area";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "AlbersEqualArea{lat0=" + this._lat0 + ", lon0=" + this._lon0 + ", par1=" + this.par1 + ", par2=" + this.par2 + ", falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + ", earth_radius=" + this.earth_radius + '}';
    }

    public double getScale(double lat) {
        lat = Math.toRadians(lat);
        double n = Math.cos(lat);
        double d = Math.sqrt(this.C - 2.0 * n * Math.sin(lat));
        return n / d;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        fromLon = Math.toRadians(fromLon);
        double rho = this.computeRho(fromLat);
        double theta = this.computeTheta(fromLon);
        double toX = rho * Math.sin(theta) + this.falseEasting;
        double toY = this.rho0 - rho * Math.cos(theta) + this.falseNorthing;
        return ProjectionPoint.create(toX, toY);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rrho0 = this.rho0;
        if (this.n < 0.0) {
            rrho0 *= -1.0;
            fromX *= -1.0;
            fromY *= -1.0;
        }
        double yd = rrho0 - fromY;
        double rho = Math.sqrt(fromX * fromX + yd * yd);
        double theta = Math.atan2(fromX, yd);
        if (this.n < 0.0) {
            rho *= -1.0;
        }
        double toLat = Math.toDegrees(Math.asin((this.C - Math.pow(rho * this.n / this.earth_radius, 2.0)) / (2.0 * this.n)));
        double toLon = Math.toDegrees(theta / this.n + this.lon0);
        return LatLonPoint.create(toLat, toLon);
    }
}

