/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;

@Immutable
public class FlatEarth
extends AbstractProjection {
    public static final String ROTATIONANGLE = "rotationAngle";
    private final double rotAngle;
    private final double radius;
    private final double lat0;
    private final double lon0;
    private final double _lat0;
    private final double _lon0;
    private final double cosRot;
    private final double sinRot;

    @Override
    public Projection constructCopy() {
        return new FlatEarth(this.getOriginLat(), this.getOriginLon(), this.getRotationAngle());
    }

    public FlatEarth() {
        this(0.0, 0.0, 0.0, 6371.229);
    }

    public FlatEarth(double lat0, double lon0) {
        this(lat0, lon0, 0.0, 6371.229);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle) {
        this(lat0, lon0, rotAngle, 6371.229);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle, double radius) {
        super("FlatEarth", false);
        this._lat0 = lat0;
        this._lon0 = lon0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(rotAngle);
        this.radius = radius;
        this.sinRot = Math.sin(this.rotAngle);
        this.cosRot = Math.cos(this.rotAngle);
        this.addParameter("grid_mapping_name", "flat_earth");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter(ROTATIONANGLE, rotAngle);
        this.addParameter("earth_radius", radius * 1000.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatEarth flatEarth = (FlatEarth)o;
        if (Double.compare(flatEarth.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(flatEarth.lon0, this.lon0) != 0) {
            return false;
        }
        if (Double.compare(flatEarth.radius, this.radius) != 0) {
            return false;
        }
        return Double.compare(flatEarth.rotAngle, this.rotAngle) == 0;
    }

    public int hashCode() {
        long temp = this.rotAngle != 0.0 ? Double.doubleToLongBits(this.rotAngle) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getOriginLon() {
        return this._lon0;
    }

    public double getOriginLat() {
        return this._lat0;
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "FlatEarth";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "FlatEarth{rotAngle=" + this.rotAngle + ", radius=" + this.radius + ", lat0=" + this._lat0 + ", lon0=" + this._lon0 + '}';
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double dy = this.radius * (fromLat - this.lat0);
        double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
        double toX = this.cosRot * dx - this.sinRot * dy;
        double toY = this.sinRot * dx + this.cosRot * dy;
        return ProjectionPoint.create(toX, toY);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double x = world.getX();
        double y = world.getY();
        double xp = this.cosRot * x + this.sinRot * y;
        double yp = -this.sinRot * x + this.cosRot * y;
        double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
        double cosl = Math.cos(Math.toRadians(toLat));
        double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
        toLon = LatLonPoints.lonNormal(toLon);
        return LatLonPoint.create(toLat, toLon);
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return pt1.getX() * pt2.getX() < 0.0;
    }
}

