/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;

@Immutable
public class LambertAzimuthalEqualArea
extends AbstractProjection {
    private final double R;
    private final double sinLat0;
    private final double cosLat0;
    private final double lon0Degrees;
    private final double lat0;
    private final double lon0;
    private final double falseEasting;
    private final double falseNorthing;
    private final double _lat0;

    @Override
    public Projection constructCopy() {
        return new LambertAzimuthalEqualArea(this.getOriginLat(), this.getOriginLon(), this.getFalseEasting(), this.getFalseNorthing(), this.R);
    }

    public LambertAzimuthalEqualArea() {
        this(40.0, 100.0, 0.0, 0.0, 6371.229);
    }

    public LambertAzimuthalEqualArea(double lat0, double lon0) {
        this(lat0, lon0, 0.0, 0.0, 6371.229);
    }

    public LambertAzimuthalEqualArea(double lat0, double lon0, double false_easting, double false_northing, double earthRadius) {
        super("LambertAzimuthalEqualArea", false);
        this._lat0 = lat0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.lon0Degrees = lon0;
        this.R = earthRadius;
        if (Double.isNaN(false_easting)) {
            false_easting = 0.0;
        }
        if (Double.isNaN(false_northing)) {
            false_northing = 0.0;
        }
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.addParameter("grid_mapping_name", "lambert_azimuthal_equal_area");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("earth_radius", earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambertAzimuthalEqualArea that = (LambertAzimuthalEqualArea)o;
        if (Double.compare(that.R, this.R) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        return Double.compare(that.lon0, this.lon0) == 0;
    }

    public int hashCode() {
        long temp = this.R != 0.0 ? Double.doubleToLongBits(this.R) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getOriginLon() {
        return this.lon0Degrees;
    }

    public double getOriginLat() {
        return this._lat0;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Lambert Azimuth Equal Area";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "LambertAzimuthalEqualArea{falseNorthing=" + this.falseNorthing + ", falseEasting=" + this.falseEasting + ", lon0=" + this.lon0Degrees + ", lat0=" + this._lat0 + ", R=" + this.R + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPoints.lonNormal(fromLon - this.lon0Degrees));
        double g = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        double kPrime = Math.sqrt(2.0 / (1.0 + g));
        double toX = this.R * kPrime * Math.cos(fromLat) * Math.sin(lonDiff) + this.falseEasting;
        double toY = this.R * kPrime * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff)) + this.falseNorthing;
        return ProjectionPoint.create(toX, toY);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt((fromX -= this.falseEasting) * fromX + (fromY -= this.falseNorthing) * fromY);
        double c = 2.0 * Math.asin(rho / (2.0 * this.R));
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (Double.compare(this.lat0, 0.7853981633974483) == 0) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPoints.lonNormal(toLon);
        return LatLonPoint.create(toLat, toLon);
    }
}

