/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.util.Parameter;

@Immutable
public class LambertConformal
extends AbstractProjection {
    private final double earth_radius;
    private final double lat0;
    private final double lon0;
    private final double par1;
    private final double par2;
    private final double falseEasting;
    private final double falseNorthing;
    private final double _lat0;
    private final double _lon0;
    private final double n;
    private final double F;
    private final double rho;
    private final double earthRadiusTimesF;
    private final double lon0Degrees;

    @Override
    public Projection constructCopy() {
        return new LambertConformal(this.getOriginLat(), this.getOriginLon(), this.getParallelOne(), this.getParallelTwo(), this.getFalseEasting(), this.getFalseNorthing(), this.earth_radius);
    }

    public LambertConformal() {
        this(40.0, -105.0, 20.0, 60.0, 0.0, 0.0, 6371.229);
    }

    public LambertConformal(double lat0, double lon0, double par1, double par2) {
        this(lat0, lon0, par1, par2, 0.0, 0.0, 6371.229);
    }

    public LambertConformal(double lat0, double lon0, double par1, double par2, double false_easting, double false_northing) {
        this(lat0, lon0, par1, par2, false_easting, false_northing, 6371.229);
    }

    public LambertConformal(double lat0, double lon0, double par1, double par2, double false_easting, double false_northing, double earth_radius) {
        super("LambertConformal", false);
        this._lat0 = lat0;
        this._lon0 = lon0;
        this.lon0Degrees = lon0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.par1 = par1;
        this.par2 = par2;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.earth_radius = earth_radius;
        if (Math.abs(this.lat0) > 1.5707963267948966) {
            throw new IllegalArgumentException("LambertConformal lat0 outside range (-90,90)");
        }
        if (Math.abs(par1) >= 90.0) {
            throw new IllegalArgumentException("LambertConformal abs(par1) >= 90");
        }
        if (Math.abs(par2) >= 90.0) {
            throw new IllegalArgumentException("LambertConformal abs(par2) >= 90");
        }
        if (Math.abs(par1 - 90.0) < 1.0E-6) {
            throw new IllegalArgumentException("LambertConformal par1 = 90");
        }
        if (Math.abs(par1 + 90.0) < 1.0E-6) {
            throw new IllegalArgumentException("LambertConformal par1 = -90");
        }
        if (Math.abs(par2 - 90.0) < 1.0E-6) {
            throw new IllegalArgumentException("LambertConformal par2 = 90");
        }
        if (Math.abs(par2 + 90.0) < 1.0E-6) {
            throw new IllegalArgumentException("LambertConformal par2 = -90");
        }
        double par1r = Math.toRadians(this.par1);
        double par2r = Math.toRadians(this.par2);
        double t1 = Math.tan(0.7853981633974483 + par1r / 2.0);
        double t2 = Math.tan(0.7853981633974483 + par2r / 2.0);
        this.n = Math.abs(par2 - par1) < 1.0E-6 ? Math.sin(par1r) : Math.log(Math.cos(par1r) / Math.cos(par2r)) / Math.log(t2 / t1);
        double t1n = Math.pow(t1, this.n);
        this.F = Math.cos(par1r) * t1n / this.n;
        this.earthRadiusTimesF = earth_radius * this.F;
        double t0n = Math.pow(Math.tan(0.7853981633974483 + this.lat0 / 2.0), this.n);
        this.rho = this.earthRadiusTimesF / t0n;
        this.addParameter("grid_mapping_name", "lambert_conformal_conic");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (par2 == par1) {
            this.addParameter("standard_parallel", par1);
        } else {
            double[] data = new double[]{par1, par2};
            this.addParameter(new Parameter("standard_parallel", data));
        }
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
        this.addParameter("earth_radius", earth_radius * 1000.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambertConformal that = (LambertConformal)o;
        if (Double.compare(that.earth_radius, this.earth_radius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(that.lon0, this.lon0) != 0) {
            return false;
        }
        if (Double.compare(that.par1, this.par1) != 0) {
            return false;
        }
        return Double.compare(that.par2, this.par2) == 0;
    }

    public int hashCode() {
        long temp = this.earth_radius != 0.0 ? Double.doubleToLongBits(this.earth_radius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.par1 != 0.0 ? Double.doubleToLongBits(this.par1) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.par2 != 0.0 ? Double.doubleToLongBits(this.par2) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getParallelTwo() {
        return this.par2;
    }

    public double getParallelOne() {
        return this.par1;
    }

    public double getOriginLon() {
        return this._lon0;
    }

    public double getOriginLat() {
        return this._lat0;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Lambert conformal conic";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "LambertConformal{earth_radius=" + this.earth_radius + ", lat0=" + this._lat0 + ", lon0=" + this._lon0 + ", par1=" + this.par1 + ", par2=" + this.par2 + ", falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + '}';
    }

    public String toWKS() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("PROJCS[\"").append(this.getName()).append("\",");
        sbuff.append("GEOGCS[\"Normal Sphere (r=6371007)\",");
        sbuff.append("DATUM[\"unknown\",");
        sbuff.append("SPHEROID[\"sphere\",6371007,0]],");
        sbuff.append("PRIMEM[\"Greenwich\",0],");
        sbuff.append("UNIT[\"degree\",0.0174532925199433]],");
        sbuff.append("PROJECTION[\"Lambert_Conformal_Conic_1SP\"],");
        sbuff.append("PARAMETER[\"latitude_of_origin\",").append(this.getOriginLat()).append("],");
        sbuff.append("PARAMETER[\"central_meridian\",").append(this.getOriginLon()).append("],");
        sbuff.append("PARAMETER[\"scale_factor\",1],");
        sbuff.append("PARAMETER[\"false_easting\",").append(this.falseEasting).append("],");
        sbuff.append("PARAMETER[\"false_northing\",").append(this.falseNorthing).append("],");
        return sbuff.toString();
    }

    public double getScale(double lat) {
        lat = Math.toRadians(lat);
        double t = Math.tan(0.7853981633974483 + lat / 2.0);
        double tn = Math.pow(t, this.n);
        double r1 = this.n * this.F;
        double r2 = Math.cos(lat) * tn;
        return r1 / r2;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 20000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double dlon = LatLonPoints.lonNormal(fromLon - this.lon0Degrees);
        double theta = this.n * Math.toRadians(dlon);
        double tn = Math.pow(Math.tan(0.7853981633974483 + fromLat / 2.0), this.n);
        double r = this.earthRadiusTimesF / tn;
        double toX = r * Math.sin(theta);
        double toY = this.rho - r * Math.cos(theta);
        return ProjectionPoint.create(toX + this.falseEasting, toY + this.falseNorthing);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double toLat;
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rhop = this.rho;
        if (this.n < 0.0) {
            rhop *= -1.0;
            fromX *= -1.0;
            fromY *= -1.0;
        }
        double yd = rhop - fromY;
        double theta = Math.atan2(fromX, yd);
        double r = Math.sqrt(fromX * fromX + yd * yd);
        if (this.n < 0.0) {
            r *= -1.0;
        }
        double toLon = Math.toDegrees(theta / this.n + this.lon0);
        if (Math.abs(r) < 1.0E-6) {
            toLat = this.n < 0.0 ? -90.0 : 90.0;
        } else {
            double rn = Math.pow(this.earth_radius * this.F / r, 1.0 / this.n);
            toLat = Math.toDegrees(2.0 * Math.atan(rn) - 1.5707963267948966);
        }
        return LatLonPoint.create(toLat, toLon);
    }
}

