/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.util.Format;

@Immutable
public class LatLonProjection
extends AbstractProjection {
    private final double centerLon;
    private final Earth earth;

    @Override
    public Projection constructCopy() {
        return new LatLonProjection(this.getName(), this.getEarth(), this.getCenterLon());
    }

    public LatLonProjection() {
        this("LatLonProjection", EarthEllipsoid.DEFAULT, 0.0);
    }

    public LatLonProjection(String name) {
        this(name, EarthEllipsoid.DEFAULT, 0.0);
    }

    public LatLonProjection(Earth earth) {
        this("LatLonProjection", earth, 0.0);
    }

    public LatLonProjection(String name, @Nullable Earth earth, double centerLon) {
        super(name, true);
        this.earth = earth == null ? EarthEllipsoid.DEFAULT : earth;
        this.centerLon = centerLon;
        this.addParameter("grid_mapping_name", "latitude_longitude");
        if (this.earth.isSpherical()) {
            this.addParameter("earth_radius", this.earth.getEquatorRadius());
        } else {
            this.addParameter("semi_major_axis", this.earth.getEquatorRadius());
            this.addParameter("semi_minor_axis", this.earth.getPoleRadius());
        }
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Lat/Lon";
    }

    @Override
    public String paramsToString() {
        return "Center lon:" + Format.d(this.centerLon, 3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLonProjection that = (LatLonProjection)o;
        return Double.compare(that.centerLon, this.centerLon) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.centerLon);
        int result = (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon) {
        return this.latLonToProj(latlon, this.centerLon);
    }

    private ProjectionPoint latLonToProj(LatLonPoint latlon, double centerLon) {
        return ProjectionPoint.create(LatLonPoints.lonNormal(latlon.getLongitude(), centerLon), latlon.getLatitude());
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        return LatLonPoint.create(world.getX(), world.getY());
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public Earth getEarth() {
        return this.earth;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return Math.abs(pt1.getX() - pt2.getX()) > 270.0;
    }

    @Override
    public LatLonRect projToLatLonBB(ProjectionRect world) {
        double startLat = world.getMinY();
        double startLon = world.getMinX();
        double deltaLat = world.getHeight();
        double deltaLon = world.getWidth();
        LatLonPoint llpt = LatLonPoint.create(startLat, startLon);
        return new LatLonRect.Builder(llpt, deltaLat, deltaLon).build();
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect latlonRect) {
        double centerLon = latlonRect.getCenterLon();
        LatLonPoint ll = latlonRect.getLowerLeftPoint();
        LatLonPoint ur = latlonRect.getUpperRightPoint();
        ProjectionPoint w1 = this.latLonToProj(ll, centerLon);
        ProjectionPoint w2 = this.latLonToProj(ur, centerLon);
        ProjectionRect.Builder world = ProjectionRect.builder(w1.getX(), w1.getY(), w2.getX(), w2.getY());
        LatLonPoint la = LatLonPoint.create(ur.getLatitude(), ll.getLongitude());
        LatLonPoint lb = LatLonPoint.create(ll.getLatitude(), ur.getLongitude());
        world.add(this.latLonToProj(la, centerLon));
        world.add(this.latLonToProj(lb, centerLon));
        return world.build();
    }

    public ProjectionRect[] latLonToProjRect(LatLonRect latlonR) {
        double lat0 = latlonR.getLowerLeftPoint().getLatitude();
        double height = Math.abs(latlonR.getUpperRightPoint().getLatitude() - lat0);
        double width = latlonR.getWidth();
        double lon0 = LatLonPoints.lonNormal(latlonR.getLowerLeftPoint().getLongitude(), this.centerLon);
        ProjectionRect[] rects = new ProjectionRect[2];
        if (lon0 + width <= this.centerLon + 180.0) {
            rects[0] = ProjectionRect.builder().setRect(lon0, lat0, width, height).build();
            rects[1] = null;
        } else {
            double width1 = this.centerLon + 180.0 - lon0;
            rects[0] = ProjectionRect.builder().setRect(lon0, lat0, width1, height).build();
            rects[1] = ProjectionRect.builder().setRect(this.centerLon - 180.0, lat0, width - width1, height).build();
        }
        return rects;
    }

    public ProjectionRect[] latLonToProjRect(double lat0, double lon0, double lat1, double lon1) {
        LatLonRect rect = new LatLonRect(lat0, lon0, lat1, lon1);
        return this.latLonToProjRect(rect);
    }
}

