/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;

@Immutable
public class Orthographic
extends AbstractProjection {
    private final double lat0;
    private final double lon0;
    private final double R;
    private final double lon0Degrees;
    private final double cosLat0;
    private final double sinLat0;
    private final double _lat0;

    @Override
    public Projection constructCopy() {
        return new Orthographic(this.getOriginLat(), this.getOriginLon(), this.R);
    }

    public Orthographic() {
        this(0.0, 0.0);
    }

    public Orthographic(double lat0, double lon0) {
        this(lat0, lon0, 6371.229);
    }

    public Orthographic(double lat0, double lon0, double earthRadius) {
        super("Orthographic", false);
        this._lat0 = lat0;
        this.lon0Degrees = lon0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.R = earthRadius;
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.addParameter("grid_mapping_name", "orthographic");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("earth_radius", earthRadius * 1000.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orthographic that = (Orthographic)o;
        if (Double.compare(that.R, this.R) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        return Double.compare(that.lon0, this.lon0) == 0;
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.R != 0.0 ? Double.doubleToLongBits(this.R) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getOriginLon() {
        return this.lon0Degrees;
    }

    public double getOriginLat() {
        return this._lat0;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Orthographic";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Orthographic{lat0=" + this._lat0 + ", lon0=" + this.lon0Degrees + ", R=" + this.R + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPoints.lonNormal(fromLon - this.lon0Degrees));
        double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        if (cosc >= 0.0) {
            toX = this.R * Math.cos(fromLat) * Math.sin(lonDiff);
            toY = this.R * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
        } else {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        }
        return ProjectionPoint.create(toX, toY);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = Math.asin(rho / this.R);
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (Double.compare(this.lat0, 0.7853981633974483) == 0) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPoints.lonNormal(toLon);
        return LatLonPoint.create(toLat, toLon);
    }
}

