/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;

@Immutable
public class Stereographic
extends AbstractProjection {
    private final double falseEasting;
    private final double falseNorthing;
    private final double scale;
    private final double earthRadius;
    private final double latt;
    private final double lont;
    private final double sinlatt;
    private final double coslatt;
    private final double latts;
    private final boolean isNorth;
    private final boolean isPolar;
    private final double _latts;
    private final double _latt;
    private final double _lont;
    private final double _scale;

    public static Stereographic factory(double latt, double lont, double latTrue) {
        double scale = (1.0 + Math.sin(Math.toRadians(latTrue))) / 2.0;
        return new Stereographic(latt, lont, scale);
    }

    @Override
    public Projection constructCopy() {
        return new Stereographic(this.getTangentLat(), this.getTangentLon(), this.getScale(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
    }

    public Stereographic() {
        this(90.0, -105.0, 1.0);
    }

    public Stereographic(double latt, double lont, double scale) {
        this(latt, lont, scale, 0.0, 0.0, 6371.229);
    }

    public Stereographic(double latt, double lont, double scale, double false_easting, double false_northing) {
        this(latt, lont, scale, false_easting, false_northing, 6371.229);
    }

    public Stereographic(double lat_ts_deg, double latt_deg, double lont_deg, boolean north) {
        super("PolarStereographic", false);
        this._latts = lat_ts_deg;
        this._latt = latt_deg;
        this._lont = lont_deg;
        this._scale = 0.0;
        this.latts = Math.toRadians(lat_ts_deg);
        this.latt = Math.toRadians(latt_deg);
        this.lont = Math.toRadians(lont_deg);
        this.isPolar = true;
        this.isNorth = north;
        this.earthRadius = 6371.229;
        this.falseEasting = 0.0;
        this.falseNorthing = 0.0;
        this.sinlatt = Math.sin(this.latt);
        this.coslatt = Math.cos(this.latt);
        double scaleFactor = lat_ts_deg == 90.0 || lat_ts_deg == -90.0 ? 1.0 : this.getScaleFactor(this.latts, north);
        this.scale = scaleFactor * this.earthRadius;
        this.addParameter("grid_mapping_name", "polar_stereographic");
        this.addParameter("longitude_of_projection_origin", lont_deg);
        this.addParameter("latitude_of_projection_origin", latt_deg);
        this.addParameter("scale_factor_at_projection_origin", scaleFactor);
    }

    public Stereographic(double latt, double lont, double scale, double false_easting, double false_northing, double radius) {
        super("Stereographic", false);
        this.latts = 0.0;
        this.isNorth = false;
        this.isPolar = false;
        this._latts = 0.0;
        this._latt = latt;
        this._lont = lont;
        this._scale = scale;
        this.latt = Math.toRadians(latt);
        this.lont = Math.toRadians(lont);
        this.earthRadius = radius;
        this.scale = scale * this.earthRadius;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.sinlatt = Math.sin(this.latt);
        this.coslatt = Math.cos(this.latt);
        this.addParameter("grid_mapping_name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    private double getScaleFactor(double lat_ts, boolean north) {
        double e = 0.081819191;
        double root = (1.0 + e * Math.sin(lat_ts)) / (1.0 - e * Math.sin(lat_ts));
        double power = e / 2.0;
        double tf = north ? Math.tan(0.7853981633974483 - lat_ts / 2.0) * Math.pow(root, power) : Math.tan(0.7853981633974483 + lat_ts / 2.0) / Math.pow(root, power);
        double mf = Math.cos(lat_ts) / Math.sqrt(1.0 - e * e * Math.pow(Math.sin(lat_ts), 2.0));
        double k0 = mf * Math.sqrt(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e)) / (2.0 * tf);
        return Double.isNaN(k0) ? 1.0 : k0;
    }

    public double getScale() {
        return this._scale;
    }

    public double getNaturalOriginLat() {
        return this._latts;
    }

    public double getTangentLon() {
        return this._lont;
    }

    public double getTangentLat() {
        return this._latt;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public boolean isNorth() {
        return this.isNorth;
    }

    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Stereographic{falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + ", scale=" + this.scale + ", earthRadius=" + this.earthRadius + ", latt=" + this._latt + ", lont=" + this._lont + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stereographic that = (Stereographic)o;
        if (Double.compare(that.earthRadius, this.earthRadius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.latt, this.latt) != 0) {
            return false;
        }
        if (Double.compare(that.lont, this.lont) != 0) {
            return false;
        }
        return Double.compare(that.scale, this.scale) == 0;
    }

    public int hashCode() {
        long temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.scale != 0.0 ? Double.doubleToLongBits(this.scale) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.latt != 0.0 ? Double.doubleToLongBits(this.latt) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lont != 0.0 ? Double.doubleToLongBits(this.lont) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lat = Math.toRadians(fromLat);
        double lon = Math.toRadians(fromLon);
        if (Math.abs(lat + this.latt) <= 1.0E-6) {
            lat = -this.latt * 0.999999;
        }
        double sdlon = Math.sin(lon - this.lont);
        double cdlon = Math.cos(lon - this.lont);
        double sinlat = Math.sin(lat);
        double coslat = Math.cos(lat);
        double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
        double toX = k * coslat * sdlon;
        double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
        return ProjectionPoint.create(toX + this.falseEasting, toY + this.falseNorthing);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
        double toLat = Math.toDegrees(phi);
        double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
        double toLon = Math.toDegrees(lam);
        return LatLonPoint.create(toLat, toLon);
    }
}

