/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.geoloc.projection.Gdc_To_Utm_Converter;
import ucar.unidata.geoloc.projection.Utm_To_Gdc_Converter;

@Immutable
public class UtmProjection
extends AbstractProjection {
    public static final String GRID_MAPPING_NAME = "universal_transverse_mercator";
    public static final String UTM_ZONE1 = "utm_zone_number";
    public static final String UTM_ZONE2 = "UTM_zone";
    private final Utm_To_Gdc_Converter convert2latlon;
    private final Gdc_To_Utm_Converter convert2xy;
    private final double a;
    private final double f;
    private final int zone;
    private final boolean isNorth;

    @Override
    public Projection constructCopy() {
        return new UtmProjection(this.a, this.f, this.getZone(), this.isNorth());
    }

    public UtmProjection() {
        this(5, true);
    }

    public UtmProjection(int zone, boolean isNorth) {
        super("UtmProjection", false);
        this.convert2latlon = new Utm_To_Gdc_Converter(zone, isNorth);
        this.convert2xy = new Gdc_To_Utm_Converter(zone, isNorth);
        this.a = this.convert2latlon.getA();
        this.f = 1.0 / this.convert2latlon.getF();
        this.zone = zone;
        this.isNorth = isNorth;
        this.addParameter("grid_mapping_name", GRID_MAPPING_NAME);
        this.addParameter("semi_major_axis", this.convert2latlon.getA());
        this.addParameter("inverse_flattening", this.convert2latlon.getF());
        this.addParameter(UTM_ZONE1, zone);
    }

    public UtmProjection(double a, double f, int zone, boolean isNorth) {
        super("UtmProjection", false);
        this.a = a;
        this.f = f;
        this.zone = zone;
        this.isNorth = isNorth;
        this.convert2latlon = new Utm_To_Gdc_Converter(a, f, zone, isNorth);
        this.convert2xy = new Gdc_To_Utm_Converter(a, f, zone, isNorth);
        this.addParameter("grid_mapping_name", GRID_MAPPING_NAME);
        this.addParameter("semi_major_axis", a);
        this.addParameter("inverse_flattening", f);
        this.addParameter(UTM_ZONE1, zone);
    }

    public int getZone() {
        return this.convert2latlon.getZone();
    }

    public boolean isNorth() {
        return this.convert2latlon.isNorth();
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Universal transverse mercator";
    }

    public double getCentralMeridian() {
        return this.convert2xy.getCentralMeridian();
    }

    @Override
    public String paramsToString() {
        return this.getZone() + " " + this.isNorth();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UtmProjection that = (UtmProjection)o;
        if (Double.compare(that.a, this.a) != 0) {
            return false;
        }
        if (Double.compare(that.f, this.f) != 0) {
            return false;
        }
        if (this.zone != that.zone) {
            return false;
        }
        return this.isNorth == that.isNorth;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.a);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.f);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.zone;
        result = 31 * result + (this.isNorth ? 1 : 0);
        return result;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        return this.convert2xy.latLonToProj(fromLat, fromLon);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        return this.convert2latlon.projToLatLon(world.getX(), world.getY());
    }
}

