/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;

class MapMath {
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double TWOPI = Math.PI * 2;
    public static final ProjectionRect WORLD_BOUNDS_RAD = new ProjectionRect(-Math.PI, -1.5707963267948966, Math.PI * 2, Math.PI);
    public static final ProjectionRect WORLD_BOUNDS = new ProjectionRect(-180.0, -90.0, 360.0, 180.0);
    public static final double EPS10 = 1.0E-10;
    public static final double RTD = 57.29577951308232;
    public static final double DTR = Math.PI / 180;
    public static final int DONT_INTERSECT = 0;
    public static final int DO_INTERSECT = 1;
    public static final int COLLINEAR = 2;
    private static final int N_ITER = 15;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    private static final int MAX_ITER = 10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;

    MapMath() {
    }

    public static double sind(double v) {
        return Math.sin(v * (Math.PI / 180));
    }

    public static double cosd(double v) {
        return Math.cos(v * (Math.PI / 180));
    }

    public static double tand(double v) {
        return Math.tan(v * (Math.PI / 180));
    }

    public static double asind(double v) {
        return Math.asin(v) * 57.29577951308232;
    }

    public static double acosd(double v) {
        return Math.acos(v) * 57.29577951308232;
    }

    public static double atand(double v) {
        return Math.atan(v) * 57.29577951308232;
    }

    public static double atan2d(double y, double x) {
        return Math.atan2(y, x) * 57.29577951308232;
    }

    public static double asin(double v) {
        if (Math.abs(v) > 1.0) {
            return v < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Math.asin(v);
    }

    public static double acos(double v) {
        if (Math.abs(v) > 1.0) {
            return v < 0.0 ? Math.PI : 0.0;
        }
        return Math.acos(v);
    }

    public static double sqrt(double v) {
        return v < 0.0 ? 0.0 : Math.sqrt(v);
    }

    public static double distance(double dx, double dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distance(ProjectionPoint a, ProjectionPoint b) {
        return MapMath.distance(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static double hypot(double x, double y) {
        if (x < 0.0) {
            x = -x;
        } else if (x == 0.0) {
            return y < 0.0 ? -y : y;
        }
        if (y < 0.0) {
            y = -y;
        } else if (y == 0.0) {
            return x;
        }
        if (x < y) {
            return y * Math.sqrt(1.0 + (x /= y) * x);
        }
        return x * Math.sqrt(1.0 + (y /= x) * y);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double trunc(double v) {
        return v < 0.0 ? Math.ceil(v) : Math.floor(v);
    }

    public static double frac(double v) {
        return v - MapMath.trunc(v);
    }

    public static double degToRad(double v) {
        return v * Math.PI / 180.0;
    }

    public static double radToDeg(double v) {
        return v * 180.0 / Math.PI;
    }

    public static double dmsToRad(double d, double m, double s) {
        if (d >= 0.0) {
            return (d + m / 60.0 + s / 3600.0) * Math.PI / 180.0;
        }
        return (d - m / 60.0 - s / 3600.0) * Math.PI / 180.0;
    }

    public static double dmsToDeg(double d, double m, double s) {
        if (d >= 0.0) {
            return d + m / 60.0 + s / 3600.0;
        }
        return d - m / 60.0 - s / 3600.0;
    }

    public static double normalizeLatitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new RuntimeException("Infinite latitude");
        }
        while (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        while (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        return angle;
    }

    public static double normalizeLongitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new RuntimeException("Infinite longitude");
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double normalizeAngle(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new RuntimeException("Infinite angle");
        }
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double greatCircleDistance(double lon1, double lat1, double lon2, double lat2) {
        double dlat = Math.sin((lat2 - lat1) / 2.0);
        double dlon = Math.sin((lon2 - lon1) / 2.0);
        double r = Math.sqrt(dlat * dlat + Math.cos(lat1) * Math.cos(lat2) * dlon * dlon);
        return 2.0 * Math.asin(r);
    }

    public static double sphericalAzimuth(double lat0, double lon0, double lat, double lon) {
        double diff = lon - lon0;
        double coslat = Math.cos(lat);
        return Math.atan2(coslat * Math.sin(diff), Math.cos(lat0) * Math.sin(lat) - Math.sin(lat0) * coslat * Math.cos(diff));
    }

    public static boolean sameSigns(double a, double b) {
        return a < 0.0 == b < 0.0;
    }

    public static boolean sameSigns(int a, int b) {
        return a < 0 == b < 0;
    }

    public static double takeSign(double a, double b) {
        a = Math.abs(a);
        if (b < 0.0) {
            return -a;
        }
        return a;
    }

    public static int takeSign(int a, int b) {
        a = Math.abs(a);
        if (b < 0) {
            return -a;
        }
        return a;
    }

    public static int intersectSegments(ProjectionPoint aStart, ProjectionPoint aEnd, ProjectionPoint bStart, ProjectionPoint bEnd) {
        double a1 = aEnd.getY() - aStart.getY();
        double b1 = aStart.getX() - aEnd.getX();
        double c1 = aEnd.getX() * aStart.getY() - aStart.getX() * aEnd.getY();
        double r3 = a1 * bStart.getX() + b1 * bStart.getY() + c1;
        double r4 = a1 * bEnd.getX() + b1 * bEnd.getY() + c1;
        if (r3 != 0.0 && r4 != 0.0 && MapMath.sameSigns(r3, r4)) {
            return 0;
        }
        double a2 = bEnd.getY() - bStart.getY();
        double b2 = bStart.getX() - bEnd.getX();
        double c2 = bEnd.getX() * bStart.getY() - bStart.getX() * bEnd.getY();
        double r1 = a2 * aStart.getX() + b2 * aStart.getY() + c2;
        double r2 = a2 * aEnd.getX() + b2 * aEnd.getY() + c2;
        if (r1 != 0.0 && r2 != 0.0 && MapMath.sameSigns(r1, r2)) {
            return 0;
        }
        double denom = a1 * b2 - a2 * b1;
        if (denom == 0.0) {
            return 2;
        }
        return 1;
    }

    public static double dot(ProjectionPoint a, ProjectionPoint b) {
        return a.getX() * b.getX() + a.getY() * b.getY();
    }

    public static ProjectionPoint perpendicular(ProjectionPoint a) {
        return ProjectionPoint.create(-a.getY(), a.getX());
    }

    public static ProjectionPoint add(ProjectionPoint a, ProjectionPoint b) {
        return ProjectionPoint.create(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static ProjectionPoint subtract(ProjectionPoint a, ProjectionPoint b) {
        return ProjectionPoint.create(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static ProjectionPoint multiply(ProjectionPoint a, ProjectionPoint b) {
        return ProjectionPoint.create(a.getX() * b.getX(), a.getY() * b.getY());
    }

    public static double cross(ProjectionPoint a, ProjectionPoint b) {
        return a.getX() * b.getY() - b.getX() * a.getY();
    }

    public static double cross(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public static ProjectionPoint normalize(ProjectionPoint a) {
        double d = MapMath.distance(a.getX(), a.getY());
        return ProjectionPoint.create(a.getX() / d, a.getY() / d);
    }

    public static ProjectionPoint negate(ProjectionPoint a) {
        return ProjectionPoint.create(-a.getX(), -a.getY());
    }

    public static double longitudeDistance(double l1, double l2) {
        return Math.min(Math.abs(l1 - l2), (l1 < 0.0 ? l1 + Math.PI : Math.PI - l1) + (l2 < 0.0 ? l2 + Math.PI : Math.PI - l2));
    }

    public static double geocentricLatitude(double lat, double flatness) {
        double f = 1.0 - flatness;
        return Math.atan(f * f * Math.tan(lat));
    }

    public static double geographicLatitude(double lat, double flatness) {
        double f = 1.0 - flatness;
        return Math.atan(Math.tan(lat) / (f * f));
    }

    public static double tsfn(double phi, double sinphi, double e) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= e)) / (1.0 + sinphi), 0.5 * e);
    }

    public static double msfn(double sinphi, double cosphi, double es) {
        return cosphi / Math.sqrt(1.0 - es * sinphi * sinphi);
    }

    public static double phi2(double ts, double e) {
        double dphi;
        double eccnth = 0.5 * e;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        int i = 15;
        do {
            double con = e * Math.sin(phi);
            dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
        } while (Math.abs(dphi) > 1.0E-10 && --i != 0);
        if (i <= 0) {
            throw new RuntimeException();
        }
        return phi;
    }

    public static double[] enfn(double es) {
        double[] en = new double[5];
        en[0] = 1.0 - es * (0.25 + es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        en[1] = es * (0.75 - es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        double t = es * es;
        en[2] = t * (0.46875 - es * (0.013020833333333334 + es * 0.007120768229166667));
        en[3] = (t *= es) * (0.3645833333333333 - es * 0.005696614583333333);
        en[4] = t * es * 0.3076171875;
        return en;
    }

    public static double mlfn(double phi, double sphi, double cphi, double[] en) {
        cphi *= sphi;
        sphi *= sphi;
        return en[0] * phi - cphi * (en[1] + sphi * (en[2] + sphi * (en[3] + sphi * en[4])));
    }

    public static double inv_mlfn(double arg, double es, double[] en) {
        double k = 1.0 / (1.0 - es);
        double phi = arg;
        for (int i = 10; i != 0; --i) {
            double s = Math.sin(phi);
            double t = 1.0 - es * s * s;
            t = (MapMath.mlfn(phi, s, Math.cos(phi), en) - arg) * (t * Math.sqrt(t)) * k;
            phi -= t;
            if (!(Math.abs(t) < 1.0E-11)) continue;
            return phi;
        }
        return phi;
    }

    public static double[] authset(double es) {
        double[] APA = new double[3];
        APA[0] = es * 0.3333333333333333;
        double t = es * es;
        APA[0] = APA[0] + t * 0.17222222222222222;
        APA[1] = t * 0.06388888888888888;
        APA[0] = APA[0] + (t *= es) * 0.10257936507936508;
        APA[1] = APA[1] + t * 0.0664021164021164;
        APA[2] = t * 0.016415012942191543;
        return APA;
    }

    public static double authlat(double beta, double[] APA) {
        double t = beta + beta;
        return beta + APA[0] * Math.sin(t) + APA[1] * Math.sin(t + t) + APA[2] * Math.sin(t + t + t);
    }

    public static double qsfn(double sinphi, double e, double one_es) {
        if (e >= 1.0E-7) {
            double con = e * sinphi;
            return one_es * (sinphi / (1.0 - con * con) - 0.5 / e * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    public static double niceNumber(double x, boolean round) {
        int expv = (int)Math.floor(Math.log(x) / Math.log(10.0));
        double f = x / Math.pow(10.0, expv);
        double nf = round ? (f < 1.5 ? 1.0 : (f < 3.0 ? 2.0 : (f < 7.0 ? 5.0 : 10.0))) : (f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0)));
        return nf * Math.pow(10.0, expv);
    }
}

