/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Formatter;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.geoloc.projection.proj4.MapMath;

@Immutable
public class StereographicAzimuthalProjection
extends AbstractProjection {
    private static final int NORTH_POLE = 1;
    private static final int SOUTH_POLE = 2;
    private static final int EQUATOR = 3;
    private static final int OBLIQUE = 4;
    private static final double TOL = 1.0E-8;
    private final double _latt;
    private final double _lont;
    private final double _trueScaleLat;
    private final double projectionLatitude;
    private final double projectionLongitude;
    private final double n;
    private final double scaleFactor;
    private final double trueScaleLatitude;
    private final double falseEasting;
    private final double falseNorthing;
    private final Earth earth;
    private final double e;
    private final double totalScale;
    private final double akm1;
    private final double sinphi0;
    private final double cosphi0;
    private final int mode;

    public StereographicAzimuthalProjection() {
        this(90.0, 0.0, 0.9330127018922193, 60.0, 0.0, 0.0, EarthEllipsoid.WGS84);
    }

    public StereographicAzimuthalProjection(double latt, double lont, double scale, double trueScaleLat, double false_easting, double false_northing, Earth earth) {
        double takm1;
        double tcosp;
        double tsinp;
        block13: {
            double t;
            block12: {
                super("StereographicAzimuthalProjection", false);
                this._latt = latt;
                this._lont = lont;
                this._trueScaleLat = trueScaleLat;
                this.projectionLatitude = Math.toRadians(latt);
                this.n = Math.abs(Math.sin(this.projectionLatitude));
                this.projectionLongitude = Math.toRadians(lont);
                this.trueScaleLatitude = Math.abs(Math.toRadians(trueScaleLat));
                this.scaleFactor = Math.abs(scale);
                this.falseEasting = false_easting;
                this.falseNorthing = false_northing;
                this.earth = earth;
                this.e = earth.getEccentricity();
                this.totalScale = earth.getMajor() * 0.001;
                t = Math.abs(this.projectionLatitude);
                this.mode = Math.abs(t - 1.5707963267948966) < 1.0E-10 ? (this.projectionLatitude < 0.0 ? 2 : 1) : (t > 1.0E-10 ? 4 : 3);
                tsinp = 0.0;
                tcosp = 0.0;
                if (!earth.isSpherical()) break block12;
                switch (this.mode) {
                    case 4: {
                        tsinp = Math.sin(this.projectionLatitude);
                        tcosp = Math.cos(this.projectionLatitude);
                    }
                    case 3: {
                        takm1 = 2.0 * this.scaleFactor;
                        break block13;
                    }
                    case 1: 
                    case 2: {
                        takm1 = Math.abs(this.trueScaleLatitude - 1.5707963267948966) >= 1.0E-10 ? Math.cos(this.trueScaleLatitude) / Math.tan(0.7853981633974483 - 0.5 * this.trueScaleLatitude) : 2.0 * this.scaleFactor;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (this.mode) {
                case 1: 
                case 2: {
                    if (Math.abs(this.trueScaleLatitude - 1.5707963267948966) < 1.0E-10) {
                        takm1 = 2.0 * this.scaleFactor / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
                        break;
                    }
                    t = Math.sin(this.trueScaleLatitude);
                    takm1 = Math.cos(this.trueScaleLatitude) / MapMath.tsfn(this.trueScaleLatitude, t, this.e);
                    takm1 /= Math.sqrt(1.0 - (t *= this.e) * t);
                    break;
                }
                case 3: {
                    takm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 4: {
                    t = Math.sin(this.projectionLatitude);
                    double X = 2.0 * Math.atan(this.ssfn(this.projectionLatitude, t, this.e)) - 1.5707963267948966;
                    takm1 = 2.0 * this.scaleFactor * Math.cos(this.projectionLatitude) / Math.sqrt(1.0 - (t *= this.e) * t);
                    tsinp = Math.sin(X);
                    tcosp = Math.cos(X);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.akm1 = takm1;
        this.sinphi0 = tsinp;
        this.cosphi0 = tcosp;
        this.addParameter("grid_mapping_name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
    }

    private ProjectionPoint project(double lam, double phi) {
        double coslam = Math.cos(lam);
        double sinlam = Math.sin(lam);
        double sinphi = Math.sin(phi);
        double toX = 0.0;
        double toY = 0.0;
        if (this.earth.isSpherical()) {
            double cosphi = Math.cos(phi);
            switch (this.mode) {
                case 3: {
                    double y = 1.0 + cosphi * coslam;
                    if (y <= 1.0E-10) {
                        throw new RuntimeException("I");
                    }
                    y = this.akm1 / y;
                    double x = y * cosphi * sinlam;
                    toX = x;
                    toY = y *= sinphi;
                    break;
                }
                case 4: {
                    double y = 1.0 + this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (y <= 1.0E-10) {
                        throw new RuntimeException("I");
                    }
                    y = this.akm1 / y;
                    double x = y * cosphi * sinlam;
                    toX = x;
                    toY = y *= this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                    break;
                }
                case 1: {
                    coslam = -coslam;
                    phi = -phi;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-8) {
                        throw new RuntimeException("I");
                    }
                    double y = this.akm1 * Math.tan(0.7853981633974483 + 0.5 * phi);
                    double x = sinlam * y;
                    toX = x;
                    toY = y *= coslam;
                }
            }
        } else {
            double sinX = 0.0;
            double cosX = 0.0;
            if (this.mode == 4 || this.mode == 3) {
                double X = 2.0 * Math.atan(this.ssfn(phi, sinphi, this.e)) - 1.5707963267948966;
                sinX = Math.sin(X);
                cosX = Math.cos(X);
            }
            switch (this.mode) {
                case 4: {
                    double x;
                    double A = this.akm1 / (this.cosphi0 * (1.0 + this.sinphi0 * sinX + this.cosphi0 * cosX * coslam));
                    double y = A * (this.cosphi0 * sinX - this.sinphi0 * cosX * coslam);
                    toX = x = A * cosX;
                    toY = y;
                    break;
                }
                case 3: {
                    double x;
                    double A = 2.0 * this.akm1 / (1.0 + cosX * coslam);
                    double y = A * sinX;
                    toX = x = A * cosX;
                    toY = y;
                    break;
                }
                case 2: {
                    phi = -phi;
                    coslam = -coslam;
                    sinphi = -sinphi;
                }
                case 1: {
                    double x = this.akm1 * MapMath.tsfn(phi, sinphi, this.e);
                    double y = -x * coslam;
                    toX = x;
                    toY = y;
                }
            }
            toX *= sinlam;
        }
        return ProjectionPoint.create(toX, toY);
    }

    private ProjectionPoint projectInverse(double x, double y) {
        double lpx = 0.0;
        double toX = 0.0;
        double toY = 0.0;
        if (this.earth.isSpherical()) {
            double rh = MapMath.distance(x, y);
            double c = 2.0 * Math.atan(rh / this.akm1);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            switch (this.mode) {
                case 3: {
                    double lpy = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinc / rh);
                    if (cosc != 0.0 || x != 0.0) {
                        lpx = Math.atan2(x * sinc, cosc * rh);
                    }
                    toX = lpx;
                    toY = lpy;
                    break;
                }
                case 4: {
                    double lpy = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / rh);
                    c = cosc - this.sinphi0 * Math.sin(lpy);
                    if (c != 0.0 || x != 0.0) {
                        lpx = Math.atan2(x * sinc * this.cosphi0, c * rh);
                    }
                    toX = lpx;
                    toY = lpy;
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    double lpy = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(this.mode == 2 ? -cosc : cosc);
                    toX = lpx = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                    toY = lpy;
                }
            }
        } else {
            double sinphi;
            double halfe;
            double halfpi;
            double phi_l;
            double tp;
            double rho = MapMath.distance(x, y);
            switch (this.mode) {
                case 1: {
                    y = -y;
                }
                case 2: {
                    tp = -rho / this.akm1;
                    phi_l = 1.5707963267948966 - 2.0 * Math.atan(tp);
                    halfpi = -1.5707963267948966;
                    halfe = -0.5 * this.e;
                    break;
                }
                default: {
                    tp = 2.0 * Math.atan2(rho * this.cosphi0, this.akm1);
                    double cosphi = Math.cos(tp);
                    sinphi = Math.sin(tp);
                    phi_l = Math.asin(cosphi * this.sinphi0 + y * sinphi * this.cosphi0 / rho);
                    tp = Math.tan(0.5 * (1.5707963267948966 + phi_l));
                    x *= sinphi;
                    y = rho * this.cosphi0 * cosphi - y * this.sinphi0 * sinphi;
                    halfpi = 1.5707963267948966;
                    halfe = 0.5 * this.e;
                }
            }
            int i = 8;
            while (i-- != 0) {
                sinphi = this.e * Math.sin(phi_l);
                double lpy = 2.0 * Math.atan(tp * Math.pow((1.0 + sinphi) / (1.0 - sinphi), halfe)) - halfpi;
                if (Math.abs(phi_l - lpy) < 1.0E-10) {
                    if (this.mode == 2) {
                        lpy = -lpy;
                    }
                    toX = lpx = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                    toY = lpy;
                    return ProjectionPoint.create(toX, toY);
                }
                phi_l = lpy;
            }
            throw new RuntimeException("Iteration didn't converge");
        }
        return ProjectionPoint.create(toX, toY);
    }

    private double ssfn(double phit, double sinphi, double eccen) {
        return Math.tan(0.5 * (1.5707963267948966 + phit)) * Math.pow((1.0 - (sinphi *= eccen)) / (1.0 + sinphi), 0.5 * eccen);
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Stereographic Azimuthal Ellipsoidal Earth";
    }

    @Override
    public Projection constructCopy() {
        return new StereographicAzimuthalProjection(this._latt, this._lont, this.scaleFactor, this._trueScaleLat, this.falseEasting, this.falseNorthing, this.earth);
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat,lon=%f,%f scale,trueScaleLat=%f,%f earth=%s", this._latt, this._lont, this.scaleFactor, this._trueScaleLat, this.earth);
        return f.toString();
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double fromLat = Math.toRadians(latLon.getLatitude());
        double theta = this.computeTheta(latLon.getLongitude());
        ProjectionPoint res = this.project(theta, fromLat);
        return ProjectionPoint.create(this.totalScale * res.getX() + this.falseEasting, this.totalScale * res.getY() + this.falseNorthing);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        ProjectionPoint pt = this.projectInverse(fromX, fromY);
        double toLon = pt.getX();
        double toLat = pt.getY();
        if (toLon < -Math.PI) {
            toLon = -Math.PI;
        } else if (toLon > Math.PI) {
            toLon = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            toLon = MapMath.normalizeLongitude(toLon + this.projectionLongitude);
        }
        return LatLonPoint.create(Math.toDegrees(toLat), Math.toDegrees(toLon));
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof StereographicAzimuthalProjection)) {
            return false;
        }
        StereographicAzimuthalProjection oo = (StereographicAzimuthalProjection)proj;
        return this.projectionLatitude == oo.projectionLatitude && this.projectionLongitude == oo.projectionLongitude && this.scaleFactor == oo.scaleFactor && this.trueScaleLatitude == oo.trueScaleLatitude && this.falseEasting == oo.falseEasting && this.falseNorthing == oo.falseNorthing && this.earth.equals(oo.earth);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.projectionLatitude) ^ Double.doubleToLongBits(this.projectionLatitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.projectionLongitude) ^ Double.doubleToLongBits(this.projectionLongitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.scaleFactor) ^ Double.doubleToLongBits(this.scaleFactor) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.trueScaleLatitude) ^ Double.doubleToLongBits(this.trueScaleLatitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.falseEasting) ^ Double.doubleToLongBits(this.falseEasting) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.falseNorthing) ^ Double.doubleToLongBits(this.falseNorthing) >>> 32);
        hash = 67 * hash + (this.earth != null ? this.earth.hashCode() : 0);
        return hash;
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPoints.lonNormal(lon - Math.toDegrees(this.projectionLongitude));
        return this.n * Math.toRadians(dlon);
    }
}

