/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;

class BoundingBoxHelper {
    private final double maxR;
    private final double maxR2;
    private final Projection proj;

    BoundingBoxHelper(Projection proj, double maxR) {
        this.proj = proj;
        this.maxR = maxR;
        this.maxR2 = maxR * maxR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        ProjectionPoint llpt = this.proj.latLonToProj(rect.getLowerLeftPoint());
        ProjectionPoint urpt = this.proj.latLonToProj(rect.getUpperRightPoint());
        ProjectionPoint lrpt = this.proj.latLonToProj(rect.getLowerRightPoint());
        ProjectionPoint ulpt = this.proj.latLonToProj(rect.getUpperLeftPoint());
        ArrayList<ProjectionPoint> goodPts = new ArrayList<ProjectionPoint>(4);
        int countBad = 0;
        if (!this.addGoodPts(goodPts, llpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, urpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, lrpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, ulpt)) {
            ++countBad;
        }
        if (countBad == 2) {
            if (!LatLonPoints.isInfinite(llpt) && !LatLonPoints.isInfinite(lrpt)) {
                this.addGoodPts(goodPts, ProjectionPoint.create(0.0, this.maxR));
                return this.makeRect(goodPts);
            } else if (!LatLonPoints.isInfinite(ulpt) && !LatLonPoints.isInfinite(llpt)) {
                this.addGoodPts(goodPts, ProjectionPoint.create(this.maxR, 0.0));
                return this.makeRect(goodPts);
            } else if (!LatLonPoints.isInfinite(ulpt) && !LatLonPoints.isInfinite(urpt)) {
                this.addGoodPts(goodPts, ProjectionPoint.create(0.0, -this.maxR));
                return this.makeRect(goodPts);
            } else {
                if (LatLonPoints.isInfinite(urpt) || LatLonPoints.isInfinite(lrpt)) throw new IllegalStateException();
                this.addGoodPts(goodPts, ProjectionPoint.create(-this.maxR, 0.0));
            }
            return this.makeRect(goodPts);
        } else {
            if (countBad != 3) return this.makeRect(goodPts);
            if (!LatLonPoints.isInfinite(llpt)) {
                double xcoord = llpt.getX();
                this.addGoodPts(goodPts, ProjectionPoint.create(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = llpt.getY();
                this.addGoodPts(goodPts, ProjectionPoint.create(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!LatLonPoints.isInfinite(urpt)) {
                double xcoord = urpt.getX();
                this.addGoodPts(goodPts, ProjectionPoint.create(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = urpt.getY();
                this.addGoodPts(goodPts, ProjectionPoint.create(-this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!LatLonPoints.isInfinite(ulpt)) {
                double xcoord = ulpt.getX();
                this.addGoodPts(goodPts, ProjectionPoint.create(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = ulpt.getY();
                this.addGoodPts(goodPts, ProjectionPoint.create(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else {
                if (LatLonPoints.isInfinite(lrpt)) throw new IllegalStateException();
                double xcoord = lrpt.getX();
                this.addGoodPts(goodPts, ProjectionPoint.create(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = lrpt.getY();
                this.addGoodPts(goodPts, ProjectionPoint.create(-this.getLimitCoord(ycoord), ycoord));
            }
        }
        return this.makeRect(goodPts);
    }

    private boolean addGoodPts(List<ProjectionPoint> goodPts, ProjectionPoint pt) {
        if (!LatLonPoints.isInfinite(pt)) {
            goodPts.add(pt);
            return true;
        }
        return false;
    }

    private double getLimitCoord(double coord) {
        return Math.sqrt(this.maxR2 - coord * coord);
    }

    private ProjectionRect makeRect(List<ProjectionPoint> goodPts) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        for (ProjectionPoint pp : goodPts) {
            minx = Math.min(minx, pp.getX());
            maxx = Math.max(maxx, pp.getX());
            miny = Math.min(miny, pp.getY());
            maxy = Math.max(maxy, pp.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }
}

