/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.geoloc.projection.sat.BoundingBoxHelper;

@Immutable
public class VerticalPerspectiveView
extends AbstractProjection {
    private final double lat0;
    private final double lon0;
    private final double false_east;
    private final double false_north;
    private final double R;
    private final double H;
    private final double P;
    private final double lon0Degrees;
    private final double cosLat0;
    private final double sinLat0;
    private final double maxR;

    @Override
    public Projection constructCopy() {
        return new VerticalPerspectiveView(this.getOriginLat(), this.getOriginLon(), this.R, this.getHeight(), this.false_east, this.false_north);
    }

    public VerticalPerspectiveView() {
        this(0.0, 0.0, 6371.229, 35800.0);
    }

    public VerticalPerspectiveView(double lat0, double lon0, double earthRadius, double distance) {
        this(lat0, lon0, earthRadius, distance, 0.0, 0.0);
    }

    public VerticalPerspectiveView(double lat0, double lon0, double earthRadius, double distance, double false_easting, double false_northing) {
        super("VerticalPerspectiveView", false);
        this.lon0Degrees = lon0;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.R = earthRadius;
        this.H = distance;
        this.false_east = false_easting;
        this.false_north = false_northing;
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.P = 1.0 + this.H / this.R;
        this.maxR = 0.99 * this.R * Math.sqrt((this.P - 1.0) / (this.P + 1.0));
        this.addParameter("grid_mapping_name", "vertical_perspective");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("earth_radius", earthRadius * 1000.0);
        this.addParameter("perspective_point_height", distance * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerticalPerspectiveView that = (VerticalPerspectiveView)o;
        if (Double.compare(that.H, this.H) != 0) {
            return false;
        }
        if (Double.compare(that.R, this.R) != 0) {
            return false;
        }
        if (Double.compare(that.false_east, this.false_east) != 0) {
            return false;
        }
        if (Double.compare(that.false_north, this.false_north) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        return Double.compare(that.lon0, this.lon0) == 0;
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.false_east != 0.0 ? Double.doubleToLongBits(this.false_east) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.false_north != 0.0 ? Double.doubleToLongBits(this.false_north) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.R != 0.0 ? Double.doubleToLongBits(this.R) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.H != 0.0 ? Double.doubleToLongBits(this.H) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getHeight() {
        return this.H;
    }

    public double getOriginLon() {
        return Math.toDegrees(this.lon0);
    }

    public double getOriginLat() {
        return Math.toDegrees(this.lat0);
    }

    public double getP() {
        return this.P;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "VerticalPerspectiveView";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "VerticalPerspectiveView{lat0=" + this.lat0 + ", lon0=" + this.lon0 + ", false_east=" + this.false_east + ", false_north=" + this.false_north + ", R=" + this.R + ", H=" + this.H + ", P=" + this.P + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPoints.lonNormal(fromLon - this.lon0Degrees));
        double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        double ksp = (this.P - 1.0) / (this.P - cosc);
        if (cosc < 1.0 / this.P) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.false_east + this.R * ksp * Math.cos(fromLat) * Math.sin(lonDiff);
            toY = this.false_north + this.R * ksp * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
        }
        return ProjectionPoint.create(toX, toY);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt((fromX -= this.false_east) * fromX + (fromY -= this.false_north) * fromY);
        double r = rho / this.R;
        double con = this.P - 1.0;
        double com = this.P + 1.0;
        double c = Math.asin((this.P - Math.sqrt(1.0 - r * r * com / con)) / (con / r + r / con));
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (Double.compare(this.lat0, 0.7853981633974483) == 0) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPoints.lonNormal(toLon);
        return LatLonPoint.create(toLat, toLon);
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        BoundingBoxHelper bbhelper = new BoundingBoxHelper(this, this.maxR);
        return bbhelper.latLonToProjBB(rect);
    }
}

