/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.VerticalTransformSubset;
import ucar.unidata.util.Parameter;

@Immutable
abstract class AbstractVerticalTransform
implements VerticalTransform {
    protected final String units;
    private final Dimension timeDim;

    AbstractVerticalTransform(Dimension timeDim, @Nullable String units) {
        this.timeDim = timeDim;
        this.units = units;
    }

    @Override
    public abstract ArrayDouble.D3 getCoordinateArray(int var1) throws IOException, InvalidRangeException;

    @Override
    public abstract ArrayDouble.D1 getCoordinateArray1D(int var1, int var2, int var3) throws IOException, InvalidRangeException;

    @Override
    @Nullable
    public String getUnitString() {
        return this.units;
    }

    @Override
    public boolean isTimeDependent() {
        return this.timeDim != null;
    }

    protected Dimension getTimeDimension() {
        return this.timeDim;
    }

    Array readArray(Variable v, int timeIndex) throws IOException, InvalidRangeException {
        int dimIndex;
        int[] shape = v.getShape();
        int[] origin = new int[v.getRank()];
        if (this.getTimeDimension() != null && (dimIndex = v.findDimensionIndex(this.getTimeDimension().getShortName())) >= 0) {
            shape[dimIndex] = 1;
            origin[dimIndex] = timeIndex;
            return v.read(origin, shape).reduce(dimIndex);
        }
        return v.read(origin, shape);
    }

    @Override
    public VerticalTransform subset(Range t_range, Range z_range, Range y_range, Range x_range) {
        return new VerticalTransformSubset(this, t_range, z_range, y_range, x_range);
    }

    static Variable findVariableFromParameterName(NetcdfFile ds, List<Parameter> params, String paramName) {
        String vName = AbstractVerticalTransform.getParameterStringValue(params, paramName);
        Preconditions.checkNotNull((Object)vName, (Object)String.format("VerticalTransform parameter %s not found", paramName));
        Variable v = ds.findVariable(vName);
        Preconditions.checkNotNull((Object)v, (Object)String.format("VerticalTransform variable %s not found", vName));
        return v;
    }

    @Nullable
    static String getParameterStringValue(List<Parameter> params, String name) {
        for (Parameter a : params) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a.getStringValue();
        }
        return null;
    }

    static boolean getParameterBooleanValue(List<Parameter> params, String name) {
        for (Parameter p : params) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return Boolean.parseBoolean(p.getStringValue());
        }
        return false;
    }

    static double readAndConvertUnit(Variable scalarVariable, String convertToUnit) {
        double result;
        try {
            result = scalarVariable.readScalarDouble();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("VerticalTransform failed to read " + scalarVariable + " err= " + e.getMessage());
        }
        String scalarUnitStr = scalarVariable.findAttributeString("units", null);
        if (scalarUnitStr != null && !convertToUnit.equalsIgnoreCase(scalarUnitStr)) {
            double factor = AbstractVerticalTransform.convertUnitFactor(scalarUnitStr, convertToUnit);
            result *= factor;
        }
        return result;
    }

    static double convertUnitFactor(String unit, String convertToUnit) {
        SimpleUnit wantUnit = SimpleUnit.factory(convertToUnit);
        SimpleUnit haveUnit = SimpleUnit.factory(unit);
        return haveUnit.convertTo(1.0, wantUnit);
    }
}

