/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.IndexIterator;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class AtmosLnPressure
extends AbstractVerticalTransform {
    public static final String P0 = "ReferencePressureVariableName";
    public static final String LEV = "VerticalCoordinateVariableName";
    private final Array pressure;

    public static AtmosLnPressure create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        ArrayDouble.D1 pressure;
        double p0;
        Variable p0var = AtmosLnPressure.findVariableFromParameterName(ds, params, P0);
        try {
            p0 = p0var.readScalarDouble();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosLnPressure failed to read " + p0var.getShortName() + " err= " + e.getMessage());
        }
        String units = p0var.getUnitsString();
        Variable levVar = AtmosLnPressure.findVariableFromParameterName(ds, params, LEV);
        try {
            Array lev = levVar.read();
            assert (lev.getRank() == 1);
            pressure = new ArrayDouble.D1((int)lev.getSize());
            IndexIterator ii = pressure.getIndexIterator();
            while (lev.hasNext()) {
                double result = p0 * Math.exp(-lev.nextDouble());
                ii.setDoubleNext(result);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosLnPressure failed to read " + levVar.getShortName() + " err= " + e.getMessage());
        }
        return new AtmosLnPressure(timeDim, units, pressure);
    }

    private AtmosLnPressure(Dimension timeDim, String units, Array pressure) {
        super(timeDim, units);
        this.pressure = pressure;
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) {
        int nz = (int)this.pressure.getSize();
        int[] shape2D = this.pressure.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        ArrayDouble.D3 result = new ArrayDouble.D3(nz, ny, nx);
        IndexIterator ii = this.pressure.getIndexIterator();
        for (int z = 0; z < nz; ++z) {
            double p = ii.getDoubleNext();
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    result.set(z, y, x, p);
                }
            }
        }
        return result;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) {
        throw new UnsupportedOperationException("1D subsetting is not implemented yet for this vertical tranformation");
    }
}

