/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class AtmosSigma
extends AbstractVerticalTransform {
    public static final String PTOP = "PressureTop_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String SIGMA = "Sigma_variableName";
    private final Variable psVar;
    private final double[] sigma;
    private final double ptop;

    public static AtmosSigma create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        double[] sigma;
        Variable psVar = AtmosSigma.findVariableFromParameterName(ds, params, PS);
        String units = psVar.findAttributeString("units", "none");
        Variable ptopVar = AtmosSigma.findVariableFromParameterName(ds, params, PTOP);
        double ptop = AtmosSigma.readAndConvertUnit(ptopVar, units);
        Variable sigmaVar = AtmosSigma.findVariableFromParameterName(ds, params, SIGMA);
        try {
            Array data = sigmaVar.read();
            sigma = (double[])data.get1DJavaArray(Double.TYPE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosSigma failed to read " + sigmaVar + " err= " + e.getMessage());
        }
        return new AtmosSigma(timeDim, units, psVar, sigma, ptop);
    }

    private AtmosSigma(Dimension timeDim, String units, Variable psVar, double[] sigma, double ptop) {
        super(timeDim, units);
        this.psVar = psVar;
        this.sigma = sigma;
        this.ptop = ptop;
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array ps = this.readArray(this.psVar, timeIndex);
        Index psIndex = ps.getIndex();
        int nz = this.sigma.length;
        int[] shape2D = ps.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        ArrayDouble.D3 result = new ArrayDouble.D3(nz, ny, nx);
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double psVal = ps.getDouble(psIndex.set(y, x));
                for (int z = 0; z < nz; ++z) {
                    result.set(z, y, x, this.ptop + this.sigma[z] * (psVal - this.ptop));
                }
            }
        }
        return result;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array ps = this.readArray(this.psVar, timeIndex);
        Index psIndex = ps.getIndex();
        int nz = this.sigma.length;
        ArrayDouble.D1 result = new ArrayDouble.D1(nz);
        double psVal = ps.getDouble(psIndex.set(yIndex, xIndex));
        for (int z = 0; z < nz; ++z) {
            result.set(z, this.ptop + this.sigma[z] * (psVal - this.ptop));
        }
        return result;
    }
}

