/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class HybridHeight
extends AbstractVerticalTransform {
    public static final String OROG = "Orography_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private final Variable aVar;
    private final Variable bVar;
    private final Variable orogVar;

    public static HybridHeight create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        Variable aVar = HybridHeight.findVariableFromParameterName(ds, params, A);
        Variable bVar = HybridHeight.findVariableFromParameterName(ds, params, B);
        Variable orogVar = HybridHeight.findVariableFromParameterName(ds, params, OROG);
        String units = orogVar.findAttributeString("units", "none");
        return new HybridHeight(timeDim, units, aVar, bVar, orogVar);
    }

    private HybridHeight(Dimension timeDim, String units, Variable aVar, Variable bVar, Variable orogVar) {
        super(timeDim, units);
        this.aVar = aVar;
        this.bVar = bVar;
        this.orogVar = orogVar;
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array orogArray = this.readArray(this.orogVar, timeIndex);
        Array aArray = this.aVar.read();
        Array bArray = this.bVar.read();
        int nz = (int)aArray.getSize();
        Index aIndex = aArray.getIndex();
        Index bIndex = bArray.getIndex();
        int[] shape2D = orogArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index orogIndex = orogArray.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double az = aArray.getDouble(aIndex.set(z));
            double bz = bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double orog = orogArray.getDouble(orogIndex.set(y, x));
                    height.set(z, y, x, az + bz * orog);
                }
            }
        }
        return height;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array orogArray = this.readArray(this.orogVar, timeIndex);
        Array aArray = this.aVar.read();
        Array bArray = this.bVar.read();
        int nz = (int)aArray.getSize();
        Index aIndex = aArray.getIndex();
        Index bIndex = bArray.getIndex();
        Index orogIndex = orogArray.getIndex();
        ArrayDouble.D1 height = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double az = aArray.getDouble(aIndex.set(z));
            double bz = bArray.getDouble(bIndex.set(z));
            double orog = orogArray.getDouble(orogIndex.set(yIndex, xIndex));
            height.set(z, az + bz * orog);
        }
        return height;
    }
}

