/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class HybridSigmaPressure
extends AbstractVerticalTransform {
    public static final String P0 = "P0_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String A = "A_variableName";
    public static final String AP = "AP_variableName";
    public static final String B = "B_variableName";
    private final Variable aVar;
    private final Variable bVar;
    private final Variable psVar;
    private final double scaleA;

    public static HybridSigmaPressure create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        double scaleA;
        Variable aVar;
        Variable psVar = HybridSigmaPressure.findVariableFromParameterName(ds, params, PS);
        String units = psVar.findAttributeString("units", "none");
        String aName = HybridSigmaPressure.getParameterStringValue(params, A);
        String apName = HybridSigmaPressure.getParameterStringValue(params, AP);
        Preconditions.checkArgument((aName != null || apName != null ? 1 : 0) != 0, (Object)String.format("HybridSigmaPressure %s or %s parameter must be set", A, AP));
        if (apName != null) {
            aVar = ds.findVariable(apName);
            Preconditions.checkNotNull((Object)aVar, (Object)String.format("HybridSigmaPressure %s not found", apName));
            String apUnits = aVar.findAttributeString("units", null);
            scaleA = apUnits == null ? 1.0 : HybridSigmaPressure.convertUnitFactor(apUnits, units);
        } else {
            aVar = ds.findVariable(aName);
            Preconditions.checkNotNull((Object)aVar, (Object)String.format("HybridSigmaPressure %s not found", aName));
            Variable p0Var = HybridSigmaPressure.findVariableFromParameterName(ds, params, P0);
            scaleA = HybridSigmaPressure.readAndConvertUnit(p0Var, units);
        }
        Variable bVar = HybridSigmaPressure.findVariableFromParameterName(ds, params, B);
        return new HybridSigmaPressure(timeDim, units, aVar, bVar, psVar, scaleA);
    }

    private HybridSigmaPressure(Dimension timeDim, String units, Variable aVar, Variable bVar, Variable psVar, double scaleA) {
        super(timeDim, units);
        this.psVar = psVar;
        this.aVar = aVar;
        this.bVar = bVar;
        this.scaleA = scaleA;
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        Array aArray = this.aVar.read();
        Array bArray = this.bVar.read();
        int nz = (int)aArray.getSize();
        Index aIndex = aArray.getIndex();
        Index bIndex = bArray.getIndex();
        if (psArray.getRank() == 3) {
            psArray = psArray.reduce(0);
        }
        int[] shape2D = psArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index psIndex = psArray.getIndex();
        ArrayDouble.D3 press = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double term1 = aArray.getDouble(aIndex.set(z)) * this.scaleA;
            double bz = bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double ps = psArray.getDouble(psIndex.set(y, x));
                    press.set(z, y, x, term1 + bz * ps);
                }
            }
        }
        return press;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        Array aArray = this.aVar.read();
        Array bArray = this.bVar.read();
        int nz = (int)aArray.getSize();
        Index aIndex = aArray.getIndex();
        Index bIndex = bArray.getIndex();
        if (psArray.getRank() == 3) {
            psArray = psArray.reduce(0);
        }
        Index psIndex = psArray.getIndex();
        ArrayDouble.D1 press = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double term1 = aArray.getDouble(aIndex.set(z)) * this.scaleA;
            double bz = bArray.getDouble(bIndex.set(z));
            double ps = psArray.getDouble(psIndex.set(yIndex, xIndex));
            press.set(z, term1 + bz * ps);
        }
        return press;
    }
}

