/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class OceanSG1
extends AbstractVerticalTransform {
    public static final String ETA = "Eta_variableName";
    public static final String S = "S_variableName";
    public static final String DEPTH = "Depth_variableName";
    public static final String DEPTH_C = "Depth_c_variableName";
    public static final String C = "c_variableName";
    private final double depth_c;
    private final Variable etaVar;
    private final Variable sVar;
    private final Variable depthVar;
    private final Variable cVar;

    public static OceanSG1 create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        Variable etaVar = OceanSG1.findVariableFromParameterName(ds, params, ETA);
        Variable sVar = OceanSG1.findVariableFromParameterName(ds, params, S);
        Variable depthVar = OceanSG1.findVariableFromParameterName(ds, params, DEPTH);
        Variable depthCVar = OceanSG1.findVariableFromParameterName(ds, params, DEPTH_C);
        Variable cVar = OceanSG1.findVariableFromParameterName(ds, params, C);
        String units = depthVar.findAttributeString("units", "none");
        return new OceanSG1(timeDim, units, etaVar, sVar, depthVar, depthCVar, cVar);
    }

    private OceanSG1(Dimension timeDim, String units, Variable etaVar, Variable sVar, Variable depthVar, Variable depthCVar, Variable cVar) {
        super(timeDim, units);
        this.etaVar = etaVar;
        this.sVar = sVar;
        this.depthVar = depthVar;
        this.cVar = cVar;
        try {
            this.depth_c = depthCVar.readScalarDouble();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array etaArray = this.readArray(this.etaVar, timeIndex);
        Array sArray = this.readArray(this.sVar, timeIndex);
        Array depthArray = this.readArray(this.depthVar, timeIndex);
        Array cArray = this.readArray(this.cVar, timeIndex);
        return this.makeHeight(etaArray, sArray, depthArray, cArray, this.depth_c);
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array etaArray = this.readArray(this.etaVar, timeIndex);
        Array sArray = this.readArray(this.sVar, timeIndex);
        Array depthArray = this.readArray(this.depthVar, timeIndex);
        Array cArray = this.readArray(this.cVar, timeIndex);
        return this.makeHeight1D(etaArray, sArray, depthArray, cArray, this.depth_c, xIndex, yIndex);
    }

    private ArrayDouble.D3 makeHeight(Array eta, Array s, Array depth, Array c, double depth_c) {
        int nz = (int)s.getSize();
        Index sIndex = s.getIndex();
        Index cIndex = c.getIndex();
        int[] shape2D = eta.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double sz = s.getDouble(sIndex.set(z));
            double cz = c.getDouble(cIndex.set(z));
            double term1 = depth_c * sz;
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double fac1 = depth.getDouble(depthIndex.set(y, x));
                    double term2 = (fac1 - depth_c) * cz;
                    double Sterm = term1 + term2;
                    double term3 = eta.getDouble(etaIndex.set(y, x));
                    double term4 = 1.0 + Sterm / fac1;
                    double hterm = Sterm + term3 * term4;
                    height.set(z, y, x, hterm);
                }
            }
        }
        return height;
    }

    private ArrayDouble.D1 makeHeight1D(Array eta, Array s, Array depth, Array c, double depth_c, int x_index, int y_index) {
        int nz = (int)s.getSize();
        Index sIndex = s.getIndex();
        Index cIndex = c.getIndex();
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D1 height = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double sz = s.getDouble(sIndex.set(z));
            double cz = c.getDouble(cIndex.set(z));
            double term1 = depth_c * sz;
            double fac1 = depth.getDouble(depthIndex.set(y_index, x_index));
            double term2 = (fac1 - depth_c) * cz;
            double Sterm = term1 + term2;
            double term3 = eta.getDouble(etaIndex.set(y_index, x_index));
            double term4 = 1.0 + Sterm / fac1;
            double hterm = Sterm + term3 * term4;
            height.set(z, hterm);
        }
        return height;
    }
}

