/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.AbstractVerticalTransform;
import ucar.unidata.util.Parameter;

public class OceanSigma
extends AbstractVerticalTransform {
    public static final String ETA = "Eta_variableName";
    public static final String SIGMA = "Sigma_variableName";
    public static final String DEPTH = "Depth_variableName";
    private final Variable etaVar;
    private final Variable sVar;
    private final Variable depthVar;

    public static OceanSigma create(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        Variable etaVar = OceanSigma.findVariableFromParameterName(ds, params, ETA);
        Variable sVar = OceanSigma.findVariableFromParameterName(ds, params, SIGMA);
        Variable depthVar = OceanSigma.findVariableFromParameterName(ds, params, DEPTH);
        String units = depthVar.findAttributeString("units", "none");
        return new OceanSigma(timeDim, units, etaVar, sVar, depthVar);
    }

    private OceanSigma(Dimension timeDim, String units, Variable etaVar, Variable sVar, Variable depthVar) {
        super(timeDim, units);
        this.etaVar = etaVar;
        this.sVar = sVar;
        this.depthVar = depthVar;
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array eta = this.readArray(this.etaVar, timeIndex);
        Array sigma = this.readArray(this.sVar, timeIndex);
        Array depth = this.readArray(this.depthVar, timeIndex);
        int nz = (int)sigma.getSize();
        Index sIndex = sigma.getIndex();
        int[] shape2D = eta.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double sigmaVal = sigma.getDouble(sIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double etaVal = eta.getDouble(etaIndex.set(y, x));
                    double depthVal = depth.getDouble(depthIndex.set(y, x));
                    height.set(z, y, x, etaVal + sigmaVal * (depthVal + etaVal));
                }
            }
        }
        return height;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array eta = this.readArray(this.etaVar, timeIndex);
        Array sigma = this.readArray(this.sVar, timeIndex);
        Array depth = this.readArray(this.depthVar, timeIndex);
        int nz = (int)sigma.getSize();
        Index sIndex = sigma.getIndex();
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D1 height = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double sigmaVal = sigma.getDouble(sIndex.set(z));
            double etaVal = eta.getDouble(etaIndex.set(yIndex, xIndex));
            double depthVal = depth.getDouble(depthIndex.set(yIndex, xIndex));
            height.set(z, etaVal + sigmaVal * (depthVal + etaVal));
        }
        return height;
    }
}

