/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PositioningDataInputStream {
    private final DataInputStream delegate;
    private long cpos;

    public PositioningDataInputStream(InputStream is) {
        this.delegate = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
    }

    private void seek(long pos) throws IOException {
        if (pos < this.cpos) {
            throw new IllegalArgumentException("Cannot go backwards; current=" + this.cpos + " request=" + pos);
        }
        for (long want = pos - this.cpos; want > 0L; want -= this.delegate.skip(want)) {
        }
        this.cpos = pos;
    }

    public void read(long pos, byte[] dest, int off, int len) throws IOException {
        this.seek(pos);
        this.delegate.readFully(dest, off, len);
        this.cpos += (long)len;
    }

    public void readShort(long pos, short[] dest, int off, int len) throws IOException {
        this.seek(pos);
        for (int i = 0; i < len; ++i) {
            dest[off + i] = this.delegate.readShort();
        }
        this.cpos += (long)(len * 2);
    }

    public void readInt(long pos, int[] dest, int off, int len) throws IOException {
        this.seek(pos);
        for (int i = 0; i < len; ++i) {
            dest[off + i] = this.delegate.readInt();
        }
        this.cpos += (long)(len * 4);
    }

    public void readLong(long pos, long[] dest, int off, int len) throws IOException {
        this.seek(pos);
        for (int i = 0; i < len; ++i) {
            dest[off + i] = this.delegate.readLong();
        }
        this.cpos += (long)(len * 8);
    }

    public void readFloat(long pos, float[] dest, int off, int len) throws IOException {
        this.seek(pos);
        for (int i = 0; i < len; ++i) {
            dest[off + i] = this.delegate.readFloat();
        }
        this.cpos += (long)(len * 4);
    }

    public void readDouble(long pos, double[] dest, int off, int len) throws IOException {
        this.seek(pos);
        for (int i = 0; i < len; ++i) {
            dest[off + i] = this.delegate.readDouble();
        }
        this.cpos += (long)(len * 8);
    }
}

