/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import ucar.nc2.util.IO;

public class ReadFromUrl {
    private static final boolean showStackTrace = false;
    private static final boolean showHeaders = false;

    public static long copyUrlB(String urlString, OutputStream out, int bufferSize) throws IOException {
        long count;
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            int responseCode;
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConnection = null;
            if (connection instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)connection;
                httpConnection.addRequestProperty("Accept-Encoding", "gzip");
            }
            if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            try (InputStream is = connection.getInputStream();){
                BufferedInputStream bis = "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(is), 8000) : new BufferedInputStream(is, 8000);
                count = out == null ? IO.copy2null(bis, bufferSize) : IO.copyB(bis, out, bufferSize);
            }
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
        return count;
    }

    private static void showRequestHeaders(String urlString, URLConnection connection) {
        System.out.println("\nREQUEST Properties for " + urlString + ": ");
        Map<String, List<String>> reqs = connection.getRequestProperties();
        for (Map.Entry<String, List<String>> entry : reqs.entrySet()) {
            System.out.printf(" %s:", entry.getKey());
            for (String v : entry.getValue()) {
                System.out.printf("%s,", v);
            }
            System.out.printf("%n", new Object[0]);
        }
    }

    public static InputStream getInputStreamFromUrl(String urlString) throws IOException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            InputStream is;
            block11: {
                int responseCode;
                URLConnection connection = url.openConnection();
                HttpURLConnection httpConnection = null;
                if (connection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)connection;
                    httpConnection.addRequestProperty("Accept-Encoding", "gzip");
                }
                if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                    throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
                }
                is = null;
                try {
                    is = connection.getInputStream();
                    if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                        is = new BufferedInputStream(new GZIPInputStream(is), 1000);
                    }
                }
                catch (Throwable t) {
                    if (is == null) break block11;
                    is.close();
                }
            }
            return is;
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
    }

    public static String readURLcontents(String urlString) {
        try {
            return ReadFromUrl.readURLcontentsWithException(urlString);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private static String readURLcontentsWithException(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(20000);
        ReadFromUrl.copyUrlB(urlString, bout, 20000);
        return bout.toString("UTF-8");
    }
}

