/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

public class Format {
    public static void tab(StringBuilder sbuff, int tabStop, boolean alwaysOne) {
        int len = sbuff.length();
        if (tabStop > len) {
            sbuff.setLength(tabStop);
            for (int i = len; i < tabStop; ++i) {
                sbuff.setCharAt(i, ' ');
            }
        } else if (alwaysOne) {
            sbuff.setLength(len + 1);
            sbuff.setCharAt(len, ' ');
        }
    }

    public static String s(String s, int width) {
        return Format.pad(s, width, false);
    }

    public static String pad(String s, int width, boolean rightJustify) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder sbuff = new StringBuilder(width);
        int need = width - s.length();
        sbuff.setLength(need);
        for (int i = 0; i < need; ++i) {
            sbuff.setCharAt(i, ' ');
        }
        if (rightJustify) {
            sbuff.append(s);
        } else {
            sbuff.insert(0, s);
        }
        return sbuff.toString();
    }

    public static String i(int v, int width) {
        return Format.pad(Integer.toString(v), width, true);
    }

    public static String l(long v, int width) {
        return Format.pad(Long.toString(v), width, true);
    }

    public static String d(double d, int min_sigfig) {
        return Format.formatDouble(d, min_sigfig, -1).trim();
    }

    public static String d(double d, int min_sigfig, int width) {
        String s = Format.d(d, min_sigfig);
        return Format.pad(s, width, true);
    }

    public static String dfrac(double d, int fixed_decimals) {
        return Format.formatDouble(d, 100, fixed_decimals).trim();
    }

    public static String formatDouble(double d, int min_sigFigs, int fixed_decimals) {
        StringBuilder fraction;
        StringBuilder number;
        String exponent;
        String mantissa;
        String unsigned;
        String sign;
        String s = Double.toString(d);
        if (s.startsWith("-") || s.startsWith("+")) {
            sign = s.substring(0, 1);
            unsigned = s.substring(1);
        } else {
            sign = "";
            unsigned = s;
        }
        int eInd = unsigned.indexOf(69);
        if (eInd == -1) {
            eInd = unsigned.indexOf(101);
        }
        if (eInd == -1) {
            mantissa = unsigned;
            exponent = "";
        } else {
            mantissa = unsigned.substring(0, eInd);
            exponent = unsigned.substring(eInd);
        }
        int dotInd = mantissa.indexOf(46);
        if (dotInd == -1) {
            number = new StringBuilder(mantissa);
            fraction = new StringBuilder();
        } else {
            number = new StringBuilder(mantissa.substring(0, dotInd));
            fraction = new StringBuilder(mantissa.substring(dotInd + 1));
        }
        int numFigs = number.length();
        int fracFigs = fraction.length();
        if (fixed_decimals != -1) {
            if (fixed_decimals == 0) {
                fraction.setLength(0);
            } else if (fixed_decimals > fracFigs) {
                int want = fixed_decimals - fracFigs;
                for (int i = 0; i < want; ++i) {
                    fraction.append("0");
                }
            } else if (fixed_decimals < fracFigs) {
                int chop = fracFigs - fixed_decimals;
                fraction.setLength(fraction.length() - chop);
            }
        } else {
            int sigFigs;
            int i;
            if ((numFigs == 0 || number.toString().equals("0")) && fracFigs > 0) {
                numFigs = 0;
                number = new StringBuilder();
                for (i = 0; i < fraction.length() && fraction.charAt(i) == '0'; ++i) {
                    --fracFigs;
                }
            }
            if (fracFigs == 0 && numFigs > 0) {
                for (i = number.length() - 1; i > 0 && number.charAt(i) == '0'; --i) {
                    --numFigs;
                }
            }
            if ((sigFigs = numFigs + fracFigs) > min_sigFigs) {
                int chop = Math.min(sigFigs - min_sigFigs, fracFigs);
                fraction.setLength(fraction.length() - chop);
            }
        }
        if (fraction.length() == 0) {
            return sign + number + exponent;
        }
        return sign + number + "." + fraction + exponent;
    }

    public static String formatByteSize(double size) {
        String unit;
        if (size > 1.0E15) {
            unit = "Pbytes";
            size *= 1.0E-15;
        } else if (size > 1.0E12) {
            unit = "Tbytes";
            size *= 1.0E-12;
        } else if (size > 1.0E9) {
            unit = "Gbytes";
            size *= 1.0E-9;
        } else if (size > 1000000.0) {
            unit = "Mbytes";
            size *= 1.0E-6;
        } else if (size > 1000.0) {
            unit = "Kbytes";
            size *= 0.001;
        } else {
            unit = "bytes";
        }
        return Format.d(size, 4) + " " + unit;
    }
}

