/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GaussianLatitudes {
    private static final double XLIM = 1.0E-7;
    private static final LoadingCache<Integer, GaussianLatitudes> cache = CacheBuilder.newBuilder().maximumSize(50L).build((CacheLoader)new CacheLoader<Integer, GaussianLatitudes>(){

        public GaussianLatitudes load(Integer nlats) {
            return new GaussianLatitudes(nlats);
        }
    });
    private final ImmutableList<Double> weights;
    private final ImmutableList<Double> latitudes;

    public static GaussianLatitudes factory(int nlats) {
        try {
            return (GaussianLatitudes)cache.get((Object)nlats);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public ImmutableList<Double> getGaussWeights() {
        return this.weights;
    }

    public ImmutableList<Double> getLatitudes() {
        return this.latitudes;
    }

    public double getGaussWeight(int index) {
        return (Double)this.weights.get(index);
    }

    public double getLatitude(int index) {
        return (Double)this.latitudes.get(index);
    }

    private GaussianLatitudes(int nlat) {
        int i;
        if (nlat == 0) {
            throw new IllegalArgumentException("nlats may not be zero");
        }
        int nzero = nlat / 2;
        double[] cosc = new double[nlat];
        double[] colat = new double[nlat];
        double[] gaussw = new double[nlat];
        double[] sinc = new double[nlat];
        double[] wos2 = new double[nlat];
        for (int i2 = 0; i2 < nzero; ++i2) {
            cosc[i2] = Math.sin(((double)i2 + 0.5) * Math.PI / (double)nlat + 1.5707963267948966);
        }
        double FI = nlat;
        double FI1 = (double)nlat + 1.0;
        double A = FI * FI1 / Math.sqrt(4.0 * FI1 * FI1 - 1.0);
        double B = FI * FI1 / Math.sqrt(4.0 * FI * FI - 1.0);
        for (i = 0; i < nzero; ++i) {
            double delta;
            int countIterations = 0;
            do {
                double G = this.lgord(cosc[i], nlat);
                double GM = this.lgord(cosc[i], nlat - 1);
                double GP = this.lgord(cosc[i], nlat + 1);
                double denom = A * GP - B * GM;
                double GT = denom == 0.0 ? 0.0 : (cosc[i] * cosc[i] - 1.0) / denom;
                delta = G * GT;
                int n = i;
                cosc[n] = cosc[n] - delta;
                ++countIterations;
            } while (!(Math.abs(delta) <= 1.0E-7));
            double C = 2.0 * (1.0 - cosc[i] * cosc[i]);
            double D = this.lgord(cosc[i], nlat - 1);
            D = D * D * FI * FI;
            gaussw[i] = D == 0.0 ? 0.0 : C * (FI - 0.5) / D;
        }
        for (i = 0; i < nzero; ++i) {
            colat[i] = Math.acos(cosc[i]);
            sinc[i] = Math.sin(colat[i]);
            wos2[i] = gaussw[i] / (sinc[i] * sinc[i]);
        }
        int next = nzero;
        if (nlat % 2 != 0) {
            cosc[next] = 0.0;
            double C = 2.0;
            double D = this.lgord(cosc[next], nlat - 1);
            gaussw[next] = (D = D * D * FI * FI) == 0.0 ? 0.0 : C * (FI - 0.5) / D;
            colat[next] = 1.5707963267948966;
            sinc[next] = 1.0;
            wos2[next] = gaussw[next];
            ++next;
        }
        for (int i3 = next; i3 < nlat; ++i3) {
            cosc[i3] = -cosc[nlat - i3 - 1];
            gaussw[i3] = gaussw[nlat - i3 - 1];
            colat[i3] = Math.PI - colat[nlat - i3 - 1];
            sinc[i3] = sinc[nlat - i3 - 1];
            wos2[i3] = wos2[nlat - i3 - 1];
        }
        ImmutableList.Builder gausswBuilder = ImmutableList.builder();
        ImmutableList.Builder latBuilder = ImmutableList.builder();
        for (int i4 = 0; i4 < nlat; ++i4) {
            gausswBuilder.add((Object)gaussw[i4]);
            latBuilder.add((Object)Math.toDegrees(1.5707963267948966 - colat[i4]));
        }
        this.weights = gausswBuilder.build();
        this.latitudes = latBuilder.build();
    }

    private double lgord(double cosc, int nlat) {
        double colat = Math.acos(cosc);
        double c = Math.sqrt(2.0);
        for (int k = 1; k <= nlat; ++k) {
            c *= Math.sqrt(1.0 - 1.0 / (double)(4 * k * k));
        }
        double FN = nlat;
        double ANG = FN * colat;
        double S1 = 0.0;
        double C4 = 1.0;
        double A = -1.0;
        double B = 0.0;
        for (int k = 0; k <= nlat; k += 2) {
            if (k == nlat) {
                C4 = 0.5 * C4;
            }
            S1 += C4 * Math.cos(ANG);
            double FK = k;
            ANG = colat * (FN - FK - 2.0);
            C4 = (A += 2.0) * (FN - (B += 1.0) + 1.0) / (B * (FN + FN - A)) * C4;
        }
        return S1 * c;
    }
}

