/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.server;

import com.google.common.base.Stopwatch;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGrpc;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.write.ChunkingIndex;

public class GcdmServer {
    private static final Logger logger = LoggerFactory.getLogger(GcdmServer.class);
    public static final int MAX_MESSAGE = 50000000;
    private static final int SEQUENCE_CHUNK = 1000;
    private static final int PORT = 16111;
    private Server server;

    private void start() throws IOException {
        this.server = ServerBuilder.forPort((int)16111).addService((BindableService)new GcdmImpl()).build().start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            try {
                this.stop();
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
            System.err.println("*** server shut down");
        }));
        logger.info("Server started, listening on 16111");
        System.out.println("---> Server started, listening on 16111");
    }

    private void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        GcdmServer server = new GcdmServer();
        server.start();
        server.blockUntilShutdown();
    }

    static class GcdmImpl
    extends GcdmGrpc.GcdmImplBase {
        GcdmImpl() {
        }

        @Override
        public void getNetcdfHeader(GcdmNetcdfProto.HeaderRequest req, StreamObserver<GcdmNetcdfProto.HeaderResponse> responseObserver) {
            logger.info("GcdmServer getHeader " + req.getLocation());
            GcdmNetcdfProto.HeaderResponse.Builder response = GcdmNetcdfProto.HeaderResponse.newBuilder();
            try (NetcdfFile ncfile = NetcdfDatasets.openFile((String)req.getLocation(), null);){
                GcdmNetcdfProto.Header.Builder header = GcdmNetcdfProto.Header.newBuilder().setLocation(req.getLocation()).setRoot(GcdmConverter.encodeGroup(ncfile.getRootGroup(), 100).build());
                response.setHeader(header);
                responseObserver.onNext((Object)response.build());
                responseObserver.onCompleted();
            }
            catch (Throwable t) {
                logger.warn("GcdmServer getHeader failed ", t);
                t.printStackTrace();
                response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(t.getMessage()).build());
            }
        }

        @Override
        public void getNetcdfData(GcdmNetcdfProto.DataRequest req, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) {
            logger.info("GcdmServer getData {} {}", (Object)req.getLocation(), (Object)req.getVariableSpec());
            Stopwatch stopwatch = Stopwatch.createStarted();
            long size = -1L;
            try (NetcdfFile ncfile = NetcdfDatasets.openFile((String)req.getLocation(), null);){
                ParsedSectionSpec varSection = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)req.getVariableSpec());
                Variable var = varSection.getVariable();
                if (var instanceof Sequence) {
                    size = this.getSequenceData(ncfile, varSection, responseObserver);
                } else {
                    Section wantSection = varSection.getArraySection();
                    size = (long)var.getElementSize() * wantSection.computeSize();
                    this.getNetcdfData(ncfile, varSection, responseObserver);
                }
                responseObserver.onCompleted();
            }
            catch (Throwable t) {
                logger.warn("GcdmServer getData failed ", t);
                t.printStackTrace();
                GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(req.getLocation()).setVariableSpec(req.getVariableSpec());
                response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(t.getMessage() == null ? "N/A" : t.getMessage()).build());
                responseObserver.onNext((Object)response.build());
            }
            logger.debug(" ** size={} took={}", (Object)size, (Object)stopwatch.stop());
        }

        private void getNetcdfData(NetcdfFile ncfile, ParsedSectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            Variable var = varSection.getVariable();
            Section wantSection = varSection.getArraySection();
            long size = (long)var.getElementSize() * wantSection.computeSize();
            if (size > 50000000L) {
                this.getDataInChunks(ncfile, varSection, responseObserver);
            } else {
                this.getOneChunk(ncfile, varSection, responseObserver);
            }
        }

        private void getDataInChunks(NetcdfFile ncfile, ParsedSectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            Variable var = varSection.getVariable();
            Section section = varSection.getArraySection();
            long maxChunkElems = 50000000 / var.getElementSize();
            ChunkingIndex index = new ChunkingIndex(section.getShape());
            while ((long)index.currentElement() < index.getSize()) {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                Section chunkSection = new Section(chunkOrigin, chunkShape);
                ParsedSectionSpec spec = new ParsedSectionSpec(var, chunkSection);
                this.getOneChunk(ncfile, spec, responseObserver);
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize((int[])chunkShape));
            }
        }

        private void getOneChunk(NetcdfFile ncfile, ParsedSectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            String spec = varSection.makeSectionSpecString();
            Variable var = varSection.getVariable();
            Section wantSection = varSection.getArraySection();
            GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(ncfile.getLocation()).setVariableSpec(spec).setVarFullName(var.getFullName());
            Array data = var.read(wantSection);
            response.setData(GcdmConverter.encodeData(data.getDataType(), data));
            responseObserver.onNext((Object)response.build());
            logger.debug("Send one chunk {} size={} bytes", (Object)spec, (Object)(data.getSize() * (long)varSection.getVariable().getElementSize()));
        }

        private long getSequenceData(NetcdfFile ncfile, ParsedSectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException {
            String spec = varSection.makeSectionSpecString();
            Sequence seq = (Sequence)varSection.getVariable();
            StructureMembers members = seq.makeStructureMembers();
            StructureData[] structureData = new StructureData[1000];
            int start = 0;
            int count = 0;
            StructureDataIterator it = seq.getStructureIterator();
            while (it.hasNext()) {
                structureData[count++] = it.next();
                if (count < 1000 && it.hasNext()) continue;
                StructureData[] correctSizeArray = Arrays.copyOf(structureData, count);
                ArrayStructureW arrayStructure = new ArrayStructureW(members, new int[]{count}, correctSizeArray);
                GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(ncfile.getLocation()).setVariableSpec(spec).setVarFullName(seq.getFullName());
                response.setData(GcdmConverter.encodeData(DataType.SEQUENCE, (Array)arrayStructure));
                responseObserver.onNext((Object)response.build());
                start = count;
                count = 0;
            }
            return (long)(start + count) * (long)members.getStructureSize();
        }
    }
}

