/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFactoryRandom {
    private static Logger logger = LoggerFactory.getLogger(ImageFactoryRandom.class);
    private List<File> holdList;
    private List<File> fileList;
    private Random random = new Random(System.currentTimeMillis());
    File nextFile = null;

    public ImageFactoryRandom(File topDir) {
        if (!topDir.exists()) {
            return;
        }
        this.fileList = new ArrayList<File>(1000);
        this.addToList(topDir, this.fileList);
        this.holdList = new ArrayList<File>(this.fileList);
    }

    private void addToList(File dir, List<File> list) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.addToList(file, list);
                continue;
            }
            if (!file.getName().endsWith(".jpg") && !file.getName().endsWith(".JPG")) continue;
            list.add(file);
        }
    }

    public BufferedImage getNextImage() {
        if (this.holdList.isEmpty()) {
            this.holdList = new ArrayList<File>(this.fileList);
        }
        int next = this.random.nextInt(this.holdList.size());
        this.nextFile = this.holdList.get(next);
        this.holdList.remove(this.nextFile);
        try {
            return ImageIO.read(this.nextFile);
        }
        catch (IOException e) {
            logger.warn("Failed to open image {}", (Object)this.nextFile);
            this.fileList.remove(this.nextFile);
            return this.getNextImage();
        }
    }

    public boolean delete() {
        if (this.nextFile == null) {
            return false;
        }
        this.fileList.remove(this.nextFile);
        File f = new File("C:/tmp/deleted/" + this.nextFile.getName());
        return this.nextFile.renameTo(f);
    }
}

