/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import opendap.dap.DAS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.NcDAS;
import thredds.server.opendap.NcDDS;
import thredds.server.opendap.servers.ServerDDS;
import thredds.server.opendap.servlet.GuardedDataset;
import ucar.nc2.NetcdfFile;

@Immutable
public class GuardedDatasetCacheAndClone
implements GuardedDataset {
    protected static Logger log = LoggerFactory.getLogger(GuardedDataset.class);
    private final boolean hasSession;
    private final NetcdfFile org_file;
    private final NcDDS dds;
    private final NcDAS das;

    @Override
    public void release() {
        if (!this.hasSession) {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.org_file.close();
        }
        catch (IOException e) {
            log.error("GuardedDatasetImpl close", (Throwable)e);
        }
    }

    public GuardedDatasetCacheAndClone(String reqPath, NetcdfFile ncfile, boolean hasSession) {
        this.org_file = ncfile;
        this.dds = new NcDDS(reqPath, ncfile);
        this.das = new NcDAS(ncfile);
        this.hasSession = hasSession;
    }

    @Override
    public ServerDDS getDDS() {
        return (ServerDDS)((Object)this.dds.clone());
    }

    @Override
    public DAS getDAS() {
        return (DAS)this.das.clone();
    }

    public String toString() {
        String name = this.org_file.getLocation();
        return name == null ? "UNKNOWN" : name;
    }
}

