/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import opendap.dap.DAS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.NcDAS;
import thredds.server.opendap.NcDDS;
import thredds.server.opendap.servers.ServerDDS;
import thredds.server.opendap.servlet.GuardedDataset;
import ucar.nc2.NetcdfFile;

@Immutable
public class GuardedDatasetImpl
implements GuardedDataset {
    protected static Logger log = LoggerFactory.getLogger(GuardedDataset.class);
    private final boolean hasSession;
    private final NetcdfFile org_file;
    private final String reqPath;
    private boolean closed = false;

    @Override
    public void release() {
        if (!this.hasSession) {
            this.close();
        }
        this.closed = true;
    }

    @Override
    public void close() {
        try {
            this.org_file.close();
        }
        catch (IOException e) {
            log.error("GuardedDatasetImpl close", (Throwable)e);
        }
    }

    public GuardedDatasetImpl(String reqPath, NetcdfFile ncfile, boolean hasSession) {
        this.org_file = ncfile;
        this.reqPath = reqPath;
        this.hasSession = hasSession;
    }

    @Override
    public ServerDDS getDDS() {
        if (this.closed) {
            throw new IllegalStateException("getDDS(): " + this + " closed");
        }
        return new NcDDS(this.reqPath, this.org_file);
    }

    @Override
    public DAS getDAS() {
        if (this.closed) {
            throw new IllegalStateException("getDAS(): " + this + " closed");
        }
        return new NcDAS(this.org_file);
    }

    public String toString() {
        String name = this.org_file.getLocation();
        return name == null ? "UNKNOWN" : name;
    }
}

