/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.servers.SDByte;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDByte
extends SDByte
implements HasNetcdfVariable {
    private final Variable ncVar;

    NcSDByte(Variable ncVar) {
        super(ncVar.getShortName());
        this.ncVar = ncVar;
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    @Override
    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    @Override
    public void setData(Array data) {
        this.setValue(data.getByte(data.getIndex()));
        this.setRead(true);
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarByte(m));
        this.externalize(sink);
    }
}

