/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.servers.SDFloat32;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDFloat32
extends SDFloat32
implements HasNetcdfVariable {
    private final Variable ncVar;

    NcSDFloat32(Variable v) {
        super(v.getShortName());
        this.ncVar = v;
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    @Override
    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    @Override
    public void setData(Array data) {
        this.setValue(data.getFloat(data.getIndex()));
        this.setRead(true);
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarFloat(m));
        this.externalize(sink);
    }
}

