/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.servers.SDUInt16;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDUInt16
extends SDUInt16
implements HasNetcdfVariable {
    private final Variable ncVar;

    NcSDUInt16(Variable v) {
        super(v.getShortName());
        this.ncVar = v;
    }

    @Override
    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    @Override
    public void setData(Array data) {
        this.setValue(data.getShort(data.getIndex()));
        this.setRead(true);
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarShort(m));
        this.externalize(sink);
    }
}

