/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DPrimitive;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.NoSuchTypeException;
import opendap.dap.parsers.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.server.opendap.GetHTMLInterfaceHandler2;
import thredds.server.opendap.GuardedDatasetCacheAndClone;
import thredds.server.opendap.RequestTooLargeException;
import thredds.server.opendap.servers.CEEvaluator;
import thredds.server.opendap.servers.SDArray;
import thredds.server.opendap.servers.ServerDDS;
import thredds.server.opendap.servlet.AbstractServlet;
import thredds.server.opendap.servlet.AsciiWriter;
import thredds.server.opendap.servlet.BadURLException;
import thredds.server.opendap.servlet.GetInfoHandler;
import thredds.server.opendap.servlet.GuardedDataset;
import thredds.server.opendap.servlet.ReqState;
import thredds.util.ServletUtil;
import thredds.util.TdsPathUtils;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.internal.util.EscapeStrings;

@Controller
@RequestMapping(value={"/dods"})
public class OpendapServlet
extends AbstractServlet
implements InitializingBean {
    public static Logger log = LoggerFactory.getLogger(OpendapServlet.class);
    static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    int opendapAscLimit = 50;
    int opendapBinLimit = 500;
    String opendapVersionString = "opendap/3.7";
    private String serverContactName = "UNKNOWN";
    private String serverContactEmail = "UNKNOWN";
    private boolean allowSessions = false;
    private boolean allowDeflate = false;
    private URI baseURI = null;
    private boolean debugSession = false;
    private static final boolean debugSize = false;

    public void afterPropertiesSet() {
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start");
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " version= " + this.opendapVersionString + " ascLimit = " + this.opendapAscLimit + " binLimit = " + this.opendapBinLimit);
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done");
    }

    @Override
    public String getServerVersion() {
        return this.opendapVersionString;
    }

    protected long getLastModified(HttpServletRequest req) {
        String query = req.getQueryString();
        if (query != null) {
            return -1L;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return -1L;
        }
        if (path.endsWith(".asc")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ascii")) {
            path = path.substring(0, path.length() - 6);
        } else if (path.endsWith(".das")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dds")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ddx")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dods")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".info")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".opendap")) {
            path = path.substring(0, path.length() - 5);
        } else {
            return -1L;
        }
        return TdsPathUtils.getLastModified(path);
    }

    @Override
    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        block25: {
            log.debug("doGet(): User-Agent = " + request.getHeader("User-Agent"));
            ReqState rs = this.getRequestState(request, response);
            try {
                if (this.baseURI == null) {
                    URI reqURI = ServletUtil.getRequestURI(request);
                    assert (reqURI != null);
                    String baseUriString = request.getContextPath() + request.getServletPath() + "/";
                    this.baseURI = reqURI.resolve(baseUriString);
                    log.debug("doGet(): baseURI was set = {}", (Object)this.baseURI);
                }
                String dataSet = rs.getDataSet();
                String requestSuffix = rs.getRequestSuffix();
                if (dataSet == null || dataSet.equals("/") || dataSet.equals("")) {
                    this.doGetDIR(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("blob")) {
                    this.doGetBLOB(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("close")) {
                    this.doClose(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("dds")) {
                    this.doGetDDS(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("das")) {
                    this.doGetDAS(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("ddx")) {
                    this.doGetDDX(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("dods")) {
                    this.doGetDAP2Data(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                    this.doGetASC(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("info")) {
                    this.doGetINFO(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                    this.doGetHTML(rs);
                    break block25;
                }
                if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version") || dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                    this.doGetVER(rs);
                    break block25;
                }
                if (dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/") || dataSet.equalsIgnoreCase("/" + requestSuffix) || requestSuffix.equalsIgnoreCase("help")) {
                    this.doGetHELP(rs);
                    break block25;
                }
                this.sendErrorResponse(response, 400, "Unrecognized request");
                return;
            }
            catch (FileNotFoundException e) {
                this.sendErrorResponse(response, 404, e.getMessage());
            }
            catch (BadURLException e) {
                response.setStatus(400);
                this.dap2ExceptionHandler((DAP2Exception)e, rs);
            }
            catch (DAP2Exception de) {
                int status;
                int n = status = de.getErrorCode() == 1 ? 404 : 400;
                if (de.getErrorCode() == 0 || de.getErrorCode() == -1 && de.getErrorMessage() != null) {
                    log.info(de.getErrorMessage());
                }
                response.setStatus(status);
                this.dap2ExceptionHandler(de, rs);
            }
            catch (ParseException pe) {
                response.setStatus(400);
                this.parseExceptionHandler(pe, response);
            }
            catch (RequestTooLargeException e) {
                throw e;
            }
            catch (SocketException e) {
                log.info("SocketException: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                String eName = e.getClass().getName();
                if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                    log.debug("ClientAbortException: " + e.getMessage());
                    return;
                }
                log.error("request= " + rs, (Throwable)e);
                this.sendErrorResponse(response, 500, e.getMessage());
            }
            catch (Throwable t) {
                log.error("request= " + rs, t);
                this.sendErrorResponse(response, 500, t.getMessage());
            }
        }
    }

    @Override
    public void doGetASC(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/plain");
            response.setHeader("Content-Description", "dods-ascii");
            log.debug("Sending OPeNDAP ASCII Data For: " + rs + "  CE: '" + rs.getConstraintExpression() + "'");
            ServerDDS dds = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(dds);
            AbstractServlet.parseConstraint(ce, rs);
            this.checkSize(dds, true);
            PrintWriter pw = response.getWriter();
            dds.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, dds, ds);
            pw.flush();
        }
    }

    @Override
    public void doGetDAS(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-das");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            DAS myDAS = ds.getDAS();
            myDAS.print((OutputStream)Out);
        }
    }

    @Override
    public void doGetDDS(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-dds");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print(out);
                ((OutputStream)out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                AbstractServlet.parseConstraint(ce, rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
                myDDS.printConstrained(pw);
                pw.flush();
            }
        }
    }

    @Override
    public void doGetDDX(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-ddx");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            myDDS.ingestDAS(ds.getDAS());
            if (rs.getConstraintExpression().equals("")) {
                myDDS.printXML(out);
                ((OutputStream)out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                AbstractServlet.parseConstraint(ce, rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
                myDDS.printConstrainedXML(pw);
                pw.flush();
            }
        }
    }

    @Override
    public void doGetBLOB(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            BufferedOutputStream bOut;
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-blob");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            AbstractServlet.parseConstraint(ce, rs);
            this.checkSize(myDDS, false);
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
        }
    }

    private void doClose(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        String reqPath = rs.getDataSet();
        HttpSession session = request.getSession();
        session.removeAttribute(reqPath);
        response.setHeader("XDODS-Server", this.getServerVersion());
    }

    @Override
    public void doGetDAP2Data(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            BufferedOutputStream bOut;
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-data");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            AbstractServlet.parseConstraint(ce, rs);
            this.checkSize(myDDS, false);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)bOut, StandardCharsets.UTF_8));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes(StandardCharsets.UTF_8));
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
        }
    }

    @Override
    public void doGetVER(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-version");
        PrintWriter pw = response.getWriter();
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
    }

    @Override
    public void doGetHELP(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-help");
        PrintWriter pw = response.getWriter();
        this.printHelpPage(pw);
        pw.flush();
    }

    @Override
    public void doGetDIR(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        if (rs.getRequestSuffix() == null || rs.getRequestSuffix().length() == 0) {
            ServletUtil.forwardToCatalogServices(request, response);
            return;
        }
        this.sendErrorResponse(response, 0, "Unrecognized request");
    }

    @Override
    public void doGetINFO(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        try (GuardedDataset ds = this.getDataset(rs);){
            PrintWriter pw = response.getWriter();
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-description");
            GetInfoHandler di = new GetInfoHandler();
            di.sendINFO(pw, ds, rs);
        }
    }

    @Override
    public void doGetHTML(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        try (GuardedDataset ds = this.getDataset(rs);){
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-form");
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            GetHTMLInterfaceHandler2 di = new GetHTMLInterfaceHandler2();
            di.sendDataRequestForm(request, response, rs.getDataSet(), myDDS, das);
        }
    }

    @Override
    public String getServerName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>OPeNDAP Server Help</h3>");
        pw.println("To access most of the features of this OPeNDAP server, append");
        pw.println("one of the following a eight suffixes to a URL: .das, .dds, .dods, .ddx, .blob, .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:");
        pw.println("<dl>");
        pw.println("<dt> das  </dt> <dd> Dataset Attribute Structure (DAS)</dd>");
        pw.println("<dt> dds  </dt> <dd> Dataset Descriptor Structure (DDS)</dd>");
        pw.println("<dt> dods </dt> <dd> DataDDS object (A constrained DDS populated with data)</dd>");
        pw.println("<dt> ddx  </dt> <dd> XML version of the DDS/DAS</dd>");
        pw.println("<dt> blob </dt> <dd> Serialized binary data content for requested data set, with the constraint expression applied.</dd>");
        pw.println("<dt> info </dt> <dd> info object (attributes, types and other information)</dd>");
        pw.println("<dt> html </dt> <dd> html form for this dataset</dd>");
        pw.println("<dt> ver  </dt> <dd> return the version number of the server</dd>");
        pw.println("<dt> help </dt> <dd> help information (this text)</dd>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://opendap.gso.url.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many OPeNDAP clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a OPeNDAP client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://opendap.gso.url.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    @Override
    protected void printBadURLPage(PrintWriter pw) {
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all OPeNDAP servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("administrator of this server [" + this.serverContactName + "] at: ");
        pw.println("<a href='mailto:" + this.serverContactEmail + "'>" + this.serverContactEmail + "</a><p>");
    }

    @Override
    protected ReqState getRequestState(HttpServletRequest request, HttpServletResponse response) {
        ReqState rs;
        String baseurl = request.getRequestURL().toString();
        baseurl = EscapeStrings.urlDecode((String)baseurl);
        String query = request.getQueryString();
        query = EscapeStrings.unescapeURLQuery((String)query);
        if (log.isDebugEnabled()) {
            log.debug(String.format("OpendapServlet: nominal url: %s?%s", baseurl, query));
        }
        String dataPath = TdsPathUtils.extractPath(request, "/dodsC");
        try {
            rs = new ReqState(request, response, dataPath, baseurl, query);
        }
        catch (Exception bue) {
            rs = null;
        }
        return rs;
    }

    private void checkSize(ServerDDS dds, boolean isAscii) throws Exception {
        double maxSize;
        long size = this.computeSize((DConstructor)dds, isAscii);
        log.debug("total (constrained) size={}", (Object)size);
        double dsize = (double)size / 1000000.0;
        double d = maxSize = isAscii ? (double)this.opendapAscLimit : (double)this.opendapBinLimit;
        if (dsize > maxSize) {
            log.info("Reject request size = {} Mbytes", (Object)dsize);
            throw new RequestTooLargeException(dsize + " Mbytes, max=" + maxSize);
        }
    }

    private long computeSize(DConstructor ctor, boolean isAscii) throws Exception {
        long result;
        long projectsize = 0L;
        long othersize = 0L;
        long fieldsize = 0L;
        int projectedcount = 0;
        int fieldcount = 0;
        for (BaseType field : ctor.getVariables()) {
            ++fieldcount;
            fieldsize = this.computeFieldSize(field, isAscii);
            if (field.isProject()) {
                projectsize += fieldsize;
                ++projectedcount;
                continue;
            }
            othersize += fieldsize;
        }
        if (projectedcount == fieldcount) {
            result = projectsize;
        } else if (projectedcount == 0) {
            result = othersize;
        } else {
            assert (projectedcount > 0 && projectedcount < fieldcount);
            result = projectsize;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long computeFieldSize(BaseType bt, boolean isAscii) throws Exception {
        long fieldsize = 0L;
        if (bt instanceof DConstructor) {
            return this.computeSize((DConstructor)bt, isAscii);
        }
        if (bt instanceof DArray) {
            SDArray da = (SDArray)bt;
            if (da.getContainerVar() instanceof DPrimitive) {
                return this.computeArraySize(da);
            }
            if (!(da.getContainerVar() instanceof DStructure)) throw new NoSuchTypeException("Computesize: unexpected type for " + bt.getLongName());
            return this.computeSize((DConstructor)((DStructure)da.getContainerVar()), isAscii);
        }
        if (!(bt instanceof DPrimitive)) throw new NoSuchTypeException("Computesize: unknown type for " + bt.getLongName());
        DPrimitive dp = (DPrimitive)bt;
        if (dp instanceof DString) {
            String v = ((DString)dp).getValue();
            if (v == null) {
                return 0L;
            }
            int n = v.length();
            return n;
        }
        DataType dtype = DodsNetcdfFiles.convertToNCType((BaseType)bt, (boolean)false);
        return dtype.getSize();
    }

    long computeArraySize(SDArray da) throws Exception {
        assert (da.getContainerVar() instanceof DPrimitive);
        BaseType base = da.getPrimitiveVector().getTemplate();
        DataType dtype = DodsNetcdfFiles.convertToNCType((BaseType)base, (boolean)false);
        int elemSize = dtype.getSize();
        int n = da.numDimensions();
        ArrayList<Range> ranges = new ArrayList<Range>(n);
        long size = 0L;
        for (int i = 0; i < n; ++i) {
            ranges.add(new Range(da.getStart(i), da.getStop(i), da.getStride(i)));
        }
        Section s = new Section(ranges);
        return size += s.computeSize() * (long)elemSize;
    }

    @Override
    protected GuardedDataset getDataset(ReqState preq) throws Exception {
        GuardedDataset gdataset;
        HttpServletRequest req = preq.getRequest();
        String reqPath = preq.getDataSet();
        boolean acceptSession = false;
        String s = req.getHeader("X-Accept-Session");
        if (s != null && s.equalsIgnoreCase("true") && this.allowSessions) {
            acceptSession = true;
        }
        HttpSession session = null;
        if (acceptSession && !(session = req.getSession()).isNew() && null != (gdataset = (GuardedDataset)session.getAttribute(reqPath))) {
            if (this.debugSession) {
                System.out.printf(" found gdataset %s in session %s %n", reqPath, session.getId());
            }
            if (log.isDebugEnabled()) {
                log.debug(" found gdataset " + gdataset + " in session " + session.getId());
            }
            return gdataset;
        }
        NetcdfFile ncd = TdsPathUtils.getNetcdfFile(req, reqPath);
        if (null == ncd) {
            return null;
        }
        GuardedDatasetCacheAndClone gdataset2 = new GuardedDatasetCacheAndClone(reqPath, ncd, acceptSession);
        if (acceptSession) {
            String suffix;
            String cookiePath = req.getRequestURI();
            if (cookiePath.endsWith(suffix = "." + preq.getRequestSuffix())) {
                cookiePath = cookiePath.substring(0, cookiePath.length() - suffix.length());
            }
            session.setAttribute(reqPath, (Object)gdataset2);
            if (this.debugSession) {
                System.out.printf(" added gdataset %s in session %s cookiePath %s %n", reqPath, session.getId(), cookiePath);
            }
            if (log.isDebugEnabled()) {
                log.debug(" added gdataset " + gdataset2 + " in session " + session.getId());
            }
        }
        return gdataset2;
    }

    @Override
    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setContentType("text/plain");
            String msg = pe.getMessage().replace('\"', '\'');
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print((OutputStream)eOut);
        }
        catch (Exception e) {
            System.err.println("parseExceptionHandler: " + e);
        }
    }

    public void dap2ExceptionHandler(DAP2Exception de, ReqState rs) {
        rs.getResponse().setHeader("Content-Description", "dods-error");
        rs.getResponse().setContentType("text/plain");
        try {
            de.print((OutputStream)rs.getResponse().getOutputStream());
        }
        catch (Exception e) {
            System.err.println("dap2ExceptionHandler: " + e);
        }
    }

    private void sendErrorResponse(HttpServletResponse response, int errorCode, String errorMessage) {
        try {
            response.setStatus(errorCode);
            response.setHeader("Content-Description", "dods-error");
            response.setContentType("text/plain");
            PrintWriter pw = response.getWriter();
            pw.println("Error {");
            pw.println("    code = " + errorCode + ";");
            pw.println("    message = \"" + errorMessage + "\";");
            pw.println("};");
            pw.flush();
        }
        catch (Exception e) {
            System.err.println("sendErrorResponse: " + e);
        }
    }
}

