/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import thredds.server.opendap.servers.AbstractClause;
import thredds.server.opendap.servers.BoolFunction;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.SubClause;
import thredds.server.opendap.servers.TopLevelClause;
import thredds.server.opendap.servers.ValueClause;

public class BoolFunctionClause
extends AbstractClause
implements TopLevelClause {
    protected BoolFunction function;
    protected boolean value;

    protected BoolFunctionClause(BoolFunction function, List children) throws DAP2ServerSideException {
        function.checkArgs(children);
        this.function = function;
        this.children = children;
        this.constant = true;
        for (SubClause current : children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        if (this.constant) {
            this.evaluate();
        }
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean evaluate() throws DAP2ServerSideException {
        if (!this.constant || !this.defined) {
            this.defined = true;
            this.value = this.function.evaluate(this.children);
        }
        return this.value;
    }

    public BoolFunction getFunction() {
        return this.function;
    }

    @Override
    public void printConstraint(PrintWriter os) {
        os.print(this.function.getName() + "(");
        Iterator it = this.children.iterator();
        boolean first = true;
        while (it.hasNext()) {
            ValueClause vc = (ValueClause)it.next();
            if (!first) {
                os.print(",");
            }
            vc.printConstraint(os);
            first = false;
        }
        os.print(")");
    }
}

