/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.NoSuchFunctionException;
import thredds.server.opendap.servers.BTFunction;
import thredds.server.opendap.servers.BTFunctionClause;
import thredds.server.opendap.servers.BoolFunction;
import thredds.server.opendap.servers.BoolFunctionClause;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.DereferenceClause;
import thredds.server.opendap.servers.FunctionLibrary;
import thredds.server.opendap.servers.RelOpClause;
import thredds.server.opendap.servers.SubClause;
import thredds.server.opendap.servers.TopLevelClause;
import thredds.server.opendap.servers.ValueClause;

public class ClauseFactory {
    protected FunctionLibrary functionLibrary;

    public ClauseFactory() {
        this.functionLibrary = new FunctionLibrary();
    }

    public ClauseFactory(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public TopLevelClause newRelOpClause(int operator, SubClause lhs, List rhs) throws DAP2ServerSideException {
        return new RelOpClause(operator, lhs, rhs);
    }

    public TopLevelClause newBoolFunctionClause(String functionName, List children) throws DAP2ServerSideException, NoSuchFunctionException {
        BoolFunction function = this.functionLibrary.getBoolFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBTFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() does not return a boolean value, and must be used in a comparison or as an argument to another function.");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BoolFunctionClause(function, children);
    }

    public SubClause newValueClause(BaseType value, boolean constant) throws DAP2ServerSideException {
        return new ValueClause(value, constant);
    }

    public SubClause newBTFunctionClause(String functionName, List children) throws DAP2ServerSideException, NoSuchFunctionException {
        BTFunction function = this.functionLibrary.getBTFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBoolFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() cannot be used as a sub-expression in a constraint clause");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BTFunctionClause(function, children);
    }

    public SubClause newDereferenceClause(String url) throws DAP2ServerSideException {
        return new DereferenceClause(url);
    }
}

