/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.Attribute;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DGrid;
import opendap.dap.InvalidDimensionException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.parsers.DDSXMLParser;
import thredds.server.opendap.servers.CEEvaluator;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.InvalidOperatorException;
import thredds.server.opendap.servers.RegExpException;
import thredds.server.opendap.servers.RelOps;
import thredds.server.opendap.servers.SBHException;
import thredds.server.opendap.servers.SDArray;
import thredds.server.opendap.servers.ServerArrayMethods;
import thredds.server.opendap.servers.ServerMethods;

public abstract class SDGrid
extends DGrid
implements ServerArrayMethods,
RelOps {
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDGrid() {
    }

    public SDGrid(String n) {
        super(n);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        boolean isSingle = false;
        boolean isStructure = false;
        boolean isGrid = false;
        boolean psemi = true;
        if (constrained && this.projectedComponents(true) == 0) {
            return;
        }
        if (constrained && !this.projectionYieldsGrid(true)) {
            isStructure = true;
        } else {
            isGrid = true;
        }
        if (isGrid) {
            os.println(space + this.getTypeName() + " {");
        }
        if (isGrid) {
            os.println(space + " ARRAY:");
        }
        if (isStructure) {
            os.println(space + "Structure {");
        }
        ((SDArray)this.arrayVar).printDecl(os, space + "    ", psemi, constrained);
        if (isGrid) {
            os.println(space + " MAPS:");
        }
        for (BaseType bt : this.mapVars) {
            SDArray sda = (SDArray)bt;
            sda.printDecl(os, space + "    ", psemi, constrained);
        }
        if (isStructure || isGrid) {
            os.print(space + "} " + this.getEncodedName());
            if (print_semi) {
                os.println(";");
            }
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        boolean isStillGrid = this.projectionYieldsGrid(true);
        os.print("{ ");
        if (isStillGrid) {
            os.print("ARRAY: ");
        }
        if (((SDArray)this.arrayVar).isProject()) {
            this.arrayVar.printVal(os, "", false);
        }
        if (isStillGrid) {
            os.print(" MAPS: ");
        }
        boolean firstPass = true;
        for (BaseType bt : this.mapVars) {
            SDArray sda = (SDArray)bt;
            if (!sda.isProject()) continue;
            if (!firstPass) {
                os.print(", ");
            }
            sda.printVal(os, "", false);
            firstPass = false;
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public void addVariable(BaseType v, int part) {
        super.addVariable(v, part);
    }

    @Override
    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
        if (all) {
            this.arrayVar.setProject(state);
            for (BaseType bt : this.mapVars) {
                ServerMethods sm = (ServerMethods)bt;
                sm.setProject(state);
            }
        }
    }

    @Override
    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDGrid!");
    }

    @Override
    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDGrid!");
    }

    @Override
    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDGrid!");
    }

    @Override
    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDGrid!");
    }

    @Override
    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDGrid!");
    }

    @Override
    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDGrid!");
    }

    @Override
    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDGrid!");
    }

    @Override
    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    @Override
    public boolean isSynthesized() {
        return this.Synthesized;
    }

    @Override
    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    @Override
    public boolean isRead() {
        return this.ReadMe;
    }

    @Override
    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    @Override
    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        if (!this.isRead()) {
            this.read(dataset, specialO);
        }
        if (ce.evalClauses(specialO)) {
            if (((ServerMethods)this.arrayVar).isProject()) {
                ((ServerMethods)this.arrayVar).serialize(dataset, sink, ce, specialO);
            }
            for (BaseType bt : this.mapVars) {
                ServerMethods sm = (ServerMethods)bt;
                if (!sm.isProject()) continue;
                sm.serialize(dataset, sink, ce, specialO);
            }
        }
    }

    @Override
    public void setProjection(int dimension, int start, int stride, int stop) throws InvalidDimensionException, SBHException {
        try {
            DArray a = (DArray)this.getVar(0);
            DArrayDimension d = a.getDimension(dimension);
            d.setProjection(start, stride, stop);
            DArray map = (DArray)this.getVar(dimension + 1);
            DArrayDimension mapD = map.getDimension(0);
            mapD.setProjection(start, stride, stop);
        }
        catch (NoSuchVariableException e) {
            throw new InvalidDimensionException("SDGrid.setProjection(): Bad Value for dimension!: " + e.getMessage());
        }
    }

    @Override
    public int getStart(int dimension) throws InvalidDimensionException {
        try {
            DArray a = (DArray)this.getVar(0);
            DArrayDimension d = a.getDimension(dimension);
            return d.getStart();
        }
        catch (NoSuchVariableException e) {
            throw new InvalidDimensionException("SDGrid.getStart(): Bad Value for dimension!: " + e.getMessage());
        }
    }

    @Override
    public int getStride(int dimension) throws InvalidDimensionException {
        try {
            DArray a = (DArray)this.getVar(0);
            DArrayDimension d = a.getDimension(dimension);
            return d.getStride();
        }
        catch (NoSuchVariableException e) {
            throw new InvalidDimensionException("SDGrid.getStride(): Bad Value for dimension!: " + e.getMessage());
        }
    }

    @Override
    public int getStop(int dimension) throws InvalidDimensionException {
        try {
            DArray a = (DArray)this.getVar(0);
            DArrayDimension d = a.getDimension(dimension);
            return d.getStop();
        }
        catch (NoSuchVariableException e) {
            throw new InvalidDimensionException("SDGrid.getStop(): Bad Value for dimension!: " + e.getMessage());
        }
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        boolean isSingle = false;
        boolean isStructure = false;
        boolean isGrid = false;
        boolean psemi = true;
        if (constrained && this.projectedComponents(true) == 0) {
            return;
        }
        if (constrained && this.projectedComponents(true) == 1) {
            isSingle = true;
        } else if (constrained && !this.projectionYieldsGrid(true)) {
            isStructure = true;
        } else {
            isGrid = true;
        }
        if (isGrid) {
            pw.print(pad + "<Grid ");
            if (this.getEncodedName() != null) {
                pw.print(" name=\"" + DDSXMLParser.normalizeToXML((String)this.getEncodedName()) + "\"");
            }
            pw.println(">");
        }
        if (isStructure) {
            pw.print(pad + "<Structure");
            if (this.getEncodedName() != null) {
                pw.print(" name=\"" + DDSXMLParser.normalizeToXML((String)this.getEncodedName()) + "\"");
            }
            pw.println(">");
        }
        for (String attName : this.getAttributeNames()) {
            Attribute a = this.getAttribute(attName);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        this.arrayVar.printXML(pw, pad + (isSingle ? "" : "\t"), constrained);
        if (isGrid) {
            for (BaseType bt : this.mapVars) {
                SDArray map = (SDArray)bt;
                map.printAsMapXML(pw, pad + (isSingle ? "" : "\t"), constrained);
            }
        } else {
            for (BaseType bt : this.mapVars) {
                SDArray sda = (SDArray)bt;
                sda.printXML(pw, pad + (isSingle ? "" : "\t"), constrained);
            }
        }
        if (isStructure) {
            pw.println(pad + "</Structure>");
        } else if (isGrid) {
            pw.println(pad + "</Grid>");
        }
    }
}

