/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers.parsers;

import java.util.List;
import java.util.Stack;
import opendap.dap.DAP2Exception;
import opendap.dap.DAPNode;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import thredds.server.opendap.servers.CEEvaluator;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.ServerMethods;
import thredds.server.opendap.servers.SubClause;
import thredds.server.opendap.servers.parsers.AST;
import thredds.server.opendap.servers.parsers.ASTfcn;
import thredds.server.opendap.servers.parsers.ASTvar;

class ASTprojection
extends AST {
    ASTvar var = null;
    ASTfcn fcn = null;

    public ASTprojection(List<AST> nodes) {
        super(nodes);
    }

    void walk(CEEvaluator ceEval) throws DAP2ServerSideException, DAP2Exception, NoSuchFunctionException, NoSuchVariableException {
        if (this.fcn != null) {
            SubClause subclause = this.fcn.translate();
            this.getCeEval().appendClause(subclause);
        } else {
            Stack components = new Stack();
            components = this.var.collect(components);
            this.markStackedVariables(components);
        }
    }

    private void markStackedVariables(Stack s) {
        DAPNode dn;
        Stack bts = new Stack();
        while (!s.empty()) {
            bts.push(s.pop());
        }
        while (bts.size() > 1) {
            dn = (DAPNode)bts.pop();
            ServerMethods ct = (ServerMethods)dn;
            ct.setProject(true, false);
        }
        dn = (DAPNode)bts.pop();
        ServerMethods bt = (ServerMethods)dn;
        bt.setProject(true, true);
    }
}

