/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servlet.ascii;

import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DString;
import opendap.dap.PrimitiveVector;
import thredds.server.opendap.servlet.ascii.toASCII;

public class asciiArray
extends DArray
implements toASCII {
    private static boolean _Debug = false;

    public asciiArray() {
        this(null);
    }

    public asciiArray(String n) {
        super(n);
    }

    @Override
    public void toASCII(PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (_Debug) {
            System.out.println("asciiArray.toASCII(" + addName + ",'" + rootName + "')  getName(): " + this.getEncodedName());
            System.out.println("  PrimitiveVector size = " + this.getPrimitiveVector().getLength());
        }
        if (addName) {
            pw.print("\n");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        for (DArrayDimension dad : this.getDimensions()) {
            shape[i++] = dad.getSize();
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    @Override
    public String toASCIIFlatName(String rootName) {
        StringBuilder s = new StringBuilder();
        if (rootName != null) {
            s.append(rootName);
            s.append(".");
            s.append(this.getEncodedName());
        } else {
            s.append(this.getEncodedName());
        }
        String s2 = "";
        PrimitiveVector pv = this.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(0);
            if (bt instanceof DString) {
                for (DArrayDimension d : this.getDimensions()) {
                    s.append("[");
                    s.append(d.getSize());
                    s.append("]");
                }
                s2 = s.toString();
            } else {
                s2 = ((toASCII)bt).toASCIIFlatName(s.toString());
            }
        } else {
            for (DArrayDimension dad : this.getDimensions()) {
                s.append("[");
                s.append(dad.getSize());
                s.append("]");
            }
            s2 = s.toString();
        }
        return s2;
    }

    @Override
    public String toASCIIAddRootName(PrintWriter pw, boolean addName, String rootName) {
        if (addName) {
            rootName = this.toASCIIFlatName(rootName);
            pw.print(rootName);
        }
        return rootName;
    }

    private int asciiArray(PrintWriter os, boolean addName, String label, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            if (addName) {
                os.print(label);
            }
            for (int i = 0; i < shape[offset]; ++i) {
                PrimitiveVector pv = this.getPrimitiveVector();
                if (pv instanceof BaseTypePrimitiveVector) {
                    BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(index++);
                    if (i > 0) {
                        if (bt instanceof DString) {
                            os.print(", ");
                        } else {
                            os.println("");
                        }
                    }
                    ((toASCII)bt).toASCII(os, false, null, false);
                    continue;
                }
                if (i > 0) {
                    os.print(", ");
                }
                pv.printSingleVal(os, index++);
            }
            if (addName) {
                os.print("\n");
            }
            return index;
        }
        for (int i = 0; i < shape[offset]; ++i) {
            StringBuilder s = new StringBuilder();
            s.append(label);
            s.append("[");
            s.append(i);
            s.append("]");
            if (dims - 1 == 1) {
                s.append(", ");
            }
            index = this.asciiArray(os, addName, s.toString(), index, dims - 1, shape, offset + 1);
        }
        return index;
    }
}

