/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servlet.ascii;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.DSequence;
import thredds.server.opendap.servlet.ascii.toASCII;

public class asciiSeq
extends DSequence
implements toASCII {
    public asciiSeq() {
        this(null);
    }

    public asciiSeq(String n) {
        super(n);
    }

    @Override
    public void toASCII(PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        rootName = rootName != null ? rootName + "." + this.getEncodedName() : this.getEncodedName();
        pw.print(this.toASCIIFlatName(rootName));
        pw.println("");
        for (List row : this.allValues) {
            int j = 0;
            for (BaseType bt : row) {
                toASCII ta = (toASCII)bt;
                if (j > 0) {
                    pw.print(", ");
                }
                ta.toASCII(pw, false, rootName, false);
                ++j;
            }
            pw.println("");
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    @Override
    public String toASCIIAddRootName(PrintWriter pw, boolean addName, String rootName) {
        if (addName) {
            rootName = this.toASCIIFlatName(rootName);
            pw.print(rootName);
        }
        return rootName;
    }

    @Override
    public String toASCIIFlatName(String rootName) {
        StringBuilder s = new StringBuilder();
        boolean firstPass = true;
        Iterator iterator = this.allValues.iterator();
        if (iterator.hasNext()) {
            List row = (List)iterator.next();
            for (BaseType bt : row) {
                toASCII ta = (toASCII)bt;
                if (!firstPass) {
                    s.append(", ");
                }
                s.append(ta.toASCIIFlatName(rootName));
                firstPass = false;
            }
        }
        return s.toString();
    }
}

