/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import thredds.util.DataRootManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDatasets;

public class TdsPathUtils {
    public static String extractPath(HttpServletRequest req, String removePrefix) {
        String dataPath = req.getPathInfo();
        if (dataPath == null) {
            dataPath = req.getServletPath();
        }
        if (dataPath == null) {
            return "";
        }
        if (removePrefix != null) {
            if (dataPath.startsWith(removePrefix)) {
                dataPath = dataPath.substring(removePrefix.length());
            } else if (dataPath.startsWith("/") && (dataPath = dataPath.substring(1)).startsWith(removePrefix)) {
                dataPath = dataPath.substring(removePrefix.length());
            }
        }
        if (dataPath.startsWith("/")) {
            dataPath = dataPath.substring(1);
        }
        if (dataPath.contains("..")) {
            throw new IllegalArgumentException("path cannot contain '..'");
        }
        return dataPath;
    }

    public static long getLastModified(String reqPath) {
        File file = TdsPathUtils.getFile(reqPath);
        return file == null ? -1L : file.lastModified();
    }

    public static File getFile(String reqPath) {
        String location = DataRootManager.getLocationFromRequestPath(reqPath);
        return location == null ? null : new File(location);
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest request, String reqPath) throws IOException {
        String extracted = TdsPathUtils.extractPath(request, null);
        return NetcdfDatasets.openDataset((String)extracted);
    }
}

