/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.mcidas.AreaFile;

public final class McIDASUtil {
    public static final int MCMISSING = -2139062144;

    public static double integerLatLonToDouble(int value) {
        return McIDASUtil.mcPackedIntegerToDouble(value);
    }

    public static int doubleLatLonToInteger(double dvalue) {
        return McIDASUtil.mcDoubleToPackedInteger(dvalue);
    }

    public static double mcPackedIntegerToDouble(int value) {
        int val = value < 0 ? -value : value;
        double dvalue = (double)(val / 10000) + (double)(val / 100 % 100) / 60.0 + (double)(val % 100) / 3600.0;
        return value < 0 ? -dvalue : dvalue;
    }

    public static int mcDoubleToPackedInteger(double dvalue) {
        double dval = dvalue < 0.0 ? -dvalue : dvalue;
        int j = (int)(3600.0 * dval + 0.5);
        int value = 10000 * (j / 3600) + 100 * (j / 60 % 60) + j % 60;
        return dvalue < 0.0 ? -value : value;
    }

    public static double timdif(int yrday1, int hms1, int yrday2, int hms2) {
        long secs1 = McIDASUtil.mcDayTimeToSecs(yrday1, hms1);
        long secs2 = McIDASUtil.mcDayTimeToSecs(yrday2, hms2);
        return (double)(secs2 - secs1) / 60.0;
    }

    public static GregorianCalendar makeCalendarForDayTimeToSecs() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(0, 1);
        cal.setLenient(true);
        return cal;
    }

    public static long mcDayTimeToSecs(int yearday, int time) {
        return McIDASUtil.mcDayTimeToSecs(yearday, time, null);
    }

    public static long mcDayTimeToSecs(int yearday, int time, GregorianCalendar cal) {
        if (cal == null) {
            cal = McIDASUtil.makeCalendarForDayTimeToSecs();
        }
        int year = yearday / 1000 % 1900 + 1900;
        int day = yearday % 1000;
        double seconds = McIDASUtil.mcPackedIntegerToDouble(time) * 3600.0;
        cal.clear();
        cal.set(6, day);
        cal.set(1, year);
        int secs = (int)Math.round(seconds * 1000.0) / 1000;
        cal.set(13, secs);
        cal.set(14, 0);
        return cal.getTimeInMillis() / 1000L;
    }

    public static long mcDateHmsToSecs(int date, int time) {
        int year = date / 10000;
        if (year < 50) {
            year += 2000;
        } else if (year < 1000) {
            year += 1900;
        }
        int month = date % 10000 / 100;
        int day = date % 100;
        double seconds = McIDASUtil.mcPackedIntegerToDouble(time) * 3600.0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(0, 1);
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        int secs = (int)Math.round(seconds * 1000.0) / 1000;
        cal.set(13, secs);
        cal.set(14, 0);
        return cal.getTime().getTime() / 1000L;
    }

    public static int[] mcSecsToDayTime(long secs) {
        int[] retvals = new int[2];
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTime(new Date(secs * 1000L));
        retvals[0] = cal.get(1) * 1000 + cal.get(6);
        retvals[1] = cal.get(11) * 10000 + cal.get(12) * 100 + cal.get(13);
        return retvals;
    }

    public static String mcHmsToStr(int hms) {
        StringBuffer buf = new StringBuffer();
        int hours = hms / 10000;
        int mins = hms % 10000 / 100;
        int secs = hms % 100;
        buf.append(McIDASUtil.padZero(hours, 2));
        buf.append(":");
        buf.append(McIDASUtil.padZero(mins, 2));
        buf.append(":");
        buf.append(McIDASUtil.padZero(secs, 2));
        return buf.toString();
    }

    public static String padZero(int value, int numDigits) {
        return McIDASUtil.padLeft(String.valueOf(value), numDigits, "0");
    }

    public static String padLeft(String s, int desiredLength, String padString) {
        while (s.length() < desiredLength) {
            s = padString + s;
        }
        return s;
    }

    public static int swbyt4(int val) {
        int[] vals = new int[]{val};
        McIDASUtil.flip(vals, 0, 0);
        return vals[0];
    }

    public static void swbyt4(int[] array, int first, int num) {
        McIDASUtil.flip(array, first, first + num - 1);
    }

    public static void flip(int[] array, int first, int last) {
        for (int i = first; i <= last; ++i) {
            int k = array[i];
            array[i] = k >>> 24 & 0xFF | k >>> 8 & 0xFF00 | (k & 0xFF) << 24 | (k & 0xFF00) << 8;
        }
    }

    public static int bytesToInteger(byte[] b, int off) {
        int k = (b[off] << 24) + (b[off + 1] << 16 & 0xFF0000) + (b[off + 2] << 8 & 0xFF00) + (b[off + 3] << 0 & 0xFF);
        return k;
    }

    public static int[] bytesToIntegerArray(byte[] b, int off, int num) {
        int[] values = new int[num];
        for (int i = 0; i < num; ++i) {
            byte[] bytes = new byte[4];
            System.arraycopy(b, i * 4, bytes, 0, 4);
            values[i] = McIDASUtil.bytesToInteger(bytes, 0);
        }
        return values;
    }

    public static String intBitsToString(int value) {
        byte[] bval = new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
        return new String(bval);
    }

    public static String intBitsToString(int[] values) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            sb.append(McIDASUtil.intBitsToString(values[i]));
        }
        return sb.toString();
    }

    public static boolean isChar(int value) {
        String valueString = McIDASUtil.intBitsToString(value);
        char[] chars = valueString.toCharArray();
        for (int i = 0; i < 4; ++i) {
            if (Character.UnicodeBlock.of(chars[i]).equals(Character.UnicodeBlock.BASIC_LATIN) && !Character.isISOControl(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean putAreaFile(String filename, AreaFile af) {
        try {
            FileOutputStream os = new FileOutputStream(filename);
            ObjectOutputStream oo = new ObjectOutputStream(os);
            oo.writeObject(af);
            oo.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static AreaFile getAreaFile(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            ObjectInputStream oi = new ObjectInputStream(is);
            AreaFile af = (AreaFile)oi.readObject();
            oi.close();
            return af;
        }
        catch (Exception ei) {
            ei.printStackTrace();
            return null;
        }
    }
}

