/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.grads.GradsDimension;
import ucar.nc2.iosp.grads.GradsTimeStruct;
import ucar.nc2.units.DateUnit;

public class GradsTimeDimension
extends GradsDimension {
    private static Logger logger = LoggerFactory.getLogger(GradsTimeDimension.class);
    private final String[] incStr = new String[]{"mn", "hr", "dy", "mo", "yr"};
    private final int[] calIncs = new int[]{12, 10, 5, 2, 1};
    private final String[] dateFormats = new String[]{"HH:mm'z'ddMMMyyyy", "HH'z'ddMMMyyyy", "ddMMMyyyy", "MMMyyyy"};
    private GradsTimeStruct initialTime;
    private static final String[] timeTemplates = new String[]{"%x1", "%x3", "%y2", "%y4", "%m1", "%m2", "%mc", "%d1", "%d2", "%h1", "%h2", "%h3", "%n2", "%f2", "%f3", "%fn2", "%fhn", "%fdhn", "%j3", "%t1", "%t2", "%t3", "%t4", "%t5", "%t6", "%tm1", "%tm2", "%tm3", "%tm4", "%tm5", "%tm6", "%ix1", "%ix3", "%iy2", "%iy4", "%im1", "%im2", "%imc", "%id1", "%id2", "%ih1", "%ih2", "%ih3", "%in2"};

    public GradsTimeDimension(String name, int size, String mapping) {
        super(name, size, mapping);
    }

    @Override
    protected double[] makeLevelValues() {
        List<String> levels = this.getLevels();
        if (levels == null) {
            return null;
        }
        if (levels.size() != this.getSize()) {
            // empty if block
        }
        int inc = 0;
        double[] vals = new double[this.getSize()];
        String tstart = levels.get(0).trim().toLowerCase();
        String pattern = tstart.contains(":") ? this.dateFormats[0] : (tstart.contains("z") ? this.dateFormats[1] : (Character.isLetter(tstart.charAt(0)) ? this.dateFormats[3] : this.dateFormats[2]));
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        ParsePosition p = new ParsePosition(0);
        Date d = sdf.parse(tstart, p);
        if (d == null) {
            logger.warn("couldn't parse at " + p.getErrorIndex());
            d = new Date(0L);
        }
        sdf.applyPattern("yyyy-MM-dd HH:mm:ss Z");
        this.setUnit("hours since " + sdf.format(d, new StringBuffer(), new FieldPosition(0)));
        String tinc = levels.get(1).toLowerCase();
        int incIndex = 0;
        for (int i = 0; i < this.incStr.length; ++i) {
            int numOf;
            int index = tinc.indexOf(this.incStr[i]);
            if (index < 0) continue;
            inc = numOf = Integer.parseInt(tinc.substring(0, index));
            incIndex = i;
            break;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(d);
        vals[0] = 0.0;
        this.initialTime = this.makeTimeStruct(calendar);
        int calInc = this.calIncs[incIndex];
        double hours = 3600000.0;
        for (int i = 1; i < this.getSize(); ++i) {
            double offset;
            calendar.add(calInc, inc);
            vals[i] = offset = (double)(calendar.getTime().getTime() - d.getTime()) / hours;
        }
        return vals;
    }

    public GradsTimeStruct makeTimeStruct(int timeIndex) {
        double tVal = this.getValues()[timeIndex];
        Date d = DateUnit.getStandardDate((String)(tVal + " " + this.getUnit()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(d);
        return this.makeTimeStruct(calendar);
    }

    private GradsTimeStruct makeTimeStruct(Calendar calendar) {
        GradsTimeStruct ts = new GradsTimeStruct();
        ts.year = calendar.get(1);
        ts.month = calendar.get(2) + 1;
        ts.day = calendar.get(5);
        ts.hour = calendar.get(11);
        ts.minute = calendar.get(12);
        ts.jday = calendar.get(6);
        return ts;
    }

    public String replaceFileTemplate(String filespec, int timeIndex) {
        GradsTimeStruct ts = this.makeTimeStruct(timeIndex);
        String retString = filespec;
        while (GradsTimeDimension.hasTimeTemplate(retString)) {
            int tdif;
            String format;
            int val;
            int cent;
            if (retString.contains("%ix1")) {
                retString = retString.replaceAll("%ix1", String.format("%d", this.initialTime.year / 10));
            }
            if (retString.contains("%ix3")) {
                retString = retString.replaceAll("%ix3", String.format("%03d", this.initialTime.year / 10));
            }
            if (retString.contains("%iy2")) {
                cent = this.initialTime.year / 100;
                val = this.initialTime.year - cent * 100;
                retString = retString.replaceAll("%iy2", String.format("%02d", val));
            }
            if (retString.contains("%iy4")) {
                retString = retString.replaceAll("%iy4", String.format("%d", this.initialTime.year));
            }
            if (retString.contains("%im1")) {
                retString = retString.replaceAll("%im1", String.format("%d", this.initialTime.month));
            }
            if (retString.contains("%im2")) {
                retString = retString.replaceAll("%im2", String.format("%02d", this.initialTime.month));
            }
            if (retString.contains("%imc")) {
                retString = retString.replaceAll("%imc", GradsTimeStruct.months[this.initialTime.month - 1]);
            }
            if (retString.contains("%id1")) {
                retString = retString.replaceAll("%id1", String.format("%d", this.initialTime.day));
            }
            if (retString.contains("%id2")) {
                retString = retString.replaceAll("%id2", String.format("%02d", this.initialTime.day));
            }
            if (retString.contains("%ih1")) {
                retString = retString.replaceAll("%ih1", String.format("%d", this.initialTime.hour));
            }
            if (retString.contains("%ih2")) {
                retString = retString.replaceAll("%ih2", String.format("%02d", this.initialTime.hour));
            }
            if (retString.contains("%ih3")) {
                retString = retString.replaceAll("%ih3", String.format("%03d", this.initialTime.hour));
            }
            if (retString.contains("%in2")) {
                retString = retString.replaceAll("%in2", String.format("%02d", this.initialTime.minute));
            }
            if (retString.contains("%x1")) {
                retString = retString.replaceAll("%x1", String.format("%d", ts.year / 10));
            }
            if (retString.contains("%x3")) {
                retString = retString.replaceAll("%x3", String.format("%03d", ts.year / 10));
            }
            if (retString.contains("%y2")) {
                cent = ts.year / 100;
                val = ts.year - cent * 100;
                retString = retString.replaceAll("%y2", String.format("%02d", val));
            }
            if (retString.contains("%y4")) {
                retString = retString.replaceAll("%y4", String.format("%d", ts.year));
            }
            if (retString.contains("%m1")) {
                retString = retString.replaceAll("%m1", String.format("%d", ts.month));
            }
            if (retString.contains("%m2")) {
                retString = retString.replaceAll("%m2", String.format("%02d", ts.month));
            }
            if (retString.contains("%mc")) {
                retString = retString.replaceAll("%mc", GradsTimeStruct.months[ts.month - 1]);
            }
            if (retString.contains("%d1")) {
                retString = retString.replaceAll("%d1", String.format("%d", ts.day));
            }
            if (retString.contains("%d2")) {
                retString = retString.replaceAll("%d2", String.format("%02d", ts.day));
            }
            if (retString.contains("%h1")) {
                retString = retString.replaceAll("%h1", String.format("%d", ts.hour));
            }
            if (retString.contains("%h2")) {
                retString = retString.replaceAll("%h2", String.format("%02d", ts.hour));
            }
            if (retString.contains("%h3")) {
                retString = retString.replaceAll("%h3", String.format("%03d", ts.hour));
            }
            if (retString.contains("%n2")) {
                retString = retString.replaceAll("%n2", String.format("%02d", ts.minute));
            }
            if (retString.contains("%j3")) {
                retString = retString.replaceAll("%j3", String.format("%03d", ts.jday));
            }
            if (retString.contains("%t1")) {
                retString = retString.replaceAll("%t1", String.format("%d", timeIndex + 1));
            }
            if (retString.contains("%t2")) {
                retString = retString.replaceAll("%t2", String.format("%02d", timeIndex + 1));
            }
            if (retString.contains("%t3")) {
                retString = retString.replaceAll("%t3", String.format("%03d", timeIndex + 1));
            }
            if (retString.contains("%t4")) {
                retString = retString.replaceAll("%t4", String.format("%04d", timeIndex + 1));
            }
            if (retString.contains("%t5")) {
                retString = retString.replaceAll("%t5", String.format("%05d", timeIndex + 1));
            }
            if (retString.contains("%t6")) {
                retString = retString.replaceAll("%t6", String.format("%06d", timeIndex + 1));
            }
            if (retString.contains("%tm1")) {
                retString = retString.replaceAll("%tm1", String.format("%d", timeIndex));
            }
            if (retString.contains("%tm2")) {
                retString = retString.replaceAll("%tm2", String.format("%02d", timeIndex));
            }
            if (retString.contains("%tm3")) {
                retString = retString.replaceAll("%tm3", String.format("%03d", timeIndex));
            }
            if (retString.contains("%tm4")) {
                retString = retString.replaceAll("%tm4", String.format("%04d", timeIndex));
            }
            if (retString.contains("%tm5")) {
                retString = retString.replaceAll("%tm5", String.format("%05d", timeIndex));
            }
            if (retString.contains("%tm6")) {
                retString = retString.replaceAll("%tm6", String.format("%06d", timeIndex));
            }
            if (!retString.contains("%f")) continue;
            int mins = (int)this.getValues()[timeIndex] * 60;
            if (retString.contains("%f2")) {
                format = "%02d";
                tdif = mins / 60;
                if (tdif > 99) {
                    format = "%d";
                }
                retString = retString.replaceAll("%f2", String.format(format, tdif));
            }
            if (retString.contains("%f3")) {
                format = "%03d";
                tdif = mins / 60;
                if (tdif > 999) {
                    format = "%d";
                }
                retString = retString.replaceAll("%f3", String.format(format, tdif));
            }
            if (retString.contains("%fn2")) {
                format = "%02d";
                if (mins > 99) {
                    format = "%d";
                }
                retString = retString.replaceAll("%fn2", String.format(format, mins));
            }
            if (retString.contains("%fhn2")) {
                tdif = mins;
                int hrs = tdif / 60;
                int mns = tdif - hrs * 60;
                format = "%02d%02d";
                if (hrs > 99) {
                    format = "%d%02d";
                }
                retString = retString.replaceAll("%fhn2", String.format(format, hrs, mns));
            }
            if (!retString.contains("%fdhn2")) continue;
            tdif = mins;
            int dys = tdif / 1440;
            int hrs = (tdif - dys * 1440) / 60;
            int mns = tdif - dys * 1440 - hrs * 60;
            format = "%02d%02d%02d";
            if (dys > 99) {
                format = "%d%02d%02d";
            }
            retString = retString.replaceAll("%fdhn2", String.format(format, dys, hrs, mns));
        }
        return retString;
    }

    public static boolean hasTimeTemplate(String template) {
        for (String timeTemplate : timeTemplates) {
            if (!template.contains(timeTemplate)) continue;
            return true;
        }
        return false;
    }
}

