/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nexrad2;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.nexrad2.Level2Record;
import ucar.nc2.iosp.nexrad2.NexradStationDB;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.bzip2.BZip2ReadException;
import ucar.unidata.io.bzip2.CBZip2InputStream;

public class Level2VolumeScan {
    static final String ARCHIVE2 = "ARCHIVE2";
    static final String AR2V0001 = "AR2V0001";
    static final String AR2V0002 = "AR2V0002";
    static final String AR2V0003 = "AR2V0003";
    static final String AR2V0004 = "AR2V0004";
    static final String AR2V0006 = "AR2V0006";
    static final String AR2V0007 = "AR2V0007";
    private static Logger log = LoggerFactory.getLogger(Level2VolumeScan.class);
    RandomAccessFile raf;
    private String dataFormat;
    private int title_julianDay;
    private int title_msecs;
    private String stationId;
    private NexradStationDB.Station station;
    private Level2Record first;
    private Level2Record last;
    private int vcp;
    private int max_radials;
    private int min_radials = Integer.MAX_VALUE;
    private int max_radials_hr;
    private int min_radials_hr = Integer.MAX_VALUE;
    private int dopplarResolution;
    private boolean hasDifferentDopplarResolutions;
    private boolean hasHighResolutionData;
    private boolean hasHighResolutionREF;
    private boolean hasHighResolutionVEL;
    private boolean hasHighResolutionSW;
    private boolean hasHighResolutionZDR;
    private boolean hasHighResolutionPHI;
    private boolean hasHighResolutionRHO;
    private List<List<Level2Record>> reflectivityGroups;
    private List<List<Level2Record>> dopplerGroups;
    private List<List<Level2Record>> reflectivityHighResGroups;
    private List<List<Level2Record>> velocityHighResGroups;
    private List<List<Level2Record>> spectrumHighResGroups;
    private List<List<Level2Record>> diffReflectHighResGroups;
    private List<List<Level2Record>> diffPhaseHighResGroups;
    private List<List<Level2Record>> coefficientHighResGroups;
    private boolean showMessages;
    private boolean showData;
    private boolean debugScans;
    private boolean debugGroups2;
    private boolean debugRadials;
    private boolean runCheck;
    private int MAX_RADIAL = 721;
    private int[] radial = new int[this.MAX_RADIAL];

    Level2VolumeScan(RandomAccessFile orgRaf, CancelTask cancelTask) throws IOException {
        Level2Record r;
        this.raf = orgRaf;
        if (log.isDebugEnabled()) {
            log.debug("Level2VolumeScan on " + this.raf.getLocation());
        }
        this.raf.seek(0L);
        this.raf.order(0);
        this.dataFormat = this.raf.readString(8);
        this.raf.skipBytes(4);
        this.title_julianDay = this.raf.readInt();
        this.title_msecs = this.raf.readInt();
        this.stationId = this.raf.readString(4).trim();
        if (log.isDebugEnabled()) {
            log.debug(" dataFormat= " + this.dataFormat + " stationId= " + this.stationId);
        }
        if (this.stationId.isEmpty()) {
            this.stationId = null;
        }
        if (this.stationId != null) {
            if (!this.stationId.startsWith("K") && this.stationId.length() == 4) {
                String _stationId = "K" + this.stationId;
                this.station = NexradStationDB.get(_stationId);
            } else {
                this.station = NexradStationDB.get(this.stationId);
            }
        }
        if (this.dataFormat.equals(AR2V0001) || this.dataFormat.equals(AR2V0003) || this.dataFormat.equals(AR2V0004) || this.dataFormat.equals(AR2V0006) || this.dataFormat.equals(AR2V0007)) {
            this.raf.skipBytes(4);
            String BZ = this.raf.readString(2);
            if (BZ.equals("BZ")) {
                RandomAccessFile uraf = null;
                File uncompressedFile = DiskCache.getFileStandardPolicy((String)(this.raf.getLocation() + ".uncompress"));
                if (uncompressedFile.exists() && uncompressedFile.length() > 0L) {
                    try (FileInputStream fstream = new FileInputStream(uncompressedFile);){
                        while (true) {
                            try {
                                fstream.getChannel().lock(0L, 1L, true);
                            }
                            catch (OverlappingFileLockException oe) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e1) {
                                    break;
                                }
                            }
                        }
                    }
                    uraf = RandomAccessFile.acquire((String)uncompressedFile.getPath());
                } else {
                    try {
                        this.uncompress(this.raf, uncompressedFile.getPath());
                        uraf = new RandomAccessFile(uncompressedFile.getPath(), "r");
                        if (log.isDebugEnabled()) {
                            log.debug("made uncompressed file= " + uncompressedFile.getPath());
                        }
                    }
                    catch (Throwable t) {
                        if (uraf != null) {
                            uraf.close();
                        }
                        throw t;
                    }
                }
                this.raf.close();
                this.raf = uraf;
                this.raf.order(0);
            }
            this.raf.seek(24L);
        }
        ArrayList<Level2Record> reflectivity = new ArrayList<Level2Record>();
        ArrayList<Level2Record> doppler = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highReflectivity = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highVelocity = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highSpectrum = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highDiffReflectivity = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highDiffPhase = new ArrayList<Level2Record>();
        ArrayList<Level2Record> highCorreCoefficient = new ArrayList<Level2Record>();
        long message_offset31 = 0L;
        int recno = 0;
        while ((r = Level2Record.factory(this.raf, recno++, message_offset31)) != null) {
            if (this.showData) {
                r.dump2(System.out);
            }
            if (r.message_type == 31) {
                message_offset31 += (long)(r.message_size * 2 + 12 - 2432);
            }
            if (r.message_type != 1 && r.message_type != 31) {
                if (!this.showMessages) continue;
                r.dumpMessage(System.out);
                continue;
            }
            if (this.vcp == 0) {
                this.vcp = r.vcp;
            }
            if (this.first == null) {
                this.first = r;
            }
            this.last = r;
            if (this.runCheck && !r.checkOk()) continue;
            if (r.hasReflectData) {
                reflectivity.add(r);
            }
            if (r.hasDopplerData) {
                doppler.add(r);
            }
            if (r.message_type == 31) {
                if (r.hasHighResREFData) {
                    highReflectivity.add(r);
                }
                if (r.hasHighResVELData) {
                    highVelocity.add(r);
                }
                if (r.hasHighResSWData) {
                    highSpectrum.add(r);
                }
                if (r.hasHighResZDRData) {
                    highDiffReflectivity.add(r);
                }
                if (r.hasHighResPHIData) {
                    highDiffPhase.add(r);
                }
                if (r.hasHighResRHOData) {
                    highCorreCoefficient.add(r);
                }
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        if (this.debugRadials) {
            System.out.println(" reflect ok= " + reflectivity.size() + " doppler ok= " + doppler.size());
        }
        if (highReflectivity.isEmpty()) {
            this.reflectivityGroups = this.sortScans("reflect", reflectivity, 600);
            this.dopplerGroups = this.sortScans("doppler", doppler, 600);
        }
        if (!highReflectivity.isEmpty()) {
            this.reflectivityHighResGroups = this.sortScans("reflect_HR", highReflectivity, 720);
        }
        if (!highVelocity.isEmpty()) {
            this.velocityHighResGroups = this.sortScans("velocity_HR", highVelocity, 720);
        }
        if (!highSpectrum.isEmpty()) {
            this.spectrumHighResGroups = this.sortScans("spectrum_HR", highSpectrum, 720);
        }
        if (!highDiffReflectivity.isEmpty()) {
            this.diffReflectHighResGroups = this.sortScans("diffReflect_HR", highDiffReflectivity, 720);
        }
        if (!highDiffPhase.isEmpty()) {
            this.diffPhaseHighResGroups = this.sortScans("diffPhase_HR", highDiffPhase, 720);
        }
        if (!highCorreCoefficient.isEmpty()) {
            this.coefficientHighResGroups = this.sortScans("coefficient_HR", highCorreCoefficient, 720);
        }
    }

    private List<List<Level2Record>> sortScans(String name, List<Level2Record> scans, int siz) {
        HashMap<Short, List> groupHash = new HashMap<Short, List>(siz);
        for (Level2Record record : scans) {
            List list = groupHash.computeIfAbsent(record.elevation_num, k -> new ArrayList());
            list.add(record);
        }
        ArrayList<List<Level2Record>> groups = new ArrayList<List<Level2Record>>(groupHash.values());
        groups.sort(new GroupComparator());
        for (List list : groups) {
            Level2Record r = (Level2Record)list.get(0);
            if (this.runCheck) {
                this.testScan(name, list);
            }
            if (r.getGateCount(5) > 500 || r.getGateCount(6) > 1000) {
                if (list.size() <= 360) {
                    this.max_radials = Math.max(this.max_radials, list.size());
                    this.min_radials = Math.min(this.min_radials, list.size());
                    continue;
                }
                this.max_radials_hr = Math.max(this.max_radials_hr, list.size());
                this.min_radials_hr = Math.min(this.min_radials_hr, list.size());
                continue;
            }
            this.max_radials = Math.max(this.max_radials, list.size());
            this.min_radials = Math.min(this.min_radials, list.size());
        }
        if (this.debugRadials) {
            System.out.println(name + " min_radials= " + this.min_radials + " max_radials= " + this.max_radials);
            for (List list : groups) {
                Level2Record lastr = (Level2Record)list.get(0);
                for (int j = 1; j < list.size(); ++j) {
                    Level2Record r = (Level2Record)list.get(j);
                    if (r.data_msecs < lastr.data_msecs) {
                        System.out.println(" out of order " + j);
                    }
                    lastr = r;
                }
            }
        }
        this.testVariable(name, groups);
        if (this.debugScans) {
            System.out.println("-----------------------------");
        }
        return groups;
    }

    public int getMaxRadials(int r) {
        if (r == 0) {
            return this.max_radials;
        }
        if (r == 1) {
            return this.max_radials_hr;
        }
        return 0;
    }

    public int getMinRadials(int r) {
        if (r == 0) {
            return this.min_radials;
        }
        if (r == 1) {
            return this.min_radials_hr;
        }
        return 0;
    }

    public int getDopplarResolution() {
        return this.dopplarResolution;
    }

    public boolean hasDifferentDopplarResolutions() {
        return this.hasDifferentDopplarResolutions;
    }

    public boolean hasHighResolutions(int dt) {
        if (dt == 0) {
            return this.hasHighResolutionData;
        }
        if (dt == 1) {
            return this.hasHighResolutionREF;
        }
        if (dt == 2) {
            return this.hasHighResolutionVEL;
        }
        if (dt == 3) {
            return this.hasHighResolutionSW;
        }
        if (dt == 4) {
            return this.hasHighResolutionZDR;
        }
        if (dt == 5) {
            return this.hasHighResolutionPHI;
        }
        if (dt == 6) {
            return this.hasHighResolutionRHO;
        }
        return false;
    }

    private boolean testScan(String name, List<Level2Record> group) {
        int datatype = name.equals("reflect") ? 1 : 2;
        Level2Record first = group.get(0);
        int n = group.size();
        if (this.debugScans) {
            boolean hasBoth = first.hasDopplerData && first.hasReflectData;
            System.out.println(name + " " + first + " has " + n + " radials resolution= " + first.resolution + " has both = " + hasBoth);
        }
        boolean ok = true;
        for (int i = 0; i < this.MAX_RADIAL; ++i) {
            this.radial[i] = 0;
        }
        for (Level2Record r : group) {
            if (r.getGateSize(datatype) != first.getGateSize(datatype)) {
                log.warn(this.raf.getLocation() + " different gate size (" + r.getGateSize(datatype) + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.getGateStart(datatype) != first.getGateStart(datatype)) {
                log.warn(this.raf.getLocation() + " different gate start (" + r.getGateStart(datatype) + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.resolution != first.resolution) {
                log.warn(this.raf.getLocation() + " different resolution (" + r.resolution + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.radial_num < 0 || r.radial_num >= this.MAX_RADIAL) {
                log.info(this.raf.getLocation() + " radial out of range= " + r.radial_num + " in record " + name + " " + r);
                continue;
            }
            if (this.radial[r.radial_num] > 0) {
                log.warn(this.raf.getLocation() + " duplicate radial = " + r.radial_num + " in record " + name + " " + r);
                ok = false;
            }
            this.radial[r.radial_num] = r.recno + 1;
        }
        for (int i = 1; i < this.radial.length; ++i) {
            if (0 != this.radial[i]) continue;
            if (n == i - 1) break;
            log.warn(" missing radial(s)");
            ok = false;
            break;
        }
        return ok;
    }

    private boolean testVariable(String name, List scans) {
        int datatype;
        int n = datatype = name.equals("reflect") ? 1 : 2;
        if (scans.isEmpty()) {
            log.warn(" No data for = " + name);
            return false;
        }
        boolean ok = true;
        List firstScan = (List)scans.get(0);
        Level2Record firstRecord = (Level2Record)firstScan.get(0);
        this.dopplarResolution = firstRecord.resolution;
        if (this.debugGroups2) {
            System.out.println("Group " + Level2Record.getDatatypeName(datatype) + " ngates = " + firstRecord.getGateCount(datatype) + " start = " + firstRecord.getGateStart(datatype) + " size = " + firstRecord.getGateSize(datatype));
        }
        for (int i = 1; i < scans.size(); ++i) {
            List scan = (List)scans.get(i);
            Level2Record record = (Level2Record)scan.get(0);
            if (datatype == 2 && record.resolution != firstRecord.resolution) {
                log.warn(name + " scan " + i + " diff resolutions = " + record.resolution + ", " + firstRecord.resolution + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
                this.hasDifferentDopplarResolutions = true;
            }
            if (record.getGateSize(datatype) != firstRecord.getGateSize(datatype)) {
                log.warn(name + " scan " + i + " diff gates size = " + record.getGateSize(datatype) + " " + firstRecord.getGateSize(datatype) + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
            } else if (this.debugGroups2) {
                System.out.println(" ok gates size elev= " + record.elevation_num + " " + record.getElevation());
            }
            if (record.getGateStart(datatype) != firstRecord.getGateStart(datatype)) {
                log.warn(name + " scan " + i + " diff gates start = " + record.getGateStart(datatype) + " " + firstRecord.getGateStart(datatype) + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
            } else if (this.debugGroups2) {
                System.out.println(" ok gates start elev= " + record.elevation_num + " " + record.getElevation());
            }
            if (record.message_type != 31) continue;
            this.hasHighResolutionData = true;
            if (record.hasHighResREFData) {
                this.hasHighResolutionREF = true;
            }
            if (record.hasHighResVELData) {
                this.hasHighResolutionVEL = true;
            }
            if (record.hasHighResSWData) {
                this.hasHighResolutionSW = true;
            }
            if (record.hasHighResZDRData) {
                this.hasHighResolutionZDR = true;
            }
            if (record.hasHighResPHIData) {
                this.hasHighResolutionPHI = true;
            }
            if (!record.hasHighResRHOData) continue;
            this.hasHighResolutionRHO = true;
        }
        return ok;
    }

    public List<List<Level2Record>> getReflectivityGroups() {
        return this.reflectivityGroups;
    }

    public List<List<Level2Record>> getVelocityGroups() {
        return this.dopplerGroups;
    }

    public List<List<Level2Record>> getHighResVelocityGroups() {
        return this.velocityHighResGroups;
    }

    public List<List<Level2Record>> getHighResReflectivityGroups() {
        return this.reflectivityHighResGroups;
    }

    public List<List<Level2Record>> getHighResSpectrumGroups() {
        return this.spectrumHighResGroups;
    }

    public List<List<Level2Record>> getHighResDiffReflectGroups() {
        return this.diffReflectHighResGroups;
    }

    public List<List<Level2Record>> getHighResDiffPhaseGroups() {
        return this.diffPhaseHighResGroups;
    }

    public List<List<Level2Record>> getHighResCoeffocientGroups() {
        return this.coefficientHighResGroups;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public int getTitleJulianDays() {
        return this.title_julianDay;
    }

    public int getTitleMsecs() {
        return this.title_msecs;
    }

    public int getVCP() {
        return this.vcp;
    }

    public String getStationId() {
        return this.stationId;
    }

    public String getStationName() {
        return this.station == null ? "unknown" : this.station.name;
    }

    public double getStationLatitude() {
        return this.station == null ? 0.0 : this.station.lat;
    }

    public double getStationLongitude() {
        return this.station == null ? 0.0 : this.station.lon;
    }

    public double getStationElevation() {
        return this.station == null ? 0.0 : this.station.elev;
    }

    public Date getStartDate() {
        return this.first.getDate();
    }

    public Date getEndDate() {
        return this.last.getDate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uncompress(RandomAccessFile inputRaf, String ufilename) throws IOException {
        FileLock lock = null;
        boolean needsDelete = false;
        try (RandomAccessFile outputRaf = new RandomAccessFile(ufilename, "rw");){
            while (true) {
                try {
                    lock = outputRaf.getRandomAccessFile().getChannel().lock(0L, 1L, false);
                }
                catch (OverlappingFileLockException oe) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                break;
            }
            needsDelete = true;
            inputRaf.seek(0L);
            byte[] header = new byte[24];
            int bytesRead = inputRaf.read(header);
            if (bytesRead != header.length) {
                throw new IOException("Error reading NEXRAD2 header -- got " + bytesRead + " rather than" + header.length);
            }
            outputRaf.write(header);
            boolean eof = false;
            byte[] ubuff = new byte[40000];
            byte[] obuff = new byte[40000];
            CBZip2InputStream cbzip2 = new CBZip2InputStream();
            while (!eof) {
                int numCompBytes;
                try {
                    numCompBytes = inputRaf.readInt();
                    if (numCompBytes == -1) {
                        if (!log.isDebugEnabled()) return;
                        log.debug("  done: numCompBytes=-1 ");
                        return;
                    }
                }
                catch (EOFException ee) {
                    log.debug("got EOFException");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("reading compressed bytes " + numCompBytes + " input starts at " + inputRaf.getFilePointer() + "; output starts at " + outputRaf.getFilePointer());
                }
                if (numCompBytes < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("last block?" + numCompBytes);
                    }
                    numCompBytes = -numCompBytes;
                    eof = true;
                }
                byte[] buf = new byte[numCompBytes];
                inputRaf.readFully(buf);
                ByteArrayInputStream bis = new ByteArrayInputStream(buf, 2, numCompBytes - 2);
                cbzip2.setStream((InputStream)bis);
                int total = 0;
                try {
                    int nread;
                    while ((nread = cbzip2.read(ubuff)) != -1) {
                        if (total + nread > obuff.length) {
                            byte[] temp = obuff;
                            obuff = new byte[temp.length * 2];
                            System.arraycopy(temp, 0, obuff, 0, temp.length);
                        }
                        System.arraycopy(ubuff, 0, obuff, total, nread);
                        total += nread;
                    }
                    if (total >= 0) {
                        outputRaf.write(obuff, 0, total);
                    }
                }
                catch (BZip2ReadException ioe) {
                    log.warn("Nexrad2IOSP.uncompress ", (Throwable)ioe);
                }
                float nrecords = (float)((double)total / 2432.0);
                if (!log.isDebugEnabled()) continue;
                log.debug("  unpacked " + total + " num bytes " + nrecords + " records; ouput ends at " + outputRaf.getFilePointer());
            }
            return;
        }
        catch (Throwable t) {
            if (!needsDelete) throw t;
            File ufile = new File(ufilename);
            if (!ufile.exists()) throw t;
            if (ufile.delete()) throw t;
            log.warn("failed to delete bad uncompressed file (IOException)" + ufilename);
            throw t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long testValid(String ufilename) throws IOException {
        boolean lookForHeader = false;
        try (RandomAccessFile raf = RandomAccessFile.acquire((String)ufilename);){
            raf.order(0);
            raf.seek(0L);
            String test = raf.readString(8);
            if (test.equals(ARCHIVE2) || test.startsWith("AR2V000")) {
                System.out.println("--Good header= " + test);
                raf.seek(24L);
            } else {
                System.out.println("--No header ");
                lookForHeader = true;
                raf.seek(0L);
            }
            boolean eof = false;
            while (!eof) {
                int numCompBytes;
                block25: {
                    if (lookForHeader) {
                        test = raf.readString(8);
                        if (test.equals(ARCHIVE2) || test.startsWith("AR2V000")) {
                            System.out.println("  found header= " + test);
                            raf.skipBytes(16);
                            lookForHeader = false;
                        } else {
                            raf.skipBytes(-8);
                        }
                    }
                    try {
                        numCompBytes = raf.readInt();
                        if (numCompBytes == -1) {
                            System.out.println("\n--done: numCompBytes=-1 ");
                        }
                        break block25;
                    }
                    catch (EOFException ee) {
                        System.out.println("\n--got EOFException ");
                    }
                    break;
                }
                System.out.print(" " + numCompBytes + ",");
                if (numCompBytes < 0) {
                    System.out.println("\n--last block " + numCompBytes);
                    numCompBytes = -numCompBytes;
                    if (!lookForHeader) {
                        eof = true;
                    }
                }
                raf.skipBytes(numCompBytes);
            }
            long l = raf.getFilePointer();
            return l;
        }
        catch (EOFException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static class GroupComparator
    implements Comparator<List<Level2Record>> {
        private GroupComparator() {
        }

        @Override
        public int compare(List<Level2Record> group1, List<Level2Record> group2) {
            Level2Record record1 = group1.get(0);
            Level2Record record2 = group2.get(0);
            return record1.elevation_num - record2.elevation_num;
        }
    }
}

