/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nids;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.nexrad2.NexradStationDB;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.projection.FlatEarth;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.bzip2.BZip2ReadException;
import ucar.unidata.io.bzip2.CBZip2InputStream;
import ucar.unidata.util.Parameter;

class Nidsheader {
    private static final boolean useStationDB = false;
    private static final Logger log = LoggerFactory.getLogger(Nidsheader.class);
    private static final Pattern PARAM_PATTERN = Pattern.compile((String)"([\\w*\\s*?]*)\\=([(\\<|\\{|\\[|\\()?\\w*\\s*?\\.?\\,?\\-?\\/?\\%?(\\>|\\}|\\]|\\))?]*)");
    static final int NEXR_PID_READ = 100;
    static final int DEF_NUM_ELEMS = 640;
    static final int DEF_NUM_LINES = 480;
    static final int NEXR_FILE_READ = -1;
    static final int NEXR_DIR_READ = 356;
    static final int READ_BUFFER_SIZE = 1;
    static final int ZLIB_BUF_LEN = 4000;
    byte Z_DEFLATED = (byte)8;
    byte DEF_WBITS = (byte)15;
    static final int Other = 0;
    static final int Base_Reflect = 1;
    static final int Velocity = 2;
    static final int Comp_Reflect = 3;
    static final int Layer_Reflect_Avg = 4;
    static final int Layer_Reflect_Max = 5;
    static final int Echo_Tops = 6;
    static final int Vert_Liquid = 7;
    static final int Precip_1 = 8;
    static final int Precip_3 = 9;
    static final int Precip_Accum = 10;
    static final int Precip_Array = 11;
    static final int BaseReflect248 = 12;
    static final int StrmRelMeanVel = 13;
    static final int VAD = 14;
    static final int SPECTRUM = 15;
    static final int DigitalHybridReflect = 16;
    static final int DigitalStormTotalPrecip = 17;
    static final int Reflect1 = 18;
    static final int Velocity1 = 19;
    static final int SPECTRUM1 = 20;
    static final int BaseReflectivityDR = 21;
    static final int BaseVelocityDV = 22;
    static final int EnhancedEcho_Tops = 23;
    static final int DigitalVert_Liquid = 24;
    static final int DigitalDifferentialReflectivity = 30;
    static final int DigitalCorrelationCoefficient = 31;
    static final int DigitalDifferentialPhase = 32;
    static final int HydrometeorClassification = 33;
    static final int OneHourAccumulation = 36;
    static final int DigitalAccumulationArray = 37;
    static final int StormTotalAccumulation = 38;
    static final int DigitalStormTotalAccumulation = 39;
    static final int Accumulation3Hour = 40;
    static final int Accumulation24Hour = 41;
    static final int Digital1HourDifferenceAccumulation = 42;
    static final int DigitalTotalDifferenceAccumulation = 43;
    static final int DigitalInstantaneousPrecipitationRate = 44;
    static final int HypridHydrometeorClassification = 45;
    short mcode;
    short mdate;
    int mtime;
    int mlength;
    short msource;
    short mdestId;
    short mNumOfBlock;
    short divider;
    double latitude;
    double lat_min;
    double lat_max;
    double longitude;
    double lon_min;
    double lon_max;
    double height;
    short pcode;
    short opmode;
    short volumnScanPattern;
    short sequenceNumber;
    short volumeScanNumber;
    short volumeScanDate;
    int volumeScanTime;
    short productDate;
    int productTime;
    short p1;
    short p2;
    short elevationNumber;
    short p3;
    short[] threshold = new short[16];
    short p4;
    short p5;
    short p6;
    short p7;
    short p8;
    short p9;
    short p10;
    short numberOfMaps;
    int offsetToSymbologyBlock;
    int offsetToGraphicBlock;
    int offsetToTabularBlock;
    int block_length;
    short number_layers;
    String stationId;
    String stationName = "XXX";
    private boolean noHeader;
    DateFormatter formatter = new DateFormatter();
    RandomAccessFile raf;
    private NetcdfFile ncfile;
    private String cmemo;
    private String ctilt;
    private String ctitle;
    private String cunit;
    private String cname;
    private int numX;
    private int numX0;
    private int numY;
    private int numY0;
    private boolean isR;
    private byte[] uncompdata;

    Nidsheader() {
    }

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            long t = raf.length();
            if (t == 0L) {
                throw new IOException("zero length file ");
            }
        }
        catch (IOException e) {
            return false;
        }
        try {
            int p = this.readWMO(raf);
            if (p == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    int readWMO(RandomAccessFile raf) throws IOException {
        int pos = 0;
        raf.seek((long)pos);
        int readLen = 35;
        byte[] b = new byte[readLen];
        int rc = raf.read(b);
        if (rc != readLen) {
            return 0;
        }
        int iarr2_1 = Nidsheader.bytesToInt(b[0], b[1], false);
        int iarr2_16 = Nidsheader.bytesToInt(b[30], b[31], false);
        int iarr2_10 = Nidsheader.bytesToInt(b[18], b[19], false);
        int iarr2_7 = Nidsheader.bytesToInt(b[12], b[13], false);
        if (iarr2_1 == iarr2_16 && iarr2_1 >= 16 && iarr2_1 <= 299 && iarr2_10 == -1 && iarr2_7 < 10000) {
            this.noHeader = true;
            return 1;
        }
        String pib = new String(b, StandardCharsets.UTF_8);
        if (pib.contains("SDUS")) {
            this.noHeader = false;
            return 1;
        }
        if (raf.getLocation().contains(".nids")) {
            this.noHeader = true;
            return 1;
        }
        return 0;
    }

    public byte[] getUncompData(int offset, int len) {
        if (len == 0) {
            len = this.uncompdata.length - offset;
        }
        byte[] data = new byte[len];
        System.arraycopy(this.uncompdata, offset, data, 0, len);
        return data;
    }

    public void setProperty(String name, String value) {
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile) throws IOException {
        int hoff = 0;
        boolean isZ = false;
        this.readWMO(raf);
        this.ncfile = ncfile;
        long actualSize = raf.length();
        int pos = 0;
        raf.seek((long)pos);
        int readLen = (int)actualSize;
        byte[] b = new byte[readLen];
        int rc = raf.read(b);
        if (rc != readLen) {
            log.warn(" error reading nids product header " + raf.getLocation());
        }
        if (!this.noHeader) {
            int encrypt;
            String pib = new String(b, 0, 100, StandardCharsets.UTF_8);
            int type = 0;
            pos = pib.indexOf("\r\r\n");
            while (pos != -1) {
                hoff = pos + 3;
                ++type;
                pos = pib.indexOf("\r\r\n", pos + 1);
            }
            raf.seek((long)hoff);
            byte[] b2 = new byte[2];
            System.arraycopy(b, hoff, b2, 0, 2);
            int zlibed = this.isZlibHed(b2);
            if (zlibed == 0 && (encrypt = this.IsEncrypt(b2)) == 1) {
                log.error("error reading encryted product " + raf.getLocation());
                throw new IOException("unable to handle the product with encrypt code " + encrypt);
            }
            byte[] b3 = new byte[3];
            switch (type) {
                case 0: {
                    log.warn("ReadNexrInfo:: Unable to seek to ID " + raf.getLocation());
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    System.arraycopy(b, hoff - 6, b3, 0, 3);
                    this.stationId = new String(b3, StandardCharsets.UTF_8);
                    try {
                        NexradStationDB.init();
                        NexradStationDB.Station station = NexradStationDB.get("K" + this.stationId);
                        if (station == null) break;
                        this.stationName = station.name;
                    }
                    catch (IOException ioe) {
                        log.error("NexradStationDB.init " + raf.getLocation(), (Throwable)ioe);
                    }
                    break;
                }
            }
            if (zlibed == 1) {
                isZ = true;
                this.uncompdata = this.GetZlibedNexr(b, readLen, hoff);
                if (this.uncompdata == null) {
                    log.warn("ReadNexrInfo: error uncompressing image " + raf.getLocation());
                    this.uncompdata = new byte[b.length - hoff];
                    System.arraycopy(b, hoff, this.uncompdata, 0, b.length - hoff);
                }
            } else {
                this.uncompdata = new byte[b.length - hoff];
                System.arraycopy(b, hoff, this.uncompdata, 0, b.length - hoff);
            }
        } else {
            this.uncompdata = new byte[b.length];
            System.arraycopy(b, 0, this.uncompdata, 0, b.length);
        }
        byte[] b2 = new byte[2];
        ByteBuffer bos = ByteBuffer.wrap(this.uncompdata);
        rc = this.read_msghead(bos, 0);
        int hedsiz = 18;
        Pinfo pinfo = this.read_proddesc(bos, hedsiz);
        hedsiz += 102;
        int prod_type = Nidsheader.code_typelookup(pinfo.pcode);
        this.setProductInfo(prod_type, pinfo);
        int pcode1Number = 0;
        int pcode2Number = 0;
        int pcode8Number = 0;
        int pcode4Number = 0;
        int pcode5Number = 0;
        int pcode10Number = 0;
        int pcode6Number = 0;
        int pcode25Number = 0;
        int pcode12Number = 0;
        int pcode13Number = 0;
        int pcode14Number = 0;
        int pcode15Number = 0;
        int pcode16Number = 0;
        int pcode19Number = 0;
        int pcode20Number = 0;
        int[] pkcode1Doff = null;
        int[] pkcode2Doff = null;
        int[] pkcode8Doff = null;
        int[] pkcode1Size = null;
        int[] pkcode2Size = null;
        int[] pkcode8Size = null;
        int[] pkcode4Doff = null;
        int[] pkcode5Doff = null;
        int[] pkcode10Doff = null;
        int[] pkcode10Dlen = null;
        int[] pkcode6Doff = null;
        int[] pkcode6Dlen = null;
        int[] pkcode25Doff = null;
        int[] pkcode12Doff = null;
        int[] pkcode13Doff = null;
        int[] pkcode14Doff = null;
        int[] pkcode12Dlen = null;
        int[] pkcode13Dlen = null;
        int[] pkcode14Dlen = null;
        int[] pkcode15Dlen = null;
        int[] pkcode15Doff = null;
        int[] pkcode16Dlen = null;
        int[] pkcode16Doff = null;
        int[] pkcode19Dlen = null;
        int[] pkcode19Doff = null;
        int[] pkcode20Dlen = null;
        int[] pkcode20Doff = null;
        if (pinfo.offsetToSymbologyBlock != 0) {
            if (pinfo.p8 == 1) {
                int size = Nidsheader.shortsToInt(pinfo.p9, pinfo.p10, false);
                this.uncompdata = this.uncompressed(bos, hedsiz, size);
                bos = ByteBuffer.wrap(this.uncompdata);
            }
            Sinfo sinfo = this.read_dividlen(bos, hedsiz);
            if (rc == 0 || pinfo.divider != -1) {
                log.warn("error in product symbology header " + raf.getLocation());
            }
            if (sinfo.id != 1) {
                if (pinfo.pcode == 82) {
                    this.read_SATab(bos, hedsiz);
                }
            } else {
                int klayer = pinfo.offsetToSymbologyBlock * 2 + 10;
                for (int i = 0; i < sinfo.nlayers; ++i) {
                    hedsiz = klayer;
                    bos.position(hedsiz);
                    short Divlen_divider = bos.getShort();
                    hedsiz += 2;
                    int Divlen_length = bos.getInt();
                    hedsiz += 4;
                    if (Divlen_divider != -1) {
                        log.warn("error reading length divider " + raf.getLocation());
                    }
                    int icount = 0;
                    while (icount < Divlen_length) {
                        int plen;
                        int boff = klayer + icount + 6;
                        bos.position(boff);
                        bos.get(b2);
                        int pkcode = this.getUInt(b2, 2);
                        hedsiz += 2;
                        boff += 2;
                        switch (pkcode) {
                            case 17: 
                            case 18: {
                                plen = this.pcode_DPA(bos, boff, hoff, hedsiz += 8, isZ, i, pkcode);
                                break;
                            }
                            case 10: {
                                if (pkcode10Doff == null) {
                                    pkcode10Doff = new int[250];
                                    pkcode10Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode10Doff[pcode10Number] = boff + 2;
                                pkcode10Dlen[pcode10Number] = (plen - 2) / 8;
                                ++pcode10Number;
                                break;
                            }
                            case 1: {
                                if (pkcode1Doff == null) {
                                    pkcode1Doff = new int[250];
                                    pkcode1Size = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode1Doff[pcode1Number] = boff + 2;
                                pkcode1Size[pcode1Number] = plen - 4;
                                ++pcode1Number;
                                break;
                            }
                            case 2: {
                                if (pkcode2Doff == null) {
                                    pkcode2Doff = new int[250];
                                    pkcode2Size = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode2Doff[pcode2Number] = boff + 2;
                                pkcode2Size[pcode2Number] = plen - 4;
                                ++pcode2Number;
                                break;
                            }
                            case 8: {
                                if (pkcode8Doff == null) {
                                    pkcode8Doff = new int[550];
                                    pkcode8Size = new int[550];
                                }
                                plen = bos.getShort();
                                pkcode8Doff[pcode8Number] = boff + 2;
                                pkcode8Size[pcode8Number] = plen - 6;
                                ++pcode8Number;
                                break;
                            }
                            case 3: 
                            case 11: 
                            case 25: {
                                if (pkcode25Doff == null) {
                                    pkcode25Doff = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode25Doff[pcode25Number] = boff + 2;
                                ++pcode25Number;
                                break;
                            }
                            case 12: {
                                if (pkcode12Doff == null) {
                                    pkcode12Doff = new int[250];
                                    pkcode12Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode12Doff[pcode12Number] = boff + 2;
                                pkcode12Dlen[pcode12Number] = plen / 4;
                                ++pcode12Number;
                                break;
                            }
                            case 13: {
                                if (pkcode13Doff == null) {
                                    pkcode13Doff = new int[250];
                                    pkcode13Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode13Doff[pcode13Number] = boff + 2;
                                pkcode13Dlen[pcode13Number] = plen / 4;
                                ++pcode13Number;
                                break;
                            }
                            case 14: {
                                if (pkcode14Doff == null) {
                                    pkcode14Doff = new int[250];
                                    pkcode14Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode14Doff[pcode14Number] = boff + 2;
                                pkcode14Dlen[pcode14Number] = plen / 4;
                                ++pcode14Number;
                                break;
                            }
                            case 15: {
                                if (pkcode15Doff == null) {
                                    pkcode15Doff = new int[250];
                                    pkcode15Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode15Doff[pcode15Number] = boff + 2;
                                pkcode15Dlen[pcode15Number] = plen / 6;
                                ++pcode15Number;
                                break;
                            }
                            case 166: {
                                if (pkcode16Doff == null) {
                                    pkcode16Doff = new int[250];
                                    pkcode16Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode16Doff[pcode16Number] = boff + 2;
                                pkcode16Dlen[pcode16Number] = plen / 4;
                                ++pcode16Number;
                                break;
                            }
                            case 19: {
                                if (pkcode19Doff == null) {
                                    pkcode19Doff = new int[250];
                                    pkcode19Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode19Doff[pcode19Number] = boff + 2;
                                pkcode19Dlen[pcode19Number] = plen / 10;
                                ++pcode19Number;
                                break;
                            }
                            case 20: {
                                if (pkcode20Doff == null) {
                                    pkcode20Doff = new int[250];
                                    pkcode20Dlen = new int[250];
                                }
                                plen = bos.getShort();
                                pkcode20Doff[pcode20Number] = boff + 2;
                                pkcode20Dlen[pcode20Number] = plen / 8;
                                ++pcode20Number;
                                break;
                            }
                            case 4: {
                                if (pkcode4Doff == null) {
                                    pkcode4Doff = new int[1000];
                                }
                                plen = bos.getShort();
                                pkcode4Doff[pcode4Number] = boff + 2;
                                ++pcode4Number;
                                break;
                            }
                            case 5: {
                                if (pkcode5Doff == null) {
                                    pkcode5Doff = new int[1000];
                                }
                                plen = bos.getShort();
                                pkcode5Doff[pcode5Number] = boff + 2;
                                ++pcode5Number;
                                break;
                            }
                            case 43: {
                                plen = bos.getShort();
                                break;
                            }
                            case 23: 
                            case 24: {
                                plen = bos.getShort();
                                int poff = 2;
                                while (poff < plen) {
                                    short pcode = bos.getShort();
                                    short len = bos.getShort();
                                    switch (pcode) {
                                        case 2: {
                                            if (pkcode2Doff == null) {
                                                pkcode2Doff = new int[250];
                                                pkcode2Size = new int[250];
                                            }
                                            pkcode2Doff[pcode2Number] = boff + poff + 4;
                                            pkcode2Size[pcode2Number] = len - 4;
                                            ++pcode2Number;
                                            break;
                                        }
                                        case 6: {
                                            if (pkcode6Doff == null) {
                                                pkcode6Doff = new int[250];
                                                pkcode6Dlen = new int[250];
                                            }
                                            pkcode6Doff[pcode6Number] = boff + poff + 4;
                                            pkcode6Dlen[pcode6Number] = (len - 6) / 4;
                                            ++pcode6Number;
                                            break;
                                        }
                                        case 25: {
                                            if (pkcode25Doff == null) {
                                                pkcode25Doff = new int[250];
                                            }
                                            pkcode25Doff[pcode25Number] = boff + poff + 4;
                                            ++pcode25Number;
                                            break;
                                        }
                                        default: {
                                            log.error("error reading pcode= " + pcode + " " + raf.getLocation());
                                            throw new IOException("error reading pcode, unable to handle the packet with code " + pcode);
                                        }
                                    }
                                    poff = poff + len + 4;
                                    bos.position(bos.position() + len);
                                }
                                break;
                            }
                            case 2050: {
                                log.warn("Encountered unhandled packet code 0x0802 (contour color) -- reading past.");
                                Divlen_divider = bos.getShort();
                                if (Divlen_divider != 2) {
                                    log.warn("Missing color marker!");
                                }
                                plen = 2;
                                break;
                            }
                            case 3587: {
                                log.warn("Encountered unhandled packet code 0x0E03 (linked contours) -- reading past.");
                                Divlen_divider = bos.getShort();
                                if (Divlen_divider != 32768) {
                                    log.warn("Missing start marker!");
                                }
                                bos.getShort();
                                bos.getShort();
                                plen = 6 + bos.getShort();
                                break;
                            }
                            default: {
                                if (pkcode == 44831 || pkcode == 16) {
                                    hedsiz += this.pcode_radial(bos, hoff, hedsiz, isZ, this.uncompdata, pinfo.threshold);
                                    plen = Divlen_length;
                                    break;
                                }
                                if (pkcode == 28) {
                                    hedsiz += this.pcode_generic(bos, hoff, hedsiz, isZ, this.uncompdata, pinfo.threshold);
                                    plen = Divlen_length;
                                    break;
                                }
                                if (pkcode == 47631 || pkcode == 47623) {
                                    hedsiz += this.pcode_raster(bos, (short)pkcode, hoff, hedsiz, isZ, this.uncompdata);
                                    plen = Divlen_length;
                                    break;
                                }
                                log.error("error reading pkcode equals " + pkcode + " " + raf.getLocation());
                                throw new IOException("error reading pkcode, unable to handle the product with code " + pkcode);
                            }
                        }
                        icount = icount + plen + 4;
                    }
                    klayer = klayer + Divlen_length + 6;
                }
                if (pkcode8Doff != null) {
                    this.pcode_128(pkcode8Doff, pkcode8Size, 8, hoff, pcode8Number, "textStruct_code8", "", isZ);
                }
                if (pkcode1Doff != null) {
                    this.pcode_128(pkcode1Doff, pkcode1Size, 1, hoff, pcode1Number, "textStruct_code1", "", isZ);
                }
                if (pkcode2Doff != null) {
                    this.pcode_128(pkcode2Doff, pkcode2Size, 2, hoff, pcode2Number, "textStruct_code2", "", isZ);
                }
                if (pkcode10Doff != null) {
                    this.pcode_10n9(pkcode10Doff, pkcode10Dlen, hoff, pcode10Number, isZ);
                }
                if (pkcode4Doff != null) {
                    this.pcode_4(pkcode4Doff, hoff, pcode4Number, isZ);
                }
                if (pkcode5Doff != null) {
                    this.pcode_5(pkcode5Doff, hoff, pcode5Number, isZ);
                }
                if (pkcode6Doff != null) {
                    this.pcode_6n7(pkcode6Doff, pkcode6Dlen, hoff, pcode6Number, isZ, "linkedVector", 6);
                }
                if (pkcode25Doff != null) {
                    this.pcode_25(pkcode25Doff, hoff, pcode25Number, isZ);
                }
                if (pkcode12Doff != null) {
                    this.pcode_12n13n14(pkcode12Doff, pkcode12Dlen, hoff, pcode12Number, isZ, "TVS", 12);
                }
                if (pkcode13Doff != null) {
                    this.pcode_12n13n14(pkcode13Doff, pkcode13Dlen, hoff, pcode13Number, isZ, "hailPositive", 13);
                }
                if (pkcode14Doff != null) {
                    this.pcode_12n13n14(pkcode14Doff, pkcode14Dlen, hoff, pcode14Number, isZ, "hailProbable", 14);
                }
                if (pkcode19Doff != null) {
                    this.pcode_12n13n14(pkcode19Doff, pkcode19Dlen, hoff, pcode19Number, isZ, "hailIndex", 19);
                }
                if (pkcode20Doff != null) {
                    this.pcode_12n13n14(pkcode20Doff, pkcode20Dlen, hoff, pcode20Number, isZ, "mesocyclone", 20);
                }
            }
        } else {
            log.debug("GetNexrDirs:: no product symbology block found (no image data) " + raf.getLocation());
        }
        if (pinfo.offsetToTabularBlock != 0) {
            int tlayer = pinfo.offsetToTabularBlock * 2;
            bos.position(tlayer);
            if (bos.hasRemaining()) {
                short tab_divider = bos.getShort();
                if (tab_divider != -1) {
                    log.error("Block divider not found " + raf.getLocation());
                    throw new IOException("error reading graphic alphanumeric block");
                }
                short tab_bid = bos.getShort();
                int tblen = bos.getInt();
                bos.position(tlayer + 116);
                int inc = bos.getInt();
                bos.position(tlayer + 128);
                tab_divider = bos.getShort();
                if (tab_divider != -1) {
                    log.error("tab divider not found " + raf.getLocation());
                    throw new IOException("error reading graphic alphanumeric block");
                }
                short npage = bos.getShort();
                int ppos = bos.position();
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                Dimension tbDim = new Dimension("pageNumber", (int)npage);
                ncfile.addDimension(null, tbDim);
                dims.add(tbDim);
                Variable ppage = new Variable(ncfile, null, null, "TabMessagePage");
                ppage.setDimensions(dims);
                ppage.setDataType(DataType.STRING);
                ppage.addAttribute(new Attribute("long_name", "Graphic Product Message"));
                ncfile.addVariable(null, ppage);
                ppage.setSPobject((Object)new Vinfo(npage, 0, tblen, 0, hoff, ppos, this.isR, isZ, null, null, tab_bid, 0));
            }
        }
        if (pinfo.offsetToGraphicBlock != 0) {
            int[] gpkcode1Doff = null;
            int[] gpkcode2Doff = null;
            int[] gpkcode10Doff = null;
            int[] gpkcode10Dlen = null;
            int[] gpkcode8Doff = null;
            int[] gpkcode1Size = null;
            int[] gpkcode2Size = null;
            int[] gpkcode8Size = null;
            int gpcode1Number = 0;
            int gpcode10Number = 0;
            int gpcode8Number = 0;
            boolean gpcode2Number = false;
            int tlayer = pinfo.offsetToGraphicBlock * 2;
            bos.position(tlayer);
            short graphic_divider = bos.getShort();
            short graphic_bid = bos.getShort();
            if (graphic_divider != -1 || graphic_bid != 2) {
                log.error("error reading graphic alphanumeric block " + raf.getLocation());
                throw new IOException("error reading graphic alphanumeric block");
            }
            int blen = bos.getInt();
            int clen = 0;
            short npage = bos.getShort();
            short ipage = 0;
            while (clen < blen && ipage < npage) {
                int ppos = bos.position();
                ipage = bos.getShort();
                int lpage = bos.getShort();
                int icnt = 0;
                ppos += 4;
                while (icnt < lpage) {
                    short plen;
                    bos.position(ppos + icnt);
                    short pkcode = bos.getShort();
                    if (pkcode == 8) {
                        if (gpkcode8Doff == null) {
                            gpkcode8Doff = new int[550];
                            gpkcode8Size = new int[550];
                        }
                        plen = bos.getShort();
                        gpkcode8Doff[gpcode8Number] = ppos + 4 + icnt;
                        gpkcode8Size[gpcode8Number] = plen - 6;
                        icnt += plen + 4;
                        ++gpcode8Number;
                        continue;
                    }
                    if (pkcode == 1) {
                        if (gpkcode1Doff == null) {
                            gpkcode1Doff = new int[550];
                            gpkcode1Size = new int[550];
                        }
                        plen = bos.getShort();
                        gpkcode1Doff[gpcode1Number] = ppos + 4 + icnt;
                        gpkcode1Size[gpcode1Number] = plen - 4;
                        icnt += plen + 4;
                        ++gpcode1Number;
                        continue;
                    }
                    if (pkcode == 10) {
                        if (gpkcode10Doff == null) {
                            gpkcode10Doff = new int[250];
                            gpkcode10Dlen = new int[250];
                        }
                        plen = bos.getShort();
                        gpkcode10Doff[gpcode10Number] = ppos + 4 + icnt;
                        gpkcode10Dlen[gpcode10Number] = (plen - 2) / 8;
                        icnt += plen + 4;
                        ++gpcode10Number;
                        continue;
                    }
                    plen = bos.getShort();
                    icnt += plen + 4;
                }
                clen = clen + lpage + 4;
            }
            if (gpkcode8Doff != null) {
                this.pcode_128(gpkcode8Doff, gpkcode8Size, 8, hoff, gpcode8Number, "textStruct_code8g", "g", isZ);
            }
            if (gpkcode2Doff != null) {
                this.pcode_128(gpkcode2Doff, gpkcode2Size, 2, hoff, gpcode8Number, "textStruct_code2g", "g", isZ);
            }
            if (gpkcode1Doff != null) {
                this.pcode_128(gpkcode1Doff, gpkcode1Size, 1, hoff, gpcode1Number, "textStruct_code1g", "g", isZ);
            }
            if (gpkcode10Doff != null) {
                this.pcode_10n9(gpkcode10Doff, gpkcode10Dlen, hoff, gpcode10Number, isZ);
            }
        }
        ncfile.finish();
    }

    int pcode_12n13n14(int[] pos, int[] dlen, int hoff, int len, boolean isZ, String structName, int code) {
        int vlen = 0;
        for (int i = 0; i < len; ++i) {
            vlen += dlen[i];
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension sDim = new Dimension("graphicSymbolSize", vlen);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, structName);
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "special graphic symbol for code " + code));
        Variable i0 = new Variable(this.ncfile, null, dist, "x_start");
        i0.setDimensions((String)null);
        i0.setDataType(DataType.FLOAT);
        i0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(i0);
        Variable j0 = new Variable(this.ncfile, null, dist, "y_start");
        j0.setDimensions((String)null);
        j0.setDataType(DataType.FLOAT);
        j0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(j0);
        int[] pos1 = new int[len];
        int[] dlen1 = new int[len];
        System.arraycopy(dlen, 0, dlen1, 0, len);
        System.arraycopy(pos, 0, pos1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, dlen1, code, 0));
        return 1;
    }

    int pcode_25(int[] pos, int hoff, int len, boolean isZ) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension sDim = new Dimension("circleSize", len);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, "circleStruct");
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "Circle Packet"));
        Variable ii0 = new Variable(this.ncfile, null, dist, "x_center");
        ii0.setDimensions((String)null);
        ii0.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii0);
        Variable ii1 = new Variable(this.ncfile, null, dist, "y_center");
        ii1.setDimensions((String)null);
        ii1.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii1);
        Variable jj0 = new Variable(this.ncfile, null, dist, "radius");
        jj0.setDimensions((String)null);
        jj0.setDataType(DataType.SHORT);
        dist.addMemberVariable(jj0);
        int[] pos1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, null, 25, 0));
        return 1;
    }

    int pcode_6n7(int[] pos, int[] dlen, int hoff, int len, boolean isZ, String vname, int code) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        int vlen = 0;
        for (int i = 0; i < len; ++i) {
            vlen += dlen[i];
        }
        Dimension sDim = new Dimension(vname + "Size", vlen);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, vname + "Struct");
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", vname + " Packet"));
        Variable ii0 = new Variable(this.ncfile, null, dist, "x_start");
        ii0.setDimensions((String)null);
        ii0.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii0);
        Variable ii1 = new Variable(this.ncfile, null, dist, "y_start");
        ii1.setDimensions((String)null);
        ii1.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii1);
        Variable jj0 = new Variable(this.ncfile, null, dist, "x_end");
        jj0.setDimensions((String)null);
        jj0.setDataType(DataType.SHORT);
        dist.addMemberVariable(jj0);
        Variable jj1 = new Variable(this.ncfile, null, dist, "y_end");
        jj1.setDimensions((String)null);
        jj1.setDataType(DataType.SHORT);
        dist.addMemberVariable(jj1);
        int[] pos1 = new int[len];
        int[] dlen1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        System.arraycopy(dlen, 0, dlen1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, dlen1, code, 0));
        return 1;
    }

    int pcode_4(int[] pos, int hoff, int len, boolean isZ) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension sDim = new Dimension("windBarbSize", len);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, this.cname);
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "Wind Barb Data"));
        Variable value = new Variable(this.ncfile, null, dist, "value");
        value.setDimensions((String)null);
        value.setDataType(DataType.SHORT);
        value.addAttribute(new Attribute("units", "RMS"));
        dist.addMemberVariable(value);
        Variable i0 = new Variable(this.ncfile, null, dist, "x_start");
        i0.setDimensions((String)null);
        i0.setDataType(DataType.SHORT);
        i0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(i0);
        Variable j0 = new Variable(this.ncfile, null, dist, "y_start");
        j0.setDimensions((String)null);
        j0.setDataType(DataType.SHORT);
        j0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(j0);
        Variable direct = new Variable(this.ncfile, null, dist, "direction");
        direct.setDimensions((String)null);
        direct.setDataType(DataType.SHORT);
        direct.addAttribute(new Attribute("units", "degree"));
        dist.addMemberVariable(direct);
        Variable speed = new Variable(this.ncfile, null, dist, "speed");
        speed.setDimensions((String)null);
        speed.setDataType(DataType.SHORT);
        speed.addAttribute(new Attribute("units", "knots"));
        dist.addMemberVariable(speed);
        int[] pos1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, null, 4, 0));
        return 1;
    }

    int checkMsgHeader(RandomAccessFile raf) throws IOException {
        long actualSize = raf.length();
        int pos = 0;
        raf.seek((long)pos);
        int readLen = (int)actualSize;
        byte[] b = new byte[readLen];
        int rc = raf.read(b);
        if (rc != readLen) {
            log.warn(" error reading nids product header " + raf.getLocation());
        }
        ByteBuffer bos = ByteBuffer.wrap(b);
        return this.read_msghead(bos, 0);
    }

    int pcode_5(int[] pos, int hoff, int len, boolean isZ) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension sDim = new Dimension("windBarbSize", len);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, "vectorArrow");
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "Vector Arrow Data"));
        Variable i0 = new Variable(this.ncfile, null, dist, "x_start");
        i0.setDimensions((String)null);
        i0.setDataType(DataType.SHORT);
        i0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(i0);
        Variable j0 = new Variable(this.ncfile, null, dist, "y_start");
        j0.setDimensions((String)null);
        j0.setDataType(DataType.SHORT);
        j0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(j0);
        Variable direct = new Variable(this.ncfile, null, dist, "direction");
        direct.setDimensions((String)null);
        direct.setDataType(DataType.SHORT);
        direct.addAttribute(new Attribute("units", "degree"));
        dist.addMemberVariable(direct);
        Variable speed = new Variable(this.ncfile, null, dist, "arrowLength");
        speed.setDimensions((String)null);
        speed.setDataType(DataType.SHORT);
        speed.addAttribute(new Attribute("units", "pixels"));
        dist.addMemberVariable(speed);
        Variable speed1 = new Variable(this.ncfile, null, dist, "arrowHeadLength");
        speed1.setDimensions((String)null);
        speed1.setDataType(DataType.SHORT);
        speed1.addAttribute(new Attribute("units", "pixels"));
        dist.addMemberVariable(speed1);
        int[] pos1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, null, 4, 0));
        return 1;
    }

    int pcode_128(int[] pos, int[] size, int code, int hoff, int len, String structName, String abbre, boolean isZ) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension sDim = new Dimension("textStringSize" + abbre + code, len);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, structName + abbre);
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "text and special symbol for code " + code));
        if (code == 8) {
            Variable strVal = new Variable(this.ncfile, null, dist, "strValue");
            strVal.setDimensions((String)null);
            strVal.setDataType(DataType.SHORT);
            strVal.addAttribute(new Attribute("units", ""));
            dist.addMemberVariable(strVal);
        }
        Variable i0 = new Variable(this.ncfile, null, dist, "x_start");
        i0.setDimensions((String)null);
        i0.setDataType(DataType.SHORT);
        i0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(i0);
        Variable j0 = new Variable(this.ncfile, null, dist, "y_start");
        j0.setDimensions((String)null);
        j0.setDataType(DataType.SHORT);
        j0.addAttribute(new Attribute("units", "KM"));
        dist.addMemberVariable(j0);
        Variable tstr = new Variable(this.ncfile, null, dist, "textString");
        tstr.setDimensions((String)null);
        tstr.setDataType(DataType.STRING);
        tstr.addAttribute(new Attribute("units", ""));
        dist.addMemberVariable(tstr);
        int[] pos1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, size, code, 0));
        return 1;
    }

    int pcode_10n9(int[] pos, int[] dlen, int hoff, int len, boolean isZ) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        int vlen = 0;
        for (int i = 0; i < len; ++i) {
            vlen += dlen[i];
        }
        Dimension sDim = new Dimension("unlinkedVectorSize", vlen);
        this.ncfile.addDimension(null, sDim);
        dims.add(sDim);
        Structure dist = new Structure(this.ncfile, null, null, "unlinkedVectorStruct");
        dist.setDimensions(dims);
        this.ncfile.addVariable(null, (Variable)dist);
        dist.addAttribute(new Attribute("long_name", "Unlinked Vector Packet"));
        Variable v = new Variable(this.ncfile, null, null, "iValue");
        v.setDataType(DataType.SHORT);
        v.setDimensions((String)null);
        dist.addMemberVariable(v);
        Variable ii0 = new Variable(this.ncfile, null, dist, "x_start");
        ii0.setDimensions((String)null);
        ii0.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii0);
        Variable ii1 = new Variable(this.ncfile, null, dist, "y_start");
        ii1.setDimensions((String)null);
        ii1.setDataType(DataType.SHORT);
        dist.addMemberVariable(ii1);
        Variable jj0 = new Variable(this.ncfile, null, dist, "x_end");
        jj0.setDimensions((String)null);
        jj0.setDataType(DataType.SHORT);
        dist.addMemberVariable(jj0);
        Variable jj1 = new Variable(this.ncfile, null, dist, "y_end");
        jj1.setDimensions((String)null);
        jj1.setDataType(DataType.SHORT);
        dist.addMemberVariable(jj1);
        int[] pos1 = new int[len];
        int[] dlen1 = new int[len];
        System.arraycopy(pos, 0, pos1, 0, len);
        System.arraycopy(dlen, 0, dlen1, 0, len);
        dist.setSPobject((Object)new Vinfo(0, 0, 0, 0, hoff, 0L, this.isR, isZ, pos1, dlen1, 10, 0));
        return 1;
    }

    int pcode_DPA(ByteBuffer bos, int pos, int hoff, int hedsiz, boolean isZ, int slayer, int code) {
        byte[] b2 = new byte[2];
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        bos.position(pos);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        short numBox = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        int numRow = this.getInt(b2, 2);
        int soff = 8;
        this.numY0 = 0;
        this.numX0 = 0;
        this.numX = numBox;
        this.numY = numRow;
        if (slayer == 0) {
            Dimension jDim = new Dimension("y", this.numY);
            Dimension iDim = new Dimension("x", this.numX);
            this.ncfile.addDimension(null, iDim);
            this.ncfile.addDimension(null, jDim);
            dims.add(jDim);
            dims.add(iDim);
            Variable v = new Variable(this.ncfile, null, null, this.cname + "_" + slayer);
            v.setDataType(DataType.SHORT);
            v.setDimensions(dims);
            this.ncfile.addVariable(null, v);
            v.addAttribute(new Attribute("long_name", this.ctitle + " at Symbology Layer " + slayer));
            v.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, this.numY0, hoff, hedsiz, this.isR, isZ, null, null, code, 0));
            v.addAttribute(new Attribute("units", this.cunit));
            v.addAttribute(new Attribute("missing_value", (Number)255));
        }
        for (int row = 0; row < numRow; ++row) {
            short runLen = bos.getShort();
            byte[] rdata = new byte[runLen];
            bos.get(rdata, 0, runLen);
            if (runLen < 2) {
                return soff;
            }
            soff += runLen + 2;
        }
        if (slayer == 0) {
            double ddx = Nidsheader.code_reslookup(this.pcode);
            this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
            Variable xaxis = new Variable(this.ncfile, null, null, "x");
            xaxis.setDataType(DataType.DOUBLE);
            xaxis.setDimensions("x");
            xaxis.addAttribute(new Attribute("long_name", "projection x coordinate"));
            xaxis.addAttribute(new Attribute("units", "km"));
            xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
            double[] data1 = new double[this.numX];
            for (int i = 0; i < this.numX; ++i) {
                data1[i] = (double)this.numX0 + (double)i * ddx;
            }
            Array dataA = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.numX}, (Object)data1);
            xaxis.setCachedData(dataA, false);
            this.ncfile.addVariable(null, xaxis);
            Variable yaxis = new Variable(this.ncfile, null, null, "y");
            yaxis.setDataType(DataType.DOUBLE);
            yaxis.setDimensions("y");
            yaxis.addAttribute(new Attribute("long_name", "projection y coordinate"));
            yaxis.addAttribute(new Attribute("units", "km"));
            yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
            data1 = new double[this.numY];
            for (int i = 0; i < this.numY; ++i) {
                data1[i] = (double)this.numY0 + (double)i * ddx;
            }
            dataA = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.numY}, (Object)data1);
            yaxis.setCachedData(dataA, false);
            this.ncfile.addVariable(null, yaxis);
            FlatEarth projection = new FlatEarth(this.lat_min, this.lon_max);
            Variable ct = new Variable(this.ncfile, null, null, projection.getClassName());
            ct.setDataType(DataType.CHAR);
            ct.setDimensions("");
            List params = projection.getProjectionParameters();
            for (Object param : params) {
                Parameter p = (Parameter)param;
                ct.addAttribute(new Attribute(p));
            }
            ct.addAttribute(new Attribute("_CoordinateTransformType", "Projection"));
            ct.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            dataA = Array.factory((DataType)DataType.CHAR, (int[])new int[0]);
            dataA.setChar(dataA.getIndex(), ' ');
            ct.setCachedData(dataA, false);
            this.ncfile.addVariable(null, ct);
        }
        return soff;
    }

    int pcode_raster(ByteBuffer bos, short pkcode, int hoff, int hedsiz, boolean isZ, byte[] data) {
        byte[] b2 = new byte[2];
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        int iscale = 1;
        int ival = this.convertShort2unsignedInt(this.threshold[0]);
        if ((ival & 0x2000) != 0) {
            iscale = 20;
        }
        if ((ival & 0x1000) != 0) {
            iscale = 10;
        }
        short[] rasp_code = new short[3];
        rasp_code[0] = pkcode;
        bos.get(b2, 0, 2);
        rasp_code[1] = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        rasp_code[2] = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        short rasp_xscale = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        short num_rows = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        int soff = 20;
        hedsiz += soff;
        int nlevel = Nidsheader.code_levelslookup(this.pcode);
        double ddx = Nidsheader.code_reslookup(this.pcode);
        int[] levels = this.getLevels(nlevel, this.threshold);
        this.numY0 = 0;
        this.numX0 = 0;
        this.numX = num_rows;
        this.numY = num_rows;
        Dimension jDim = new Dimension("y", this.numY, true, false, false);
        Dimension iDim = new Dimension("x", this.numX, true, false, false);
        dims.add(jDim);
        dims.add(iDim);
        this.ncfile.addDimension(null, iDim);
        this.ncfile.addDimension(null, jDim);
        if (this.cname.startsWith("Precip")) {
            this.ncfile.addAttribute(null, new Attribute("isRadial", (Number)3));
            ddx *= (double)rasp_xscale;
        }
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        String coordinates = "x y time latitude longitude altitude";
        Variable v = new Variable(this.ncfile, null, null, this.cname + "_RAW");
        v.setDataType(DataType.BYTE);
        v.setDimensions(dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("long_name", this.ctitle));
        v.addAttribute(new Attribute("units", this.cunit));
        v.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, this.numY0, hoff, hedsiz, this.isR, isZ, null, null, pkcode, 0));
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        if (this.cname.startsWith("VertLiquid")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("EchoTop")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("BaseReflectivityComp") || this.cname.startsWith("LayerCompReflect")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("Precip")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        }
        Variable xaxis = new Variable(this.ncfile, null, null, "x");
        xaxis.setDataType(DataType.DOUBLE);
        xaxis.setDimensions("x");
        xaxis.addAttribute(new Attribute("long_name", "projection x coordinate"));
        xaxis.addAttribute(new Attribute("units", "km"));
        xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        double[] data1 = new double[this.numX];
        for (int i = 0; i < this.numX; ++i) {
            data1[i] = (double)this.numX0 + (double)i * ddx;
        }
        Array dataA = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.numX}, (Object)data1);
        xaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, xaxis);
        Variable yaxis = new Variable(this.ncfile, null, null, "y");
        yaxis.setDataType(DataType.DOUBLE);
        yaxis.setDimensions("y");
        yaxis.addAttribute(new Attribute("long_name", "projection y coordinate"));
        yaxis.addAttribute(new Attribute("units", "km"));
        yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        data1 = new double[this.numY];
        for (int i = 0; i < this.numY; ++i) {
            data1[i] = (double)this.numY0 + (double)i * ddx;
        }
        dataA = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.numY}, (Object)data1);
        yaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, yaxis);
        FlatEarth projection = new FlatEarth(this.lat_min, this.lon_max);
        Variable ct = new Variable(this.ncfile, null, null, projection.getClassName());
        ct.setDataType(DataType.CHAR);
        ct.setDimensions("");
        List params = projection.getProjectionParameters();
        for (Object param : params) {
            Parameter p = (Parameter)param;
            ct.addAttribute(new Attribute(p));
        }
        ct.addAttribute(new Attribute("_CoordinateTransformType", "Projection"));
        ct.addAttribute(new Attribute("_CoordinateAxes", "x y"));
        dataA = Array.factory((DataType)DataType.CHAR, (int[])new int[0]);
        dataA.setChar(dataA.getIndex(), ' ');
        ct.setCachedData(dataA, false);
        this.ncfile.addVariable(null, ct);
        return soff;
    }

    int pcode_radial(ByteBuffer bos, int hoff, int hedsiz, boolean isZ, byte[] data, short[] threshold) {
        int[] levels;
        byte[] b2 = new byte[2];
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        int iscale = 1;
        int ival = this.convertShort2unsignedInt(threshold[0]);
        if ((ival & 0x2000) != 0) {
            iscale = 20;
        }
        if ((ival & 0x1000) != 0) {
            iscale = 10;
        }
        bos.get(b2, 0, 2);
        short first_bin = (short)this.getInt(b2, 2);
        bos.get(b2, 0, 2);
        short num_bin = (short)this.getUInt(b2, 2);
        if (this.pcode == 94 || this.pcode == 99) {
            num_bin = this.addBinSize(num_bin);
        }
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        short radp_scale = (short)this.getInt(b2, 2);
        if (this.pcode == 134 || this.pcode == 135) {
            radp_scale = (short)(radp_scale * 1000);
        }
        bos.get(b2, 0, 2);
        short num_radials = (short)this.getInt(b2, 2);
        int soff = 12;
        hedsiz += soff;
        this.numY0 = 0;
        this.numY = num_radials;
        this.numX0 = first_bin;
        this.numX = num_bin;
        int nlevel = Nidsheader.code_levelslookup(this.pcode);
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.RADIAL.toString()));
        Dimension radialDim = new Dimension("azimuth", (int)num_radials);
        this.ncfile.addDimension(null, radialDim);
        Dimension binDim = new Dimension("gate", (int)num_bin);
        this.ncfile.addDimension(null, binDim);
        dims.add(radialDim);
        dims.add(binDim);
        ArrayList<Dimension> dims1 = new ArrayList<Dimension>();
        ArrayList<Dimension> dims2 = new ArrayList<Dimension>();
        dims1.add(radialDim);
        dims2.add(binDim);
        this.isR = true;
        String vName = "elevation";
        String lName = "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular";
        Attribute att = new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, this.p3);
        vName = "azimuth";
        lName = "azimuth angle in degrees: 0 = true north, 90 = east";
        att = new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "gate";
        lName = "Radial distance to the start of gate";
        att = new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString());
        this.addParameter(vName, lName, this.ncfile, dims2, att, DataType.FLOAT, "meters", hoff, hedsiz, isZ, radp_scale);
        vName = "latitude";
        lName = "Latitude of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Lat.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "longitude";
        lName = "Longitude of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Lon.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "altitude";
        lName = "Altitude in meters (asl) of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Height.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "meters", hoff, hedsiz, isZ, 0);
        vName = "rays_time";
        lName = "rays time";
        att = new Attribute("_CoordinateAxisType", AxisType.Time.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.DOUBLE, "milliseconds since 1970-01-01 00:00 UTC", hoff, hedsiz, isZ, 0);
        if (this.pcode == 182 || this.pcode == 99) {
            levels = this.getTDWRLevels(nlevel, threshold);
            iscale = 10;
        } else if (this.pcode == 186 || this.pcode == 94) {
            threshold[0] = -320;
            threshold[1] = 5;
            threshold[2] = 254;
            levels = this.getTDWRLevels(nlevel, threshold);
            iscale = 10;
        } else if (this.pcode == 32) {
            levels = this.getTDWRLevels1(nlevel, threshold);
            iscale = 10;
        } else if (this.pcode == 138) {
            levels = this.getTDWRLevels1(nlevel, threshold);
            iscale = 100;
        } else if (this.pcode == 134 || this.pcode == 135) {
            levels = this.getTDWRLevels2(nlevel, threshold);
            iscale = 1;
        } else if (this.pcode == 159 || this.pcode == 161 || this.pcode == 163 || this.pcode == 170 || this.pcode == 172 || this.pcode == 173 || this.pcode == 174 || this.pcode == 175 || this.pcode == 165 || this.pcode == 177) {
            levels = this.getDualpolLevels(threshold);
            iscale = 100;
        } else {
            levels = this.getLevels(nlevel, threshold);
        }
        Variable v = new Variable(this.ncfile, null, null, this.cname + "_RAW");
        v.setDataType(DataType.UBYTE);
        v.setDimensions(dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", this.cunit));
        String coordinates = "elevation azimuth gate rays_time latitude longitude altitude";
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        v.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, this.numY0, hoff, hedsiz, this.isR, isZ, null, levels, 0, nlevel));
        if (this.cname.startsWith("CorrelationCoefficient") || this.cname.startsWith("HydrometeorClassification") || this.cname.startsWith("DifferentialReflectivity") || this.cname.startsWith("DifferentialPhase") || this.cname.startsWith("HypridHydrometeorClassification")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("OneHourAccumulation") || this.cname.startsWith("DigitalAccumulationArray") || this.cname.startsWith("StormTotalAccumulation") || this.cname.startsWith("DigitalStormTotalAccumulation") || this.cname.startsWith("Accumulation3Hour") || this.cname.startsWith("Accumulation24Hour") || this.cname.startsWith("Digital1HourDifferenceAccumulation") || this.cname.startsWith("DigitalInstantaneousPrecipitationRate") || this.cname.startsWith("DigitalTotalDifferenceAccumulation")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("BaseReflectivity") || this.cname.endsWith("Reflectivity") || this.cname.startsWith("SpectrumWidth")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("RadialVelocity") || this.cname.startsWith("StormMeanVelocity") || this.cname.startsWith("BaseVelocity")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        } else if (this.cname.startsWith("Precip") || this.cname.endsWith("Precip") || this.cname.startsWith("EnhancedEchoTop") || this.cname.startsWith("DigitalIntegLiquid")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        }
        return soff;
    }

    private List parseComponents(ByteBuffer datainput) {
        ArrayList arraylist = null;
        int i = datainput.getInt();
        if (i != 0) {
            i = datainput.getInt();
        }
        for (int j = 0; j < i; ++j) {
            datainput.getInt();
            int type = datainput.getInt();
            arraylist = this.parseData(datainput);
        }
        return arraylist;
    }

    private ArrayList parseData(ByteBuffer datainput) {
        ArrayList<Number> arraylist = new ArrayList<Number>();
        Nidsheader.readInString(datainput);
        datainput.getFloat();
        float rangeToFirstBin = datainput.getFloat();
        datainput.getInt();
        datainput.getInt();
        int numRadials = datainput.getInt();
        int dataOffset = datainput.position();
        datainput.getFloat();
        datainput.getFloat();
        datainput.getFloat();
        int numBins = datainput.getInt();
        arraylist.add(numBins);
        arraylist.add(numRadials);
        arraylist.add(Float.valueOf(rangeToFirstBin));
        arraylist.add(dataOffset);
        return arraylist;
    }

    private List parseParameters(ByteBuffer datainput) {
        ArrayList<Object> arraylist = new ArrayList<Object>();
        int i = datainput.getInt();
        if (i > 0) {
            i = datainput.getInt();
        }
        for (int j = 0; j < i; ++j) {
            arraylist.add(Nidsheader.readInString(datainput));
            HashMap hm = this.addAttributePairs(Nidsheader.readInString(datainput));
            arraylist.add(hm);
        }
        return arraylist;
    }

    private HashMap addAttributePairs(String s) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = PARAM_PATTERN.matcher((CharSequence)s);
        while (matcher.find()) {
            attributes.put(matcher.group(1).trim(), matcher.group(2).trim());
        }
        return attributes;
    }

    static String readInString(ByteBuffer datainput) {
        StringBuilder stringbuffer = new StringBuilder();
        int i = datainput.getInt();
        for (int j = 0; j < i; ++j) {
            char c = (char)(datainput.get() & 0xFF);
            stringbuffer.append(c);
        }
        int k = i % 4;
        if (k != 0) {
            k = 4 - k;
        }
        for (int l = 0; l < k; ++l) {
            datainput.get();
        }
        return stringbuffer.toString();
    }

    private int pcode_generic(ByteBuffer bos, int hoff, int hedsiz, boolean isZ, byte[] data, short[] threshold) throws IOException {
        int[] levels;
        byte[] b2 = new byte[2];
        int soff = 0;
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        int iscale = 1;
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        bos.get(b2, 0, 2);
        Nidsheader.readInString(bos);
        Nidsheader.readInString(bos);
        bos.getInt();
        bos.getInt();
        bos.getInt();
        Nidsheader.readInString(bos);
        bos.getFloat();
        bos.getFloat();
        bos.getFloat();
        bos.getInt();
        bos.getInt();
        float eleAngle = bos.getFloat();
        this.p3 = (short)eleAngle;
        bos.getInt();
        bos.getInt();
        bos.getInt();
        bos.getInt();
        bos.getDouble();
        this.parseParameters(bos);
        List cc = this.parseComponents(bos);
        if (cc == null) {
            throw new IOException("Error reading components for radial data");
        }
        int num_radials = (Integer)cc.get(1);
        int num_bin = (Integer)cc.get(0);
        float rangeToFirstBin = ((Float)cc.get(2)).floatValue();
        int dataOffset = (Integer)cc.get(3);
        this.numY0 = 0;
        this.numY = num_radials;
        this.numX0 = (int)rangeToFirstBin;
        this.numX = num_bin;
        int nlevel = Nidsheader.code_levelslookup(this.pcode);
        int radp_scale = 1000;
        hedsiz = dataOffset;
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.RADIAL.toString()));
        Dimension radialDim = new Dimension("azimuth", num_radials);
        this.ncfile.addDimension(null, radialDim);
        Dimension binDim = new Dimension("gate", num_bin);
        this.ncfile.addDimension(null, binDim);
        dims.add(radialDim);
        dims.add(binDim);
        ArrayList<Dimension> dims1 = new ArrayList<Dimension>();
        ArrayList<Dimension> dims2 = new ArrayList<Dimension>();
        dims1.add(radialDim);
        dims2.add(binDim);
        this.isR = true;
        String vName = "elevation";
        String lName = "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular";
        Attribute att = new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, this.p3);
        vName = "azimuth";
        lName = "azimuth angle in degrees: 0 = true north, 90 = east";
        att = new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "gate";
        lName = "Radial distance to the start of gate";
        att = new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString());
        this.addParameter(vName, lName, this.ncfile, dims2, att, DataType.FLOAT, "meters", hoff, hedsiz, isZ, radp_scale);
        vName = "latitude";
        lName = "Latitude of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Lat.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "longitude";
        lName = "Longitude of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Lon.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "degrees", hoff, hedsiz, isZ, 0);
        vName = "altitude";
        lName = "Altitude in meters (asl) of the instrument";
        att = new Attribute("_CoordinateAxisType", AxisType.Height.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.FLOAT, "meters", hoff, hedsiz, isZ, 0);
        vName = "rays_time";
        lName = "rays time";
        att = new Attribute("_CoordinateAxisType", AxisType.Time.toString());
        this.addParameter(vName, lName, this.ncfile, dims1, att, DataType.DOUBLE, "milliseconds since 1970-01-01 00:00 UTC", hoff, hedsiz, isZ, 0);
        if (this.pcode == 176) {
            levels = this.getDualpolLevels(threshold);
            iscale = 1;
        } else {
            levels = this.getLevels(nlevel, threshold);
        }
        Variable v = new Variable(this.ncfile, null, null, this.cname + "_RAW");
        v.setDataType(DataType.USHORT);
        v.setDimensions(dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", this.cunit));
        String coordinates = "elevation azimuth gate rays_time latitude longitude altitude";
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        v.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, this.numY0, hoff, hedsiz, this.isR, isZ, null, levels, 0, nlevel));
        if (this.cname.startsWith("DigitalInstantaneousPrecipitationRate")) {
            this.addVariable(this.cname, this.ctitle, this.ncfile, dims, coordinates, DataType.FLOAT, this.cunit, hoff, hedsiz, isZ, nlevel, levels, iscale);
        }
        return soff;
    }

    private short addBinSize(short num_bin) {
        if (num_bin % 2 == 0) {
            return num_bin;
        }
        return (short)(num_bin + 1);
    }

    private int[] getLevels(int nlevel, short[] th) {
        int[] levels = new int[nlevel];
        for (int i = 0; i < nlevel; ++i) {
            int ival = this.convertShort2unsignedInt(th[i]);
            if ((ival & 0x8000) == 0) {
                int isign = -1;
                if ((ival & 0x100) == 0) {
                    isign = 1;
                }
                levels[i] = isign * (ival & 0xFF);
                continue;
            }
            levels[i] = -9999 + (ival & 0xFF);
        }
        return levels;
    }

    private int[] getTDWRLevels(int nlevel, short[] th) {
        int[] levels = new int[nlevel];
        short inc = th[1];
        levels[0] = -9866;
        levels[1] = -9866;
        for (int i = 2; i < nlevel; ++i) {
            levels[i] = th[0] + (i - 2) * inc;
        }
        return levels;
    }

    private int[] getTDWRLevels1(int nlevel, short[] th) {
        int[] levels = new int[nlevel];
        short inc = th[1];
        for (int i = 0; i < nlevel; ++i) {
            levels[i] = th[0] + i * inc;
        }
        return levels;
    }

    private int[] getDualpolLevels(short[] th) {
        int inc = th.length;
        int[] levels = new int[inc];
        for (int i = 0; i < inc; ++i) {
            levels[i] = th[i];
        }
        return levels;
    }

    private int[] getTDWRLevels2(int nlevel, short[] th) {
        int inc = th.length;
        int[] levels = new int[inc];
        for (int i = 0; i < inc; ++i) {
            levels[i] = th[i];
        }
        return levels;
    }

    private void addVariable(String pName, String longName, NetcdfFile nc, ArrayList dims, String coordinates, DataType dtype, String ut, long hoff, long hedsiz, boolean isZ, int nlevel, int[] levels, int iscale) {
        Variable v = new Variable(nc, null, null, pName);
        v.setDataType(dtype);
        v.setDimensions((List)dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("long_name", longName));
        v.addAttribute(new Attribute("units", ut));
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        v.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, this.numY0, hoff, hedsiz, this.isR, isZ, null, levels, iscale, nlevel));
    }

    private void addParameter(String pName, String longName, NetcdfFile nc, ArrayList dims, Attribute att, DataType dtype, String ut, long hoff, long doff, boolean isZ, int y0) {
        String vName = pName;
        Variable vVar = new Variable(nc, null, null, vName);
        vVar.setDataType(dtype);
        if (dims != null) {
            vVar.setDimensions((List)dims);
        } else {
            vVar.setDimensions("");
        }
        if (att != null) {
            vVar.addAttribute(att);
        }
        vVar.addAttribute(new Attribute("units", ut));
        vVar.addAttribute(new Attribute("long_name", longName));
        nc.addVariable(null, vVar);
        vVar.setSPobject((Object)new Vinfo(this.numX, this.numX0, this.numY, y0, hoff, doff, this.isR, isZ, null, null, 0, 0));
    }

    String StnIdFromLatLon(float lat, float lon) {
        return "ID";
    }

    private int getProductLevel(int prod_elevation) {
        int level = 0;
        if (prod_elevation == 5) {
            level = 0;
        } else if (prod_elevation == 9) {
            level = 1;
        } else if (prod_elevation == 13 || prod_elevation == 15) {
            level = 2;
        } else if (prod_elevation == 18) {
            level = 3;
        } else if (prod_elevation == 24) {
            level = 4;
        } else if (prod_elevation == 31) {
            level = 6;
        }
        return level;
    }

    private void setProductInfo(int prod_type, Pinfo pinfo) {
        String[] cmode = new String[]{"Maintenance", "Clear Air", "Precip Mode"};
        short prod_max = pinfo.p4;
        short prod_min = 0;
        int prod_elevation = 0;
        int radial = 0;
        String summary = null;
        double t1 = 2.0651806579183893;
        double t2 = 230.0 / (111.26 * Math.cos(Math.toRadians(this.latitude)));
        this.lat_min = this.latitude - t1;
        this.lat_max = this.latitude + t1;
        this.lon_min = this.longitude + t2;
        this.lon_max = this.longitude - t2;
        Date startDate = Nidsheader.getDate(this.volumeScanDate, this.volumeScanTime * 1000);
        Date endDate = Nidsheader.getDate(this.volumeScanDate, this.volumeScanTime * 1000);
        if (prod_type == 15) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Base Specturm Width " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(this.pcode, prod_elevation / 10);
            this.ctitle = "BREF: Base Spectrum Width";
            this.cunit = "Knots";
            this.cname = "SpectrumWidth";
            summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1) + " and range 124 nm";
            if (this.pcode == 28) {
                this.lat_min = this.latitude - (t1 *= 0.25);
                this.lat_max = this.latitude + t1;
                this.lon_min = this.longitude + (t2 *= 0.25);
                this.lon_max = this.longitude - t2;
                summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1) + " and range 32 nm";
            }
        } else if (prod_type == 30) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Differential Reflectivity " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(15, pLevel);
            this.ctitle = "Dualpol: Digital Differential Reflectivity";
            this.cunit = "dBz";
            this.cname = "DifferentialReflectivity";
            summary = this.ctilt + " is a radial image of dual pol differential reflectivity field and its range 162 nm";
        } else if (prod_type == 31) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Correlation Coefficient " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(16, pLevel);
            this.ctitle = "Dualpol: Digital Correlation Coefficient";
            this.cunit = " ";
            this.cname = "CorrelationCoefficient";
            summary = this.ctilt + " is a radial image of dual pol Correlation Coefficient field and its range 162 nm";
        } else if (prod_type == 32) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Differential Phase " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(17, pLevel);
            this.ctitle = "Dualpol: Digital Differential Phase";
            this.cunit = "Degree/km";
            this.cname = "DifferentialPhase";
            summary = this.ctilt + " is a radial image of dual pol Differential Phase field and its range 162 nm";
        } else if (prod_type == 33) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Hydrometeor Classification " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(18, pLevel);
            this.ctitle = "Dualpol: Hydrometeor Classification";
            this.cunit = " ";
            this.cname = "HydrometeorClassification";
            summary = this.ctilt + " is a radial image of dual pol Hydrometeor Classification field and its range 162 nm";
        } else if (prod_type == 45) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Hyprid Hydrometeor Classification " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(18, pLevel);
            this.ctitle = "Dualpol: Hyprid Hydrometeor Classification";
            this.cunit = " ";
            this.cname = "HypridHydrometeorClassification";
            summary = this.ctilt + " is a radial image of dual pol Hyprid Hydrometeor Classification field and its range 162 nm";
        } else if (prod_type == 36) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "One Hour Accumulation " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = "OHA";
            this.ctitle = "Dualpol: One Hour Accumulation";
            this.cunit = "IN";
            this.cname = "OneHourAccumulation";
            summary = this.ctilt + " is a radial image of dual pol One Hour Accumulation field and its range 124 nm";
        } else if (prod_type == 37) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Accumulation Array " + cmode[pinfo.opmode];
            this.ctilt = "DAA";
            this.ctitle = "Dualpol: Digital Accumulation Array";
            this.cunit = "IN";
            this.cname = "DigitalAccumulationArray";
            summary = this.ctilt + " is a radial image of dual pol Digital Accumulation Array field and its range 124 nm";
        } else if (prod_type == 38) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Storm Total Accumulation " + cmode[pinfo.opmode];
            this.ctilt = "PTA";
            this.ctitle = "Dualpol: Storm Total Accumulation";
            this.cunit = "IN";
            this.cname = "StormTotalAccumulation";
            summary = this.ctilt + " is a radial image of dual pol Storm Total Accumulation field and its range 124 nm";
        } else if (prod_type == 39) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Storm Total Accumulation  " + cmode[pinfo.opmode];
            this.ctilt = "DTA";
            this.ctitle = "Dualpol: Digital Storm Total Accumulation";
            this.cunit = "IN";
            this.cname = "DigitalStormTotalAccumulation";
            summary = this.ctilt + " is a radial image of dual pol Digital StormTotal Accumulation field and its range 124 nm";
        } else if (prod_type == 40) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Hyprid Hydrometeor Classification " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(18, pLevel);
            this.ctitle = "Dualpol: 3-hour Accumulation";
            this.cunit = "IN";
            this.cname = "Accumulation3Hour";
            summary = this.ctilt + " is a radial image of dual pol 3-hour Accumulation field and its range 124 nm";
        } else if (prod_type == 42) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital One Hour Difference Accumulation " + cmode[pinfo.opmode];
            this.ctilt = "DOD";
            this.ctitle = "Dualpol: Digital One Hour Difference Accumulation";
            this.cunit = "IN";
            this.cname = "Digital1HourDifferenceAccumulation";
            summary = this.ctilt + " is a radial image of dual pol Digital One Hour Difference Accumulation field and its range 124 nm";
        } else if (prod_type == 43) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Total Difference Accumulation " + cmode[pinfo.opmode];
            this.ctilt = "DSD";
            this.ctitle = "Dualpol: Digital Total Difference Accumulation";
            this.cunit = "IN";
            this.cname = "DigitalTotalDifferenceAccumulation";
            summary = this.ctilt + " is a radial image of dual pol Digital Total Difference Accumulation field and its range 124 nm";
        } else if (prod_type == 44) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Instantaneous Precipitation Rate " + cmode[pinfo.opmode];
            this.ctilt = "DPR";
            this.ctitle = "Dualpol: Digital Instantaneous Precipitation Rate";
            this.cunit = "IN/Hour";
            this.cname = "DigitalInstantaneousPrecipitationRate";
            summary = this.ctilt + " is a radial image of dual pol Digital Instantaneous Precipitation Rate field and its range 124 nm";
        } else if (prod_type == 21) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Base Reflectivity DR " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(94, pLevel);
            this.ctitle = "HighResolution: Base Reflectivity";
            this.cunit = "dBz";
            this.cname = "BaseReflectivityDR";
            summary = this.ctilt + " is a radial image of base reflectivity field and its range 248 nm";
        } else if (prod_type == 22) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Base Velocity DR " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            int pLevel = this.getProductLevel(prod_elevation);
            this.ctilt = Nidsheader.pname_lookup(99, pLevel);
            this.ctitle = "HighResolution: Base Velocity";
            this.cunit = "m/s";
            this.cname = "BaseVelocityDV";
            summary = this.ctilt + " is a radial image of base velocity field and its range 124 nm";
        } else if (prod_type == 24) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Hybrid Reflect " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(134, prod_elevation / 10);
            this.ctitle = "Digital: Vertical Integ Liquid";
            this.cunit = "kg/m^2";
            this.cname = "DigitalIntegLiquid";
            summary = this.ctilt + " is a radial image high resolution vertical integral liquid and range 248 nm";
        } else if (prod_type == 16) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Digital Hybrid Reflect " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(19, prod_elevation / 10);
            this.ctitle = "DigitalHybrid: Reflectivity";
            this.cunit = "dBz";
            this.cname = "DigitalHybridReflectivity";
            summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1) + " and range 124 nm";
        } else if (prod_type == 1 || prod_type == 18) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Base Reflct " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            if (prod_type == 18) {
                this.ctilt = "R" + prod_elevation / 10;
                summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1);
            } else {
                this.ctilt = Nidsheader.pname_lookup(19, prod_elevation / 10);
                summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1) + " and range 124 nm";
            }
            this.ctitle = "BREF: Base Reflectivity";
            this.cunit = "dBz";
            this.cname = "BaseReflectivity";
        } else if (prod_type == 12) {
            radial = 1;
            prod_elevation = pinfo.p3;
            this.cmemo = "Base Reflct 248 " + prod_elevation / 10 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(20, prod_elevation / 10);
            this.ctitle = "BREF: 248 nm Base Reflectivity";
            this.cunit = "dBz";
            this.cname = "BaseReflectivity248";
            summary = this.ctilt + " is a radial image of base reflectivity at tilt " + (prod_elevation / 10 + 1) + " and range 248 nm";
            t1 = 4.130361315836779;
            t2 = 460.0 / (111.26 * Math.cos(Math.toRadians(this.latitude)));
            this.lat_min = this.latitude - t1;
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + t2;
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 3) {
            radial = 3;
            prod_elevation = -1;
            this.ctilt = Nidsheader.pname_lookup(pinfo.pcode, this.elevationNumber);
            if (pinfo.pcode == 36 || pinfo.pcode == 38) {
                this.lat_min = this.latitude - (t1 *= 2.0);
                this.lat_max = this.latitude + t1;
                this.lon_min = this.longitude + (t2 *= 2.0);
                this.lon_max = this.longitude - t2;
            }
            summary = this.ctilt + "is a raster image of composite reflectivity";
            this.cmemo = "Composite Reflectivity at " + cmode[pinfo.opmode];
            this.ctitle = "CREF Composite Reflectivity" + this.ctilt;
            this.cunit = "dBz";
            this.cname = "BaseReflectivityComp";
        } else if (prod_type == 4 || prod_type == 5) {
            radial = 3;
            prod_elevation = pinfo.p5;
            short prod_top = pinfo.p6;
            this.ctilt = Nidsheader.pname_lookup(this.pcode, 0);
            summary = this.ctilt + " is a raster image of composite reflectivity at range 124 nm";
            this.cmemo = "Layer Reflct " + prod_elevation + " - " + prod_top + cmode[pinfo.opmode];
            this.lat_min = this.latitude - (t1 *= 4.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 4.0);
            this.lon_max = this.longitude - t2;
            this.ctitle = "LREF: Layer Composite Reflectivity";
            this.cunit = "dBz";
            this.cname = "LayerCompReflect";
        } else if (prod_type == 23) {
            radial = 1;
            prod_elevation = -1;
            summary = "EET is a radial image of echo tops at range 186 nm";
            this.cmemo = "Enhanced Echo Tops [K FT] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(135, this.elevationNumber);
            this.ctitle = "TOPS: Enhanced Echo Tops";
            this.cunit = "K FT";
            this.cname = "EnhancedEchoTop";
            this.lat_min = this.latitude - (t1 *= 4.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 4.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 6) {
            radial = 3;
            prod_elevation = -1;
            summary = "NET is a raster image of echo tops at range 124 nm";
            this.cmemo = "Echo Tops [K FT] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(41, this.elevationNumber);
            this.ctitle = "TOPS: Echo Tops";
            this.cunit = "K FT";
            this.cname = "EchoTop";
            this.lat_min = this.latitude - (t1 *= 4.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 4.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 8) {
            radial = 1;
            prod_elevation = -1;
            prod_max = (short)(prod_max / 10);
            endDate = Nidsheader.getDate(pinfo.p7, pinfo.p8 * 60 * 1000);
            summary = "N1P is a raster image of 1 hour surface rainfall accumulation at range 124 nm";
            this.cmemo = "1-hr Rainfall [IN] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(78, this.elevationNumber);
            this.ctitle = "PRE1: Surface 1-hour Rainfall Total";
            this.cunit = "IN";
            this.cname = "Precip1hr";
            this.lat_min = this.latitude - (t1 *= 2.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 2.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 9) {
            radial = 1;
            prod_elevation = -1;
            prod_max = (short)(prod_max / 10);
            endDate = Nidsheader.getDate(pinfo.p7, pinfo.p8 * 60 * 1000);
            summary = "N3P is a raster image of 3 hour surface rainfall accumulation at range 124 nm";
            this.cmemo = "3-hr Rainfall [IN] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(79, this.elevationNumber);
            this.ctitle = "PRE3: Surface 3-hour Rainfall Total";
            this.cunit = "IN";
            this.cname = "Precip3hr";
            this.lat_min = this.latitude - (t1 *= 2.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 2.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 17) {
            radial = 1;
            prod_elevation = -1;
            endDate = Nidsheader.getDate(pinfo.p7, pinfo.p8 * 60 * 1000);
            summary = "DSP is a radial image of digital storm total rainfall";
            this.cmemo = "Digital Strm Total Precip [IN] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(80, this.elevationNumber);
            this.ctitle = "DPRE: Digital Storm Total Rainfall";
            this.cunit = "IN";
            this.cname = "DigitalPrecip";
            this.lat_min = this.latitude - (t1 *= 2.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 2.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 10) {
            radial = 1;
            prod_elevation = -1;
            endDate = Nidsheader.getDate(pinfo.p7, pinfo.p8 * 60 * 1000);
            summary = "NTP is a raster image of storm total rainfall accumulation at range 124 nm";
            this.cmemo = "Strm Tot Rain [IN] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(80, this.elevationNumber);
            this.ctitle = "PRET: Surface Storm Total Rainfall";
            this.cunit = "IN";
            this.cname = "PrecipAccum";
            this.lat_min = this.latitude - (t1 *= 2.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 2.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 11) {
            radial = 3;
            prod_elevation = -1;
            summary = "DPA is a raster image of hourly digital precipitation array at range 124 nm";
            endDate = Nidsheader.getDate(pinfo.p7, pinfo.p8 * 60 * 1000);
            this.cmemo = "Precip Array [IN] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(81, this.elevationNumber);
            this.ctitle = "PRET: Hourly Digital Precipitation Array";
            this.cunit = "dBA";
            this.cname = "PrecipArray";
        } else if (prod_type == 7) {
            radial = 3;
            prod_elevation = -1;
            summary = "NVL is a raster image of verticalintegrated liguid at range 124 nm";
            this.cmemo = "Vert Int Lq H2O [mm] " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(57, this.elevationNumber);
            this.ctitle = "VIL: Vertically-integrated Liquid Water";
            this.cunit = "kg/m^2";
            this.cname = "VertLiquid";
            this.lat_min = this.latitude - (t1 *= 4.0);
            this.lat_max = this.latitude + t1;
            this.lon_min = this.longitude + (t2 *= 4.0);
            this.lon_max = this.longitude - t2;
        } else if (prod_type == 2 || prod_type == 19) {
            radial = 1;
            prod_elevation = pinfo.p3;
            prod_min = pinfo.p4;
            prod_max = pinfo.p5;
            this.ctilt = prod_type == 2 ? Nidsheader.pname_lookup(pinfo.pcode, prod_elevation / 10) : "V" + prod_elevation / 10;
            if (pinfo.pcode == 25) {
                t1 = 0.5329498472047456;
                t2 = 64.0 / (111.26 * Math.cos(Math.toRadians(this.latitude)));
                this.lat_min = this.latitude - t1;
                this.lat_max = this.latitude + t1;
                this.lon_min = this.longitude + t2;
                this.lon_max = this.longitude - t2;
                summary = this.ctilt + " is a radial image of base velocity" + (prod_elevation / 10 + 1) + " and  range 32 nm";
                this.cunit = "m/s";
            } else {
                summary = this.ctilt + " is a radial image of base velocity at tilt " + (prod_elevation / 10 + 1);
                this.cunit = "m/s";
            }
            this.cmemo = "Rad Vel " + (double)prod_elevation / 10.0 + " DEG " + cmode[pinfo.opmode];
            this.ctitle = "VEL: Radial Velocity";
            this.cname = "RadialVelocity";
        } else if (prod_type == 13) {
            radial = 1;
            prod_elevation = pinfo.p3;
            prod_min = pinfo.p4;
            prod_max = pinfo.p5;
            this.ctilt = Nidsheader.pname_lookup(56, prod_elevation / 10);
            summary = this.ctilt + " is a radial image of storm relative mean radial velocity at tilt " + (prod_elevation / 10 + 1) + " and  range 124 nm";
            this.cmemo = "StrmRelMnVl " + (double)prod_elevation / 10.0 + " DEG " + cmode[pinfo.opmode];
            this.ctitle = "SRMV: Storm Relative Mean Velocity";
            this.cunit = "KT";
            this.cname = "StormMeanVelocity";
        } else if (prod_type == 14) {
            radial = 0;
            prod_elevation = pinfo.p3;
            prod_min = pinfo.p4;
            prod_max = pinfo.p5;
            summary = "NVW is VAD wind profile which contains wind barbs and alpha numeric data";
            this.cmemo = "StrmRelMnVl " + (double)prod_elevation / 10.0 + " DEG " + cmode[pinfo.opmode];
            this.ctilt = Nidsheader.pname_lookup(48, this.elevationNumber);
            this.ctitle = "SRMV: Velocity Azimuth Display";
            this.cunit = "KT";
            this.cname = "VADWindSpeed";
            this.lat_min = this.latitude;
            this.lat_max = this.latitude;
            this.lon_min = this.longitude;
            this.lon_max = this.longitude;
        } else {
            this.ctilt = "error";
            this.ctitle = "error";
            this.cunit = "error";
            this.cname = "error";
        }
        this.ncfile.addAttribute(null, new Attribute("summary", "Nexrad level 3 data are WSR-88D radar products." + summary));
        this.ncfile.addAttribute(null, new Attribute("keywords_vocabulary", this.ctilt));
        this.ncfile.addAttribute(null, new Attribute("conventions", "_Coordinates"));
        this.ncfile.addAttribute(null, new Attribute("format", "Level3/NIDS"));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", (Number)Float.valueOf((float)this.lat_min)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", (Number)Float.valueOf((float)this.lat_max)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", (Number)Float.valueOf((float)this.lon_min)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", (Number)Float.valueOf((float)this.lon_max)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_min", (Number)Float.valueOf((float)this.height)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_max", (Number)Float.valueOf((float)this.height)));
        this.ncfile.addAttribute(null, new Attribute("RadarElevationNumber", (Number)prod_elevation));
        String dstring = this.formatter.toDateTimeStringISO(startDate);
        this.ncfile.addAttribute(null, new Attribute("time_coverage_start", dstring));
        dstring = this.formatter.toDateTimeStringISO(endDate);
        this.ncfile.addAttribute(null, new Attribute("time_coverage_end", dstring));
        this.ncfile.addAttribute(null, new Attribute("data_min", (Number)Float.valueOf(prod_min)));
        this.ncfile.addAttribute(null, new Attribute("data_max", (Number)Float.valueOf(prod_max)));
        this.ncfile.addAttribute(null, new Attribute("isRadial", (Number)radial));
    }

    private byte[] uncompressed(ByteBuffer buf, int offset, int uncomplen) throws IOException {
        byte[] header = new byte[offset];
        buf.position(0);
        buf.get(header);
        byte[] out = new byte[offset + uncomplen];
        System.arraycopy(header, 0, out, 0, offset);
        CBZip2InputStream cbzip2 = new CBZip2InputStream();
        int numCompBytes = buf.remaining();
        byte[] bufc = new byte[numCompBytes];
        buf.get(bufc, 0, numCompBytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bufc, 2, numCompBytes - 2);
        cbzip2.setStream((InputStream)bis);
        int total = 0;
        byte[] ubuff = new byte[40000];
        byte[] obuff = new byte[40000];
        try {
            int nread;
            while ((nread = cbzip2.read(ubuff)) != -1) {
                if (total + nread > obuff.length) {
                    byte[] temp = obuff;
                    obuff = new byte[temp.length * 2];
                    System.arraycopy(temp, 0, obuff, 0, temp.length);
                }
                System.arraycopy(ubuff, 0, obuff, total, nread);
                total += nread;
            }
            if (obuff.length >= 0) {
                System.arraycopy(obuff, 0, out, offset, total);
            }
        }
        catch (BZip2ReadException ioe) {
            log.warn("Nexrad2IOSP.uncompress " + this.raf.getLocation(), (Throwable)ioe);
        }
        return out;
    }

    private static int shortsToInt(short s1, short s2, boolean swapBytes) {
        byte[] b = new byte[]{(byte)(s1 >>> 8), (byte)s1, (byte)(s2 >>> 8), (byte)s2};
        return Nidsheader.bytesToInt(b, false);
    }

    private static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    private Sinfo read_dividlen(ByteBuffer buf, int offset) {
        byte[] b2 = new byte[2];
        byte[] b4 = new byte[4];
        buf.position(offset);
        buf.get(b2, 0, 2);
        Short tShort = (Short)this.convert(b2, DataType.SHORT, -1);
        short D_divider = tShort;
        buf.get(b2, 0, 2);
        short D_id = (short)this.getInt(b2, 2);
        buf.get(b4, 0, 4);
        this.block_length = this.getInt(b4, 4);
        buf.get(b2, 0, 2);
        this.number_layers = (short)this.getInt(b2, 2);
        return new Sinfo(D_divider, D_id, this.block_length, this.number_layers);
    }

    private void read_SATab(ByteBuffer buf, int offset) {
        byte[] b2 = new byte[2];
        buf.position(offset);
        buf.get(b2, 0, 2);
        Short tShort = (Short)this.convert(b2, DataType.SHORT, -1);
        short B_divider = tShort;
        if (B_divider != -1) {
            log.warn("error reading stand alone tab message " + this.raf.getLocation());
        }
        buf.get(b2, 0, 2);
        int numPages = ((Short)this.convert(b2, DataType.SHORT, -1)).shortValue();
        for (int i = 0; i < numPages; ++i) {
            short numChars;
            buf.get(b2, 0, 2);
            while (this.getInt(b2, 2) != -1 && (numChars = (short)this.getInt(b2, 2)) >= 0) {
                byte[] tmp = new byte[numChars];
                buf.get(tmp);
                buf.get(b2, 0, 2);
            }
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension tbDim = new Dimension("pageNumber", numPages);
        this.ncfile.addDimension(null, tbDim);
        dims.add(tbDim);
        Variable ppage = new Variable(this.ncfile, null, null, "TabMessagePage");
        ppage.setDimensions(dims);
        ppage.setDataType(DataType.STRING);
        ppage.addAttribute(new Attribute("long_name", "Stand Alone Tabular Alphanumeric Product Message"));
        this.ncfile.addVariable(null, ppage);
    }

    private int read_msghead(ByteBuffer buf, int offset) {
        byte[] b2 = new byte[2];
        byte[] b4 = new byte[4];
        buf.position(0);
        buf.get(b2, 0, 2);
        this.mcode = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.mdate = (short)this.getInt(b2, 2);
        buf.get(b4, 0, 4);
        this.mtime = this.getInt(b4, 4);
        buf.get(b4, 0, 4);
        this.mlength = this.getInt(b4, 4);
        buf.get(b2, 0, 2);
        this.msource = (short)this.getInt(b2, 2);
        if (this.stationId == null || this.stationName == null) {
            try {
                NexradStationDB.init();
                NexradStationDB.Station station = NexradStationDB.getByIdNumber("000" + this.msource);
                if (station != null) {
                    this.stationId = station.id;
                    this.stationName = station.name;
                }
            }
            catch (IOException ioe) {
                log.error("NexradStationDB.init " + this.raf.getLocation(), (Throwable)ioe);
            }
        }
        buf.get(b2, 0, 2);
        this.mdestId = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.mNumOfBlock = (short)this.getInt(b2, 2);
        return 1;
    }

    private int getUInt(byte[] b, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    private int getInt(byte[] b, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[i]);
        }
        if (bv[0] > 127) {
            bv[0] = bv[0] - 128;
            base = -1;
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    private static int bytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    private short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    private int convertShort2unsignedInt(short b) {
        return b < 0 ? -1 * b + 32768 : b;
    }

    public static Date getDate(int julianDays, int msecs) {
        long total = (long)(julianDays - 1) * 24L * 3600L * 1000L + (long)msecs;
        return new Date(total);
    }

    Pinfo read_proddesc(ByteBuffer buf, int offset) {
        int i;
        byte[] b45;
        byte[] b2 = new byte[2];
        byte[] b4 = new byte[4];
        int off = offset;
        this.ncfile.addAttribute(null, new Attribute("title", "Nexrad Level 3 Data"));
        this.ncfile.addAttribute(null, new Attribute("keywords", "WSR-88D; NIDS"));
        this.ncfile.addAttribute(null, new Attribute("creator_name", "NOAA/NWS"));
        this.ncfile.addAttribute(null, new Attribute("creator_url", "http://www.ncdc.noaa.gov/oa/radar/radarproducts.html"));
        this.ncfile.addAttribute(null, new Attribute("naming_authority", "NOAA/NCDC"));
        buf.position(offset);
        buf.get(b2, 0, 2);
        Short tShort = (Short)this.convert(b2, DataType.SHORT, -1);
        this.divider = tShort;
        this.ncfile.addAttribute(null, new Attribute("Divider", (Number)tShort));
        buf.get(b4, 0, 4);
        Integer tInt = (Integer)this.convert(b4, DataType.INT, -1);
        this.latitude = (double)tInt.intValue() / 1000.0;
        buf.get(b4, 0, 4);
        tInt = (Integer)this.convert(b4, DataType.INT, -1);
        this.longitude = (double)tInt.intValue() / 1000.0;
        buf.get(b2, 0, 2);
        this.height = (double)this.getInt(b2, 2) * 0.3048;
        this.ncfile.addAttribute(null, new Attribute("RadarLatitude", (Number)this.latitude));
        this.ncfile.addAttribute(null, new Attribute("RadarLongitude", (Number)this.longitude));
        this.ncfile.addAttribute(null, new Attribute("RadarAltitude", (Number)this.height));
        buf.get(b2, 0, 2);
        this.pcode = (short)this.getInt(b2, 2);
        if (this.stationId != null) {
            this.ncfile.addAttribute(null, new Attribute("ProductStation", this.stationId));
        }
        if (this.stationName != null) {
            this.ncfile.addAttribute(null, new Attribute("ProductStationName", this.stationName));
        }
        buf.get(b2, 0, 2);
        this.opmode = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("OperationalMode", (Number)this.opmode));
        buf.get(b2, 0, 2);
        this.volumnScanPattern = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("VolumeCoveragePatternName", (Number)this.volumnScanPattern));
        buf.get(b2, 0, 2);
        this.sequenceNumber = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("SequenceNumber", (Number)this.sequenceNumber));
        buf.get(b2, 0, 2);
        this.volumeScanNumber = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("VolumeScanNumber", (Number)this.volumeScanNumber));
        buf.get(b2, 0, 2);
        this.volumeScanDate = (short)this.getUInt(b2, 2);
        buf.get(b4, 0, 4);
        this.volumeScanTime = this.getUInt(b4, 4);
        buf.get(b2, 0, 2);
        this.productDate = (short)this.getUInt(b2, 2);
        buf.get(b4, 0, 4);
        this.productTime = this.getUInt(b4, 4);
        Date pDate = Nidsheader.getDate(this.productDate, this.productTime * 1000);
        String dstring = this.formatter.toDateTimeStringISO(pDate);
        this.ncfile.addAttribute(null, new Attribute("DateCreated", dstring));
        buf.get(b2, 0, 2);
        this.p1 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p2 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.elevationNumber = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("ElevationNumber", (Number)this.elevationNumber));
        buf.get(b2, 0, 2);
        this.p3 = (short)this.getInt(b2, 2);
        off += 40;
        if (this.pcode == 182 || this.pcode == 186 || this.pcode == 32 || this.pcode == 94 || this.pcode == 99) {
            for (int i2 = 0; i2 < 16; ++i2) {
                buf.get(b2, 0, 2);
                this.threshold[i2] = (short)Nidsheader.bytesToInt(b2[0], b2[1], false);
            }
        } else if (this.pcode == 159 || this.pcode == 161 || this.pcode == 163 || this.pcode == 170 || this.pcode == 172 || this.pcode == 173 || this.pcode == 174 || this.pcode == 175) {
            buf.get(b4, 0, 4);
            byte[] b44 = new byte[]{b4[3], b4[2], b4[1], b4[0]};
            this.threshold[0] = (short)(ByteBuffer.wrap(b44).order(ByteOrder.LITTLE_ENDIAN).getFloat() * 100.0f);
            buf.get(b4, 0, 4);
            b45 = new byte[]{b4[3], b4[2], b4[1], b4[0]};
            this.threshold[1] = (short)(ByteBuffer.wrap(b45).order(ByteOrder.LITTLE_ENDIAN).getFloat() * 100.0f);
            buf.get(b2, 0, 2);
            this.threshold[2] = 0;
            for (i = 3; i < 6; ++i) {
                buf.get(b2, 0, 2);
                this.threshold[i] = (short)Nidsheader.bytesToInt(b2[0], b2[1], false);
            }
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
        } else if (this.pcode == 176) {
            buf.get(b4, 0, 4);
            byte[] b44 = new byte[]{b4[3], b4[2], b4[1], b4[0]};
            this.threshold[0] = (short)ByteBuffer.wrap(b44).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            buf.get(b4, 0, 4);
            b45 = new byte[]{b4[3], b4[2], b4[1], b4[0]};
            this.threshold[1] = (short)ByteBuffer.wrap(b45).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            buf.get(b2, 0, 2);
            this.threshold[2] = 0;
            for (i = 3; i < 6; ++i) {
                buf.get(b2, 0, 2);
                this.threshold[i] = (short)Nidsheader.bytesToInt(b2[0], b2[1], false);
            }
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
            buf.get(b4, 0, 4);
        } else {
            for (int i3 = 0; i3 < 16; ++i3) {
                buf.get(b2, 0, 2);
                this.threshold[i3] = (short)this.getInt(b2, 2);
            }
        }
        off += 32;
        buf.get(b2, 0, 2);
        this.p4 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p5 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p6 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p7 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p8 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p9 = (short)this.getInt(b2, 2);
        buf.get(b2, 0, 2);
        this.p10 = (short)this.getUInt(b2, 2);
        off += 14;
        buf.get(b2, 0, 2);
        this.numberOfMaps = (short)this.getInt(b2, 2);
        this.ncfile.addAttribute(null, new Attribute("NumberOfMaps", (Number)this.numberOfMaps));
        off += 2;
        buf.get(b4, 0, 4);
        this.offsetToSymbologyBlock = this.getInt(b4, 4);
        off += 4;
        buf.get(b4, 0, 4);
        this.offsetToGraphicBlock = this.getInt(b4, 4);
        off += 4;
        buf.get(b4, 0, 4);
        this.offsetToTabularBlock = this.getInt(b4, 4);
        return new Pinfo(this.divider, this.latitude, this.longitude, this.height, this.pcode, this.opmode, this.threshold, this.sequenceNumber, this.volumeScanNumber, this.volumeScanDate, this.volumeScanTime, this.productDate, this.productTime, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7, this.p8, this.p9, this.p10, this.elevationNumber, this.numberOfMaps, this.offsetToSymbologyBlock, this.offsetToGraphicBlock, this.offsetToTabularBlock);
    }

    protected Object convert(byte[] barray, DataType dataType, int nelems, int byteOrder) {
        if (dataType == DataType.BYTE) {
            return barray;
        }
        if (dataType == DataType.CHAR) {
            return IospHelper.convertByteToChar((byte[])barray);
        }
        ByteBuffer bbuff = ByteBuffer.wrap(barray);
        if (byteOrder >= 0) {
            bbuff.order(byteOrder == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        if (dataType == DataType.SHORT) {
            ShortBuffer tbuff = bbuff.asShortBuffer();
            short[] pa = new short[nelems];
            tbuff.get(pa);
            return pa;
        }
        if (dataType == DataType.INT) {
            IntBuffer tbuff = bbuff.asIntBuffer();
            int[] pa = new int[nelems];
            tbuff.get(pa);
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            FloatBuffer tbuff = bbuff.asFloatBuffer();
            float[] pa = new float[nelems];
            tbuff.get(pa);
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            DoubleBuffer tbuff = bbuff.asDoubleBuffer();
            double[] pa = new double[nelems];
            tbuff.get(pa);
            return pa;
        }
        throw new IllegalStateException();
    }

    protected Object convert(byte[] barray, DataType dataType, int byteOrder) {
        if (dataType == DataType.BYTE) {
            return barray[0];
        }
        if (dataType == DataType.CHAR) {
            return Character.valueOf((char)barray[0]);
        }
        ByteBuffer bbuff = ByteBuffer.wrap(barray);
        if (byteOrder >= 0) {
            bbuff.order(byteOrder == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        if (dataType == DataType.SHORT) {
            ShortBuffer tbuff = bbuff.asShortBuffer();
            return tbuff.get();
        }
        if (dataType == DataType.INT) {
            IntBuffer tbuff = bbuff.asIntBuffer();
            return tbuff.get();
        }
        if (dataType == DataType.LONG) {
            LongBuffer tbuff = bbuff.asLongBuffer();
            return tbuff.get();
        }
        if (dataType == DataType.FLOAT) {
            FloatBuffer tbuff = bbuff.asFloatBuffer();
            return Float.valueOf(tbuff.get());
        }
        if (dataType == DataType.DOUBLE) {
            DoubleBuffer tbuff = bbuff.asDoubleBuffer();
            return tbuff.get();
        }
        throw new IllegalStateException();
    }

    public void flush() throws IOException {
        this.raf.flush();
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    int isZlibHed(byte[] buf) {
        short b0 = this.convertunsignedByte2Short(buf[0]);
        short b1 = this.convertunsignedByte2Short(buf[1]);
        if ((b0 & 0xF) == this.Z_DEFLATED && (b0 >> 4) + 8 <= this.DEF_WBITS && ((b0 << 8) + b1) % 31 == 0) {
            return 1;
        }
        return 0;
    }

    int IsEncrypt(byte[] buf) {
        String b = new String(buf, StandardCharsets.UTF_8);
        if (b.startsWith("R3")) {
            return 1;
        }
        return 0;
    }

    byte[] GetZlibedNexr(byte[] buf, int buflen, int hoff) throws IOException {
        int numin = buflen - hoff;
        if (numin <= 0) {
            log.warn(" No compressed data to inflate " + this.raf.getLocation());
            return null;
        }
        System.arraycopy(buf, hoff, buf, hoff, numin - 4);
        int result = 0;
        int uncompLen = 24500;
        byte[] uncomp = new byte[uncompLen];
        Inflater inflater = new Inflater(false);
        inflater.setInput(buf, hoff, numin - 4);
        int offset = 0;
        int limit = 20000;
        while (inflater.getRemaining() > 0) {
            byte[] tmp;
            int resultLength;
            try {
                resultLength = inflater.inflate(uncomp, offset, 4000);
            }
            catch (DataFormatException ex) {
                log.error("nids Inflater", (Throwable)ex);
                throw new IOException(ex.getMessage(), ex);
            }
            offset += resultLength;
            if ((result += resultLength) > limit) {
                tmp = new byte[result];
                System.arraycopy(uncomp, 0, tmp, 0, result);
                uncomp = new byte[uncompLen += 10000];
                System.arraycopy(tmp, 0, uncomp, 0, result);
            }
            if (resultLength != 0) continue;
            int tt = inflater.getRemaining();
            byte[] b2 = new byte[2];
            System.arraycopy(buf, hoff + numin - 4 - tt, b2, 0, 2);
            if (result + tt > uncompLen) {
                tmp = new byte[result];
                System.arraycopy(uncomp, 0, tmp, 0, result);
                uncomp = new byte[uncompLen += 10000];
                System.arraycopy(tmp, 0, uncomp, 0, result);
            }
            if (this.isZlibHed(b2) == 0) {
                System.arraycopy(buf, hoff + numin - 4 - tt, uncomp, result, tt);
                result += tt;
                break;
            }
            inflater.reset();
            inflater.setInput(buf, hoff + numin - 4 - tt, tt);
        }
        inflater.end();
        int doff = 2 * ((uncomp[0] & 0x3F) << 8 | uncomp[1] & 0xFF);
        for (int i = 0; i < 2; ++i) {
            while (doff < result && uncomp[doff] != 10) {
                ++doff;
            }
            ++doff;
        }
        byte[] data = new byte[result - doff];
        System.arraycopy(uncomp, doff, data, 0, result - doff);
        return data;
    }

    static int code_typelookup(int code) {
        int[] types = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 12, 1, 2, 2, 2, 2, 2, 2, 15, 15, 15, 0, 16, 0, 0, 3, 3, 3, 3, 0, 0, 6, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 13, 13, 7, 0, 0, 0, 0, 0, 4, 4, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 9, 10, 11, 0, 0, 0, 0, 0, 0, 0, 4, 5, 0, 0, 0, 21, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 23, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 31, 0, 32, 0, 33, 0, 0, 0, 36, 37, 38, 39, 40, 42, 43, 44, 45, 0, 0, 18, 18, 19, 19, 0, 20, 18, 18, 0, 0};
        int type = code < 0 || code > 189 ? 0 : types[code];
        return type;
    }

    static String pname_lookup(int code, int elevation) {
        String pname = null;
        switch (code) {
            case 15: {
                if (elevation == 1) {
                    pname = "NAX";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBX";
                    break;
                }
                pname = "N" + elevation / 2 + "X";
                break;
            }
            case 16: {
                if (elevation == 1) {
                    pname = "NAC";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBC";
                    break;
                }
                pname = "N" + elevation / 2 + "C";
                break;
            }
            case 17: {
                if (elevation == 1) {
                    pname = "NAK";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBK";
                    break;
                }
                pname = "N" + elevation / 2 + "K";
                break;
            }
            case 18: {
                if (elevation == 1) {
                    pname = "NAH";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBH";
                    break;
                }
                pname = "N" + elevation / 2 + "H";
                break;
            }
            case 19: {
                pname = "N" + elevation + "R";
                break;
            }
            case 20: {
                pname = "N0Z";
                break;
            }
            case 25: {
                pname = "N0W";
                break;
            }
            case 27: {
                pname = "N" + elevation + "V";
                break;
            }
            case 28: {
                pname = "NSP";
                break;
            }
            case 30: {
                pname = "NSW";
                break;
            }
            case 36: {
                pname = "NCO";
                break;
            }
            case 37: {
                pname = "NCR";
                break;
            }
            case 38: {
                pname = "NCZ";
                break;
            }
            case 41: {
                pname = "NET";
                break;
            }
            case 48: {
                pname = "NVW";
                break;
            }
            case 56: {
                pname = "N" + elevation + "S";
                break;
            }
            case 57: {
                pname = "NVL";
                break;
            }
            case 65: {
                pname = "NLL";
                break;
            }
            case 66: {
                pname = "NML";
                break;
            }
            case 78: {
                pname = "N1P";
                break;
            }
            case 79: {
                pname = "N3P";
                break;
            }
            case 80: {
                pname = "NTP";
                break;
            }
            case 81: {
                pname = "DPA";
                break;
            }
            case 90: {
                pname = "NHL";
                break;
            }
            case 94: {
                if (elevation == 1) {
                    pname = "NAQ";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBQ";
                    break;
                }
                pname = "N" + elevation / 2 + "Q";
                break;
            }
            case 99: {
                if (elevation == 1) {
                    pname = "NAU";
                    break;
                }
                if (elevation == 3) {
                    pname = "NBU";
                    break;
                }
                pname = "N" + elevation / 2 + "U";
                break;
            }
            case 134: {
                pname = "DVL";
                break;
            }
            case 135: {
                pname = "EET";
                break;
            }
            case 182: {
                pname = "DV";
                break;
            }
            case 181: 
            case 187: {
                pname = "R";
                break;
            }
            case 180: 
            case 186: {
                pname = "DR";
                break;
            }
            case 183: {
                pname = "V";
                break;
            }
            case 185: {
                pname = "SW";
                break;
            }
        }
        return pname;
    }

    static double code_reslookup(int code) {
        double[] res = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 1.0, 2.0, 4.0, 0.25, 0.5, 1.0, 0.25, 0.5, 1.0, 0.25, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 4.0, 1.0, 4.0, 0.0, 0.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 1.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0, 4.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.25, 0.0, 0.25, 0.0, 0.25, 0.0, 0.0, 0.0, 2.0, 0.25, 2.0, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.0, 0.0, 0.0, 150.0, 150.0, 0.0, 0.0, 0.0, 300.0, 0.0, 0.0, 0.0};
        double data_res = code < 0 || code > 189 ? 0.0 : res[code];
        return data_res;
    }

    static int code_levelslookup(int code) {
        int[] levels = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 16, 16, 16, 8, 8, 8, 16, 16, 16, 8, 0, 8, 0, 256, 0, 0, 8, 8, 16, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 256, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 256, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 199, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 256, 0, 256, 0, 256, 0, 0, 0, 16, 256, 16, 256, 256, 0, 0, 0, 16, 0, 0, 0, 16, 256, 0, 0, 0, 256, 0, 0, 0};
        int level = code < 0 || code > 189 ? 0 : levels[code];
        return level;
    }

    static class Pinfo {
        short divider;
        short pcode;
        short opmode;
        short sequenceNumber;
        short volumeScanNumber;
        short volumeScanDate;
        short productDate;
        double height;
        int volumeScanTime;
        int productTime;
        short p1;
        short p2;
        short p3;
        short p4;
        short p5;
        short p6;
        short p7;
        short p8;
        short p9;
        short p10;
        int offsetToSymbologyBlock;
        int offsetToGraphicBlock;
        int offsetToTabularBlock;
        short[] threshold;

        Pinfo(short divider, double latitude, double longitude, double height, short pcode, short opmode, short[] threshold, short sequenceNumber, short volumeScanNumber, short volumeScanDate, int volumeScanTime, short productDate, int productTime, short p1, short p2, short p3, short p4, short p5, short p6, short p7, short p8, short p9, short p10, short elevationNumber, short numberOfMaps, int offsetToSymbologyBlock, int offsetToGraphicBlock, int offsetToTabularBlock) {
            this.divider = divider;
            this.height = height;
            this.pcode = pcode;
            this.opmode = opmode;
            this.sequenceNumber = sequenceNumber;
            this.volumeScanNumber = volumeScanNumber;
            this.volumeScanDate = volumeScanDate;
            this.volumeScanTime = volumeScanTime;
            this.productDate = productDate;
            this.productTime = productTime;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.p5 = p5;
            this.p6 = p6;
            this.p7 = p7;
            this.p8 = p8;
            this.p9 = p9;
            this.p10 = p10;
            this.threshold = threshold;
            this.offsetToSymbologyBlock = offsetToSymbologyBlock;
            this.offsetToGraphicBlock = offsetToGraphicBlock;
            this.offsetToTabularBlock = offsetToTabularBlock;
        }
    }

    static class Vinfo {
        int xt;
        int x0;
        int yt;
        int y0;
        boolean isRadial;
        long hoff;
        long doff;
        boolean isZlibed;
        int[] pos;
        int[] len;
        int code;
        int level;

        Vinfo(int xt, int x0, int yt, int y0, long hoff, long doff, boolean isRadial, boolean isZ, int[] pos, int[] len, int code, int level) {
            this.xt = xt;
            this.yt = yt;
            this.x0 = x0;
            this.y0 = y0;
            this.hoff = hoff;
            this.doff = doff;
            this.isRadial = isRadial;
            this.isZlibed = isZ;
            this.pos = pos;
            this.len = len;
            this.code = code;
            this.level = level;
        }
    }

    static class Sinfo {
        short divider;
        short id;
        int blockLength;
        short nlayers;

        Sinfo(short divider, short id, int length, short layers) {
            this.divider = divider;
            this.id = id;
            this.blockLength = length;
            this.nlayers = layers;
        }
    }
}

