/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dorade;

import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.DoradeSweep;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;

public class Doradeheader {
    private NetcdfFile ncfile;
    private float[] lat_min;
    private float[] lat_max;
    private float[] lon_min;
    private float[] lon_max;
    private float[] hi_max;
    private float[] hi_min;

    public static boolean isValidFile(ucar.unidata.io.RandomAccessFile raf) {
        try {
            RandomAccessFile file = raf.getRandomAccessFile();
            if (file == null) {
                return false;
            }
            boolean t = DoradeSweep.isDoradeSweep(file);
            if (!t) {
                return false;
            }
        }
        catch (DoradeSweep.DoradeSweepException ex) {
            return false;
        }
        return true;
    }

    void read(DoradeSweep mySweep, NetcdfFile ncfile, PrintStream out) {
        int j;
        int i;
        this.ncfile = ncfile;
        DoradePARM[] parms = mySweep.getParamList();
        int nRays = mySweep.getNRays();
        int numSensor = mySweep.getNSensors();
        int[] ncells = new int[numSensor];
        Dimension[] gateDim = new Dimension[numSensor];
        for (int i2 = 0; i2 < numSensor; ++i2) {
            try {
                int j2 = i2 + 1;
                ncells[i2] = mySweep.getNCells(i2);
                gateDim[i2] = new Dimension("gate_" + j2, ncells[i2]);
                ncfile.addDimension(null, gateDim[i2]);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList[] dims = new ArrayList[numSensor];
        ArrayList<Dimension> dims1 = new ArrayList<Dimension>();
        ArrayList[] dims2 = new ArrayList[numSensor];
        Dimension radialDim = new Dimension("radial", nRays);
        ncfile.addDimension(null, radialDim);
        for (int i3 = 0; i3 < numSensor; ++i3) {
            dims[i3] = new ArrayList();
            dims2[i3] = new ArrayList();
            dims[i3].add(radialDim);
            dims[i3].add(gateDim[i3]);
            dims2[i3].add(gateDim[i3]);
        }
        dims1.add(radialDim);
        float[][] altitudes = new float[numSensor][];
        float[][] latitudes = new float[numSensor][];
        float[][] longitudes = new float[numSensor][];
        this.lat_min = new float[numSensor];
        this.lat_max = new float[numSensor];
        this.lon_min = new float[numSensor];
        this.lon_max = new float[numSensor];
        this.hi_min = new float[numSensor];
        this.hi_max = new float[numSensor];
        MAMath.MinMax[] latMinMax = new MAMath.MinMax[numSensor];
        MAMath.MinMax[] lonMinMax = new MAMath.MinMax[numSensor];
        MAMath.MinMax[] hiMinMax = new MAMath.MinMax[numSensor];
        boolean[] isMoving = new boolean[numSensor];
        for (int i4 = 0; i4 < numSensor; ++i4) {
            try {
                int nc = mySweep.getNCells(i4);
                altitudes[i4] = new float[nRays];
                latitudes[i4] = new float[nRays];
                longitudes[i4] = new float[nRays];
                isMoving[i4] = mySweep.sensorIsMoving(i4);
                altitudes[i4] = mySweep.getAltitudes(i4);
                latitudes[i4] = mySweep.getLatitudes(i4);
                longitudes[i4] = mySweep.getLongitudes(i4);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            latMinMax[i4] = this.getMinMaxData(latitudes[i4]);
            lonMinMax[i4] = this.getMinMaxData(longitudes[i4]);
            hiMinMax[i4] = this.getMinMaxData(altitudes[i4]);
            float dis = (float)((double)(mySweep.getRangeToFirstCell(i4) + (float)(mySweep.getNCells(i4) - 1) * mySweep.getCellSpacing(i4)) * 1.853 / 111.26 / 1000.0);
            this.lat_min[i4] = (float)(latMinMax[i4].min - (double)dis);
            this.lat_max[i4] = (float)(latMinMax[i4].max + (double)dis);
            this.lon_min[i4] = (float)(lonMinMax[i4].min + (double)dis * Math.cos(latitudes[i4][0]));
            this.lon_max[i4] = (float)(lonMinMax[i4].max - (double)dis * Math.cos(latitudes[i4][0]));
            this.hi_min[i4] = (float)hiMinMax[i4].min;
            this.hi_max[i4] = (float)hiMinMax[i4].max;
        }
        this.addNCAttributes(ncfile, mySweep);
        String vName = "elevation";
        String lName = "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular";
        Attribute att = new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString());
        this.addParameter(vName, lName, ncfile, dims1, att, DataType.FLOAT, "degrees");
        vName = "azimuth";
        lName = "azimuth angle in degrees: 0 = true north, 90 = east";
        att = new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString());
        this.addParameter(vName, lName, ncfile, dims1, att, DataType.FLOAT, "degrees");
        for (i = 0; i < numSensor; ++i) {
            j = i + 1;
            vName = "distance_" + j;
            lName = "Radial distance to the start of gate";
            att = new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString());
            this.addParameter(vName, lName, ncfile, dims2[i], att, DataType.FLOAT, "meters");
        }
        for (i = 0; i < numSensor; ++i) {
            j = i + 1;
            vName = "latitudes_" + j;
            lName = "Latitude of the instrument " + j;
            att = new Attribute("_CoordinateAxisType", AxisType.Lat.toString());
            this.addParameter(vName, lName, ncfile, dims1, att, DataType.FLOAT, "degrees");
            vName = "longitudes_" + j;
            lName = "Longitude of the instrument " + j;
            att = new Attribute("_CoordinateAxisType", AxisType.Lon.toString());
            this.addParameter(vName, lName, ncfile, dims1, att, DataType.FLOAT, "degrees");
            vName = "altitudes_" + j;
            lName = "Altitude in meters (asl) of the instrument " + j;
            att = new Attribute("_CoordinateAxisType", AxisType.Height.toString());
            this.addParameter(vName, lName, ncfile, dims1, att, DataType.FLOAT, "meters");
            vName = "rays_time";
            lName = "rays time";
            att = new Attribute("_CoordinateAxisType", AxisType.Time.toString());
            this.addParameter(vName, lName, ncfile, dims1, att, DataType.DOUBLE, "milliseconds since 1970-01-01 00:00 UTC");
        }
        vName = "Range_to_First_Cell";
        lName = "Range to the center of the first cell";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "meters");
        vName = "Cell_Spacing";
        lName = "Distance between cells";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "meters");
        vName = "Fixed_Angle";
        lName = "Targeted fixed angle for this scan";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "degrees");
        vName = "Nyquist_Velocity";
        lName = "Effective unambigous velocity";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "m/s");
        vName = "Unambiguous_Range";
        lName = "Effective unambigous range";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "meters");
        vName = "Radar_Constant";
        lName = "Radar constant";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "c");
        vName = "rcvr_gain";
        lName = "Receiver Gain";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "db");
        vName = "ant_gain";
        lName = "Antenna Gain";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "db");
        vName = "sys_gain";
        lName = "System Gain";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "db");
        vName = "bm_width";
        lName = "Beam Width";
        this.addParameter(vName, lName, ncfile, null, null, DataType.FLOAT, "degrees");
        try {
            for (int p = 0; p < parms.length; ++p) {
                String pval = parms[p].getDescription();
                int nCells = parms[p].getNCells();
                int ii = this.getGateDimsIndex(nCells, gateDim, numSensor);
                this.addVariable(ncfile, dims[ii], parms[p]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ncfile.finish();
    }

    public MAMath.MinMax getMinMaxData(float[] data) {
        int[] shape = new int[]{data.length};
        Array a = Array.factory((DataType)DataType.FLOAT, (int[])shape, (Object)data);
        return MAMath.getMinMax((Array)a);
    }

    int getGateDimsIndex(int cell, Dimension[] dList, int numSensor) {
        int j = 0;
        for (int i = 0; i < numSensor; ++i) {
            Dimension d = new Dimension("gate_" + i, cell);
            if (!dList[i].equals((Object)d)) continue;
            j = i;
            break;
        }
        return j;
    }

    private void makeCoordinateData(Variable elev, Variable azim, DoradeSweep mySweep) {
        float[] ele = mySweep.getElevations();
        float[] azi = mySweep.getAzimuths();
        Array elevData = Array.factory((DataType)elev.getDataType(), (int[])elev.getShape(), (Object)ele);
        Array aziData = Array.factory((DataType)azim.getDataType(), (int[])azim.getShape(), (Object)azi);
        elev.setCachedData(elevData, false);
        azim.setCachedData(aziData, false);
    }

    void addParameter(String pName, String longName, NetcdfFile nc, ArrayList dims, Attribute att, DataType dtype, String ut) {
        Variable vVar = new Variable(nc, null, null, pName);
        vVar.setDataType(dtype);
        if (dims != null) {
            vVar.setDimensions((List)dims);
        } else {
            vVar.setDimensions("");
        }
        if (att != null) {
            vVar.addAttribute(att);
        }
        vVar.addAttribute(new Attribute("units", ut));
        vVar.addAttribute(new Attribute("long_name", longName));
        nc.addVariable(null, vVar);
    }

    void addVariable(NetcdfFile nc, ArrayList dims, DoradePARM dparm) {
        Variable v = new Variable(nc, null, null, dparm.getName());
        v.setDataType(DataType.FLOAT);
        v.setDimensions((List)dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("long_name", dparm.getDescription()));
        v.addAttribute(new Attribute("units", dparm.getUnits()));
        String coordinates = "elevation azimuth distance_1 latitudes_1 longitudes_1 altitudes_1";
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
    }

    void addNCAttributes(NetcdfFile nc, DoradeSweep mySweep) {
        nc.addAttribute(null, new Attribute("summary", "Dorade radar data from radar " + mySweep.getSensorName(0) + " in the project " + mySweep.getProjectName()));
        nc.addAttribute(null, new Attribute("radar_name", mySweep.getSensorName(0)));
        nc.addAttribute(null, new Attribute("project_name", mySweep.getProjectName()));
        nc.addAttribute(null, new Attribute("keywords_vocabulary", "dorade"));
        nc.addAttribute(null, new Attribute("geospatial_lat_min", (Number)Float.valueOf(this.lat_min[0])));
        nc.addAttribute(null, new Attribute("geospatial_lat_max", (Number)Float.valueOf(this.lat_max[0])));
        nc.addAttribute(null, new Attribute("geospatial_lon_min", (Number)Float.valueOf(this.lon_min[0])));
        nc.addAttribute(null, new Attribute("geospatial_lon_max", (Number)Float.valueOf(this.lon_max[0])));
        nc.addAttribute(null, new Attribute("geospatial_vertical_min", (Number)Float.valueOf(this.lon_min[0])));
        nc.addAttribute(null, new Attribute("geospatial_vertical_max", (Number)Float.valueOf(this.lon_max[0])));
        Date[] dd = mySweep.getTimes();
        if (dd != null) {
            nc.addAttribute(null, new Attribute("time_coverage_start", dd[0].toString()));
            nc.addAttribute(null, new Attribute("time_coverage_end", dd[dd.length - 1].toString()));
        }
        nc.addAttribute(null, new Attribute("Content", "This file contains one scan of remotely sensed data"));
        nc.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        nc.addAttribute(null, new Attribute("featureType", FeatureType.RADIAL.toString()));
        nc.addAttribute(null, new Attribute("format", "Unidata/netCDF/Dorade"));
        nc.addAttribute(null, new Attribute("Radar_Name", mySweep.getSensorName(0)));
        nc.addAttribute(null, new Attribute("Project_name", "" + mySweep.getProjectName()));
        nc.addAttribute(null, new Attribute("VolumeCoveragePatternName", mySweep.getScanMode(0).getName()));
        nc.addAttribute(null, new Attribute("Volume_Number", "" + mySweep.getVolumnNumber()));
        nc.addAttribute(null, new Attribute("Sweep_Number", "" + mySweep.getSweepNumber()));
        nc.addAttribute(null, new Attribute("Sweep_Date", DoradeSweep.formatDate(mySweep.getTime())));
        if (mySweep.sensorIsMoving(0)) {
            nc.addAttribute(null, new Attribute("IsStationary", "0"));
        } else {
            nc.addAttribute(null, new Attribute("IsStationary", "1"));
        }
    }
}

