/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.iosp.uf.Ray;
import ucar.unidata.io.RandomAccessFile;

public class UFheader {
    static final boolean littleEndianData = true;
    String dataFormat = "UNIVERSALFORMAT";
    Ray firstRay;
    Date endDate;
    Map<String, List<List<Ray>>> variableGroup;
    private int max_radials;
    private int min_radials = Integer.MAX_VALUE;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.order(0);
            raf.seek(4L);
            String ufStr = raf.readString(2);
            if (!ufStr.equals("UF")) {
                return false;
            }
            raf.seek(0L);
            int rsize = raf.readInt();
            byte[] buffer = new byte[rsize];
            long offset = raf.getFilePointer();
            int readBytes = raf.read(buffer, 0, rsize);
            if (readBytes != rsize) {
                return false;
            }
            int endPoint = raf.readInt();
            if (endPoint != rsize) {
                return false;
            }
            ByteBuffer bos = ByteBuffer.wrap(buffer);
            this.firstRay = new Ray(bos, rsize, offset);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    void read(RandomAccessFile raf) throws IOException {
        byte[] b4;
        int bytesRead;
        HashMap<String, List> rayListMap = new HashMap<String, List>(600);
        raf.seek(0L);
        raf.order(0);
        while (!raf.isAtEndOfFile() && (bytesRead = raf.read(b4 = new byte[4])) == 4) {
            int rsize = UFheader.bytesToInt(b4, false);
            byte[] buffer = new byte[rsize];
            long offset = raf.getFilePointer();
            raf.readFully(buffer);
            raf.readFully(b4);
            int endPoint = UFheader.bytesToInt(b4, false);
            if (endPoint != rsize || rsize == 0) continue;
            ByteBuffer bos = ByteBuffer.wrap(buffer);
            Ray r = new Ray(bos, rsize, offset);
            if (this.firstRay == null) {
                this.firstRay = r;
                this.endDate = r.getDate();
            } else if (r.getTitleMsecs() > this.firstRay.getTitleMsecs()) {
                this.endDate = r.getDate();
            }
            Map<String, Ray.UF_field_header2> rayMap = r.field_header_map;
            for (Map.Entry<String, Ray.UF_field_header2> entry : rayMap.entrySet()) {
                String ab = entry.getKey();
                List group = rayListMap.computeIfAbsent(ab, k -> new ArrayList());
                group.add(r);
            }
        }
        this.variableGroup = new HashMap<String, List<List<Ray>>>();
        for (Map.Entry entry : rayListMap.entrySet()) {
            String key = (String)entry.getKey();
            List group = (List)entry.getValue();
            List<List<Ray>> sortedGroup = this.sortScans(key, group);
            this.variableGroup.put(key, sortedGroup);
        }
    }

    private List<List<Ray>> sortScans(String name, List<Ray> rays) {
        HashMap<Integer, List> sweepMap = new HashMap<Integer, List>(2 * rays.size());
        for (Ray r : rays) {
            Integer n = r.uf_header2.sweepNumber;
            List group = sweepMap.computeIfAbsent(n, k -> new ArrayList());
            group.add(r);
        }
        ArrayList<List<Ray>> groups = new ArrayList<List<Ray>>(sweepMap.values());
        groups.sort(new GroupComparator());
        for (List list : groups) {
            this.max_radials = Math.max(this.max_radials, list.size());
            this.min_radials = Math.min(this.min_radials, list.size());
        }
        return groups;
    }

    public int getMaxRadials() {
        return this.max_radials;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public Date getStartDate() {
        return this.firstRay.getDate();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public float getHorizontalBeamWidth(String ab) {
        return this.firstRay.getHorizontalBeamWidth(ab);
    }

    public String getStationId() {
        return this.getSiteName();
    }

    public String getSiteName() {
        return this.firstRay.uf_header2.siteName;
    }

    String getRadarName() {
        return this.firstRay.uf_header2.radarName;
    }

    public Short getSweepMode() {
        return this.firstRay.uf_header2.sweepMode;
    }

    public float getStationLatitude() {
        return this.firstRay.getLatitude();
    }

    public float getStationLongitude() {
        return this.firstRay.getLongtitude();
    }

    public short getStationElevation() {
        return this.firstRay.uf_header2.height;
    }

    public short getMissingData() {
        return this.firstRay.getMissingData();
    }

    protected short getShort(byte[] bytes, int offset) {
        int ndx0 = offset + 1;
        int ndx1 = offset;
        return (short)(bytes[ndx0] << 8 | bytes[ndx1] & 0xFF);
    }

    public static int bytesToShort(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    private static class GroupComparator
    implements Comparator<List<Ray>> {
        private GroupComparator() {
        }

        @Override
        public int compare(List<Ray> group1, List<Ray> group2) {
            Ray ray1 = group1.get(0);
            Ray ray2 = group2.get(0);
            return ray1.uf_header2.elevation - ray2.uf_header2.elevation < 13 ? 0 : 1;
        }
    }
}

