/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.uf.Ray;
import ucar.nc2.iosp.uf.UFheader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class UFiosp
extends AbstractIOServiceProvider {
    private static final int MISSING_INT = -9999;
    private static final float MISSING_FLOAT = Float.NaN;
    protected UFheader headerParser;
    private DateFormatter formatter = new DateFormatter();
    private double radarRadius = 100000.0;

    public boolean isValidFile(RandomAccessFile raf) {
        UFheader localHeader = new UFheader();
        return localHeader.isValidFile(raf);
    }

    public String getFileTypeId() {
        return "UniversalRadarFormat";
    }

    public String getFileTypeDescription() {
        return "Universal Radar Format";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.headerParser = new UFheader();
        this.headerParser.read(this.raf);
        for (Map.Entry<String, List<List<Ray>>> entry : this.headerParser.variableGroup.entrySet()) {
            String key = entry.getKey();
            List<List<Ray>> groups = entry.getValue();
            List<Ray> rays = groups.get(0);
            Ray ray0 = rays.get(0);
            this.makeVariable(ncfile, ray0.getDatatypeName(key), ray0.getDatatypeName(key), key, groups);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        ncfile.addAttribute(null, new Attribute("format", this.headerParser.getDataFormat()));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.RADIAL.toString()));
        ncfile.addAttribute(null, new Attribute("instrument_name", this.headerParser.getRadarName()));
        ncfile.addAttribute(null, new Attribute("site_name", this.headerParser.getSiteName()));
        ncfile.addAttribute(null, new Attribute("StationLatitude", (Number)this.headerParser.getStationLatitude()));
        ncfile.addAttribute(null, new Attribute("StationLongitude", (Number)this.headerParser.getStationLongitude()));
        ncfile.addAttribute(null, new Attribute("StationElevationInMeters", (Number)this.headerParser.getStationElevation()));
        ncfile.addAttribute(null, new Attribute("time_coverage_start", this.formatter.toDateTimeStringISO(this.headerParser.getStartDate())));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", this.formatter.toDateTimeStringISO(this.headerParser.getEndDate())));
        double latRadiusDegrees = Math.toDegrees(this.radarRadius / 6371229.0);
        ncfile.addAttribute(null, new Attribute("geospatial_lat_min", (Number)((double)this.headerParser.getStationLatitude() - latRadiusDegrees)));
        ncfile.addAttribute(null, new Attribute("geospatial_lat_max", (Number)((double)this.headerParser.getStationLatitude() + latRadiusDegrees)));
        double cosLat = Math.cos(Math.toRadians(this.headerParser.getStationLatitude()));
        double lonRadiusDegrees = Math.toDegrees(this.radarRadius / cosLat / 6371229.0);
        ncfile.addAttribute(null, new Attribute("geospatial_lon_min", (Number)((double)this.headerParser.getStationLongitude() - lonRadiusDegrees)));
        ncfile.addAttribute(null, new Attribute("geospatial_lon_max", (Number)((double)this.headerParser.getStationLongitude() + lonRadiusDegrees)));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of UF Radar by CDM (version 4.5)"));
        ncfile.addAttribute(null, new Attribute("DataType", "Radial"));
        ncfile.addAttribute(null, new Attribute("Title", "Radar Data from station " + this.headerParser.getRadarName() + " from " + this.formatter.toDateTimeStringISO(this.headerParser.getStartDate()) + " to " + this.formatter.toDateTimeStringISO(this.headerParser.getEndDate())));
        ncfile.addAttribute(null, new Attribute("SweepMode", (Number)this.headerParser.getSweepMode()));
        ncfile.finish();
    }

    public Variable makeVariable(NetcdfFile ncfile, String shortName, String longName, String abbrev, List<List<Ray>> groups) {
        int nscans = groups.size();
        if (nscans == 0) {
            throw new IllegalStateException("No data for " + shortName);
        }
        List<Ray> firstGroup = groups.get(0);
        Ray firstRay = firstGroup.get(0);
        int ngates = firstRay.getGateCount(abbrev);
        String scanDimName = "scan" + abbrev;
        String gateDimName = "gate" + abbrev;
        String radialDimName = "radial" + abbrev;
        Dimension scanDim = new Dimension(scanDimName, nscans);
        Dimension gateDim = new Dimension(gateDimName, ngates);
        Dimension radialDim = new Dimension(radialDimName, this.headerParser.getMaxRadials());
        ncfile.addDimension(null, scanDim);
        ncfile.addDimension(null, gateDim);
        ncfile.addDimension(null, radialDim);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(scanDim);
        dims.add(radialDim);
        dims.add(gateDim);
        Variable v = new Variable(ncfile, null, null, shortName + abbrev);
        v.setDataType(DataType.SHORT);
        v.setDimensions(dims);
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", firstRay.getDatatypeUnits(abbrev)));
        v.addAttribute(new Attribute("long_name", longName));
        v.addAttribute(new Attribute("abbrev", abbrev));
        v.addAttribute(new Attribute("missing_value", (Number)firstRay.getMissingData()));
        v.addAttribute(new Attribute("signal_below_threshold", (Number)firstRay.getDatatypeRangeFoldingThreshhold(abbrev)));
        v.addAttribute(new Attribute("scale_factor", (Number)Float.valueOf(firstRay.getDatatypeScaleFactor(abbrev))));
        v.addAttribute(new Attribute("add_offset", (Number)Float.valueOf(firstRay.getDatatypeAddOffset(abbrev))));
        v.addAttribute(new Attribute("range_folding_threshold", (Number)firstRay.getDatatypeRangeFoldingThreshhold(abbrev)));
        ArrayList<Dimension> dim2 = new ArrayList<Dimension>();
        dim2.add(scanDim);
        dim2.add(radialDim);
        String timeCoordName = "time" + abbrev;
        Variable timeVar = new Variable(ncfile, null, null, timeCoordName);
        timeVar.setDataType(DataType.INT);
        timeVar.setDimensions(dim2);
        ncfile.addVariable(null, timeVar);
        Date d = firstRay.getDate();
        String units = "msecs since " + this.formatter.toDateTimeStringISO(d);
        timeVar.addAttribute(new Attribute("long_name", "time since base date"));
        timeVar.addAttribute(new Attribute("units", units));
        timeVar.addAttribute(new Attribute("missing_value", (Number)firstRay.getMissingData()));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        String elevCoordName = "elevation" + abbrev;
        Variable elevVar = new Variable(ncfile, null, null, elevCoordName);
        elevVar.setDataType(DataType.FLOAT);
        elevVar.setDimensions(dim2);
        ncfile.addVariable(null, elevVar);
        elevVar.addAttribute(new Attribute("units", "degrees"));
        elevVar.addAttribute(new Attribute("long_name", "elevation angle in degrees: 0 = parallel to pedestal base, 90 = perpendicular"));
        elevVar.addAttribute(new Attribute("missing_value", (Number)firstRay.getMissingData()));
        elevVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
        String aziCoordName = "azimuth" + abbrev;
        Variable aziVar = new Variable(ncfile, null, null, aziCoordName);
        aziVar.setDataType(DataType.FLOAT);
        aziVar.setDimensions(dim2);
        ncfile.addVariable(null, aziVar);
        aziVar.addAttribute(new Attribute("units", "degrees"));
        aziVar.addAttribute(new Attribute("long_name", "azimuth angle in degrees: 0 = true north, 90 = east"));
        aziVar.addAttribute(new Attribute("missing_value", (Number)firstRay.getMissingData()));
        aziVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString()));
        String gateCoordName = "distance" + abbrev;
        Variable gateVar = new Variable(ncfile, null, null, gateCoordName);
        gateVar.setDataType(DataType.FLOAT);
        gateVar.setDimensions(gateDimName);
        Array data = Array.makeArray((DataType)DataType.FLOAT, (int)ngates, (double)firstRay.getGateStart(abbrev), (double)firstRay.getGateSize(abbrev));
        gateVar.setCachedData(data, false);
        ncfile.addVariable(null, gateVar);
        gateVar.addAttribute(new Attribute("units", "m"));
        gateVar.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        gateVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString()));
        String nradialsName = "numRadials" + abbrev;
        Variable nradialsVar = new Variable(ncfile, null, null, nradialsName);
        nradialsVar.setDataType(DataType.INT);
        nradialsVar.setDimensions(scanDim.getShortName());
        nradialsVar.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        ncfile.addVariable(null, nradialsVar);
        String ngateName = "numGates" + abbrev;
        Variable ngateVar = new Variable(ncfile, null, null, ngateName);
        ngateVar.setDataType(DataType.INT);
        ngateVar.setDimensions(scanDim.getShortName());
        ngateVar.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        ncfile.addVariable(null, ngateVar);
        this.makeCoordinateDataWithMissing(abbrev, timeVar, elevVar, aziVar, nradialsVar, ngateVar, groups);
        String coordinates = timeCoordName + " " + elevCoordName + " " + aziCoordName + " " + gateCoordName;
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        int nradials = radialDim.getLength();
        Ray[][] map = new Ray[nscans][nradials];
        for (int i = 0; i < groups.size(); ++i) {
            Ray[] mapScan = map[i];
            List<Ray> group = groups.get(i);
            int radial = 0;
            Iterator<Ray> iterator = group.iterator();
            while (iterator.hasNext()) {
                Ray r;
                mapScan[radial] = r = iterator.next();
                ++radial;
            }
        }
        Vgroup vg = new Vgroup(abbrev, map);
        v.setSPobject((Object)vg);
        return v;
    }

    private void makeCoordinateDataWithMissing(String abbrev, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List<List<Ray>> groups) {
        Array timeData = Array.factory((DataType)time.getDataType(), (int[])time.getShape());
        Index timeIndex = timeData.getIndex();
        Array elevData = Array.factory((DataType)elev.getDataType(), (int[])elev.getShape());
        Index elevIndex = elevData.getIndex();
        Array aziData = Array.factory((DataType)azi.getDataType(), (int[])azi.getShape());
        Index aziIndex = aziData.getIndex();
        Array nradialsData = Array.factory((DataType)nradialsVar.getDataType(), (int[])nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory((DataType)ngatesVar.getDataType(), (int[])ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        IndexIterator ii = timeData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setIntNext(-9999);
        }
        ii = elevData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        ii = aziData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        int nscans = groups.size();
        try {
            for (int scan = 0; scan < nscans; ++scan) {
                List<Ray> scanGroup = groups.get(scan);
                int nradials = scanGroup.size();
                int radial = 0;
                boolean needFirst = true;
                for (Ray r : scanGroup) {
                    if (needFirst) {
                        ngatesIter.setIntNext(r.getGateCount(abbrev));
                        needFirst = false;
                    }
                    timeData.setLong(timeIndex.set(scan, radial), r.data_msecs);
                    elevData.setFloat(elevIndex.set(scan, radial), r.getElevation());
                    aziData.setFloat(aziIndex.set(scan, radial), r.getAzimuth());
                    ++radial;
                }
                nradialsIter.setIntNext(nradials);
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException(ae);
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    public Array readData(Variable v2, Section section) throws IOException {
        Vgroup vgroup = (Vgroup)v2.getSPobject();
        Range scanRange = section.getRange(0);
        Range radialRange = section.getRange(1);
        Range gateRange = section.getRange(2);
        Array data = Array.factory((DataType)v2.getDataType(), (int[])section.getShape());
        IndexIterator ii = data.getIndexIterator();
        Iterator iterator = scanRange.iterator();
        while (iterator.hasNext()) {
            int scanIdx = (Integer)iterator.next();
            Ray[] mapScan = vgroup.map[scanIdx];
            this.readOneScan(mapScan, radialRange, gateRange, vgroup.abbrev, ii);
        }
        return data;
    }

    private void readOneScan(Ray[] mapScan, Range radialRange, Range gateRange, String abbrev, IndexIterator ii) throws IOException {
        Iterator iterator = radialRange.iterator();
        while (iterator.hasNext()) {
            int radialIdx = (Integer)iterator.next();
            Ray r = mapScan[radialIdx];
            this.readOneRadial(r, abbrev, gateRange, ii);
        }
    }

    private void readOneRadial(Ray r, String abbrev, Range gateRange, IndexIterator ii) throws IOException {
        if (r == null) {
            for (int i = 0; i < gateRange.length(); ++i) {
                ii.setShortNext(this.headerParser.getMissingData());
            }
            return;
        }
        r.readData(this.raf, abbrev, gateRange, ii);
    }

    private static class Vgroup {
        Ray[][] map;
        String abbrev;

        Vgroup(String abbrev, Ray[][] map) {
            this.abbrev = abbrev;
            this.map = map;
        }
    }
}

