/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.sigmet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.sigmet.Ray;
import ucar.nc2.iosp.sigmet.SigmetVolumeScan;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class SigmetIOServiceProvider
extends AbstractIOServiceProvider {
    private static Logger logger = LoggerFactory.getLogger(SigmetIOServiceProvider.class);
    public static String RAW_VARIABLE_PREFIX = "raw_";
    private ArrayList<Variable> varList;
    private int[] tsu_sec;
    private int[] sweep_bins;
    private String date0;
    public static Map<String, Number> recHdr = new HashMap<String, Number>();
    private SigmetVolumeScan volScan;

    public String getFileTypeDescription() {
        return "SIGMET-IRIS";
    }

    public String getFileTypeVersion() {
        return "SIGMET-IRIS";
    }

    public String getFileTypeId() {
        return "SIGMET";
    }

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.order(1);
            raf.seek(0L);
            short[] data = new short[13];
            raf.readShort(data, 0, 13);
            return data[0] == 27 && data[6] == 26 && data[12] == 15;
        }
        catch (IOException ioe) {
            logger.info("In isValidFile(): " + ioe);
            return false;
        }
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        HashMap<String, String> hdrNames = new HashMap<String, String>();
        this.volScan = new SigmetVolumeScan(raf);
        this.varList = this.init(raf, ncfile, hdrNames);
    }

    public static Map<String, Number> readRecordsHdr(RandomAccessFile raf) {
        HashMap<String, Number> recHdr1 = new HashMap<String, Number>();
        try {
            int j;
            int nparams = 0;
            raf.seek(452L);
            int prf = raf.readInt();
            raf.seek(480L);
            int wave = raf.readInt();
            float vNyq = SigmetIOServiceProvider.calcNyquist(prf, wave);
            recHdr1.put("vNyq", Float.valueOf(vNyq));
            raf.seek(6324L);
            int radar_lat = raf.readInt();
            int radar_lon = raf.readInt();
            short ground_height = raf.readShort();
            short radar_height = raf.readShort();
            raf.skipBytes(4);
            short num_rays = raf.readShort();
            raf.skipBytes(2);
            int radar_alt = raf.readInt();
            raf.seek(6648L);
            int time_beg = raf.readInt();
            raf.seek(6652L);
            int time_end = raf.readInt();
            raf.seek(6772L);
            int data_mask = raf.readInt();
            for (j = 0; j < 32; ++j) {
                nparams += data_mask >> j & 1;
            }
            raf.readInt();
            data_mask = raf.readInt();
            for (j = 0; j < 32; ++j) {
                nparams += data_mask >> j & 1;
            }
            data_mask = raf.readInt();
            for (j = 0; j < 32; ++j) {
                nparams += data_mask >> j & 1;
            }
            data_mask = raf.readInt();
            for (j = 0; j < 32; ++j) {
                nparams += data_mask >> j & 1;
            }
            data_mask = raf.readInt();
            for (j = 0; j < 32; ++j) {
                nparams += data_mask >> j & 1;
            }
            raf.seek(6912L);
            short multiprf = raf.readShort();
            raf.seek(7408L);
            int range_first = raf.readInt();
            int range_last = raf.readInt();
            raf.skipBytes(2);
            short bins = raf.readShort();
            if (bins % 2 != 0) {
                bins = (short)(bins + 1);
            }
            raf.skipBytes(4);
            int step = raf.readInt();
            raf.seek(7574L);
            short number_sweeps = raf.readShort();
            raf.seek(12312L);
            int base_time = raf.readInt();
            raf.skipBytes(2);
            short year = raf.readShort();
            short month = raf.readShort();
            short day = raf.readShort();
            recHdr1.put("radar_lat", Float.valueOf(SigmetIOServiceProvider.calcAngle(radar_lat)));
            recHdr1.put("radar_lon", Float.valueOf(SigmetIOServiceProvider.calcAngle(radar_lon)));
            recHdr1.put("range_first", range_first);
            recHdr1.put("range_last", range_last);
            recHdr1.put("ground_height", ground_height);
            recHdr1.put("radar_height", radar_height);
            recHdr1.put("radar_alt", radar_alt);
            recHdr1.put("step", step);
            recHdr1.put("bins", bins);
            recHdr1.put("num_rays", num_rays);
            recHdr1.put("nparams", nparams);
            recHdr1.put("multiprf", multiprf);
            recHdr1.put("number_sweeps", number_sweeps);
            recHdr1.put("year", year);
            recHdr1.put("month", month);
            recHdr1.put("day", day);
            recHdr1.put("base_time", base_time);
        }
        catch (Exception e) {
            logger.warn("readRecordsHdr", (Throwable)e);
        }
        return recHdr1;
    }

    public Map<String, String> readStnNames(RandomAccessFile raf) {
        HashMap<String, String> hdrNames = new HashMap<String, String>();
        try {
            raf.seek(6288L);
            String stnName = raf.readString(16);
            raf.seek(6306L);
            String stnName_util = raf.readString(16);
            hdrNames.put("StationName", stnName.trim());
            hdrNames.put("StationName_SetupUtility", stnName_util.trim());
        }
        catch (Exception e) {
            logger.warn("readStnNames", (Throwable)e);
        }
        return hdrNames;
    }

    public ArrayList<Variable> init(RandomAccessFile raf, NetcdfFile ncfile, Map<String, String> hdrNames) {
        int j;
        String[] data_name = SigmetVolumeScan.data_name;
        String[] unit = SigmetVolumeScan.data_unit;
        String def_datafile = "SIGMET-IRIS";
        String tim = "";
        boolean ngates = false;
        recHdr = SigmetIOServiceProvider.readRecordsHdr(raf);
        hdrNames = this.readStnNames(raf);
        String stnName = hdrNames.get("StationName");
        String stnName_util = hdrNames.get("StationName_SetupUtility");
        float radar_lat = recHdr.get("radar_lat").floatValue();
        float radar_lon = recHdr.get("radar_lon").floatValue();
        short ground_height = recHdr.get("ground_height").shortValue();
        short radar_height = recHdr.get("radar_height").shortValue();
        int radar_alt = recHdr.get("radar_alt").intValue() / 100;
        short num_rays = recHdr.get("num_rays").shortValue();
        short bins = recHdr.get("bins").shortValue();
        float range_first = (float)recHdr.get("range_first").intValue() * 0.01f;
        float range_last = (float)recHdr.get("range_last").intValue() * 0.01f;
        int number_sweeps = recHdr.get("number_sweeps").shortValue();
        int nparams = recHdr.get("nparams").intValue();
        short year = recHdr.get("year").shortValue();
        short month = recHdr.get("month").shortValue();
        short day = recHdr.get("day").shortValue();
        int base_time = recHdr.get("base_time").intValue();
        this.sweep_bins = new int[nparams * number_sweeps];
        if (number_sweeps > 1) {
            this.sweep_bins = this.volScan.getNumberGates();
        } else {
            for (int kk = 0; kk < nparams; ++kk) {
                this.sweep_bins[kk] = bins;
            }
        }
        Dimension scanR = new Dimension("scanR", number_sweeps);
        Dimension radial = new Dimension("radial", (int)num_rays);
        Dimension[] gateR = new Dimension[number_sweeps];
        String dim_name = "gateR";
        for (j = 0; j < number_sweeps; ++j) {
            if (number_sweeps > 1) {
                dim_name = "gateR_sweep_" + (j + 1);
            }
            gateR[j] = new Dimension(dim_name, this.sweep_bins[j]);
        }
        ncfile.addDimension(null, scanR);
        ncfile.addDimension(null, radial);
        for (j = 0; j < number_sweeps; ++j) {
            ncfile.addDimension(null, gateR[j]);
        }
        ArrayList<Dimension> dims0 = new ArrayList<Dimension>();
        ArrayList<Dimension> dims1 = new ArrayList<Dimension>();
        ArrayList<Dimension> dims2 = new ArrayList<Dimension>();
        ArrayList<Dimension> dims3 = new ArrayList<Dimension>();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        short[] dataTypes = this.volScan.getDataTypes();
        Variable[][] v = new Variable[nparams][number_sweeps];
        for (int j2 = 0; j2 < nparams; ++j2) {
            short dty = dataTypes[j2];
            String var_name_original = data_name[dty];
            if (dty == 6 || dty > 11) {
                var_name_original = RAW_VARIABLE_PREFIX + var_name_original;
            }
            String var_name = var_name_original;
            int bytesPerBin = 1;
            List<List<Ray>> allRays = this.volScan.getGroup(data_name[dty]);
            if (allRays != null && allRays.size() > 0 && allRays.get(0) != null && allRays.get(0).size() > 0 && allRays.get(0).get(0) != null) {
                bytesPerBin = allRays.get(0).get(0).getBytesPerBin();
            }
            DataType dType = SigmetIOServiceProvider.calcDataType(dty, bytesPerBin);
            Number missingVal = null;
            switch (dType) {
                case FLOAT: {
                    missingVal = Float.valueOf(-999.99f);
                    break;
                }
                case DOUBLE: {
                    missingVal = -999.99;
                    break;
                }
                case BYTE: {
                    missingVal = (byte)0;
                }
            }
            for (int jj = 0; jj < number_sweeps; ++jj) {
                if (number_sweeps > 1) {
                    var_name = var_name_original + "_sweep_" + (jj + 1);
                }
                Variable.Builder builder = Variable.builder().setNcfile(ncfile).setName(var_name).setDataType(dType);
                Attribute.Builder attr = Attribute.builder().setName("missing_value");
                if (missingVal != null) {
                    attr.setNumericValue(missingVal, false);
                } else {
                    attr.setValues(SigmetVolumeScan.MISSING_VALUE_BYTE_ARRAY);
                }
                builder.addAttribute(attr.build());
                dims2.add(radial);
                dims2.add(gateR[jj]);
                builder.setDimensions(dims2).addAttribute(new Attribute("long_name", var_name)).addAttribute(new Attribute("units", unit[dty])).addAttribute(new Attribute("_CoordinateAxes", "time elevationR azimuthR distanceR"));
                v[j2][jj] = builder.build(ncfile.getRootGroup());
                ncfile.addVariable(null, v[j2][jj]);
                varList.add(v[j2][jj]);
                dims2.clear();
            }
        }
        this.tsu_sec = new int[number_sweeps];
        String[] tsu = new String[number_sweeps];
        String[] time_units = new String[number_sweeps];
        this.tsu_sec = this.volScan.getStartSweep();
        for (int i = 0; i < number_sweeps; ++i) {
            String st2;
            String st1 = Short.toString(month);
            if (st1.length() < 2) {
                st1 = "0" + st1;
            }
            if ((st2 = Short.toString(day)).length() < 2) {
                st2 = "0" + st2;
            }
            this.date0 = year + "-" + st1 + "-" + st2;
            tsu[i] = this.date0 + "T" + SigmetIOServiceProvider.calcTime(this.tsu_sec[i], 0) + "Z";
        }
        for (int j3 = 0; j3 < number_sweeps; ++j3) {
            time_units[j3] = "secs since " + tsu[j3];
        }
        dims0.add(radial);
        Variable[] time = new Variable[number_sweeps];
        String tm = "time";
        for (int j4 = 0; j4 < number_sweeps; ++j4) {
            String tm_name = tm;
            if (number_sweeps > 1) {
                tm_name = tm + "_sweep_" + (j4 + 1);
            }
            time[j4] = new Variable(ncfile, null, null, tm_name);
            time[j4].setDataType(DataType.INT);
            time[j4].setDimensions(dims0);
            time[j4].addAttribute(new Attribute("long_name", "time from start of sweep"));
            time[j4].addAttribute(new Attribute("units", time_units[j4]));
            time[j4].addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            time[j4].addAttribute(new Attribute("missing_value", (Number)-99));
            ncfile.addVariable(null, time[j4]);
            varList.add(time[j4]);
        }
        Variable[] elevationR = new Variable[number_sweeps];
        String ele = "elevationR";
        for (int j5 = 0; j5 < number_sweeps; ++j5) {
            String ele_name = ele;
            if (number_sweeps > 1) {
                ele_name = ele + "_sweep_" + (j5 + 1);
            }
            elevationR[j5] = new Variable(ncfile, null, null, ele_name);
            elevationR[j5].setDataType(DataType.FLOAT);
            elevationR[j5].setDimensions(dims0);
            elevationR[j5].addAttribute(new Attribute("long_name", "elevation angle"));
            elevationR[j5].addAttribute(new Attribute("units", "degrees"));
            elevationR[j5].addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
            elevationR[j5].addAttribute(new Attribute("missing_value", (Number)Float.valueOf(-999.99f)));
            ncfile.addVariable(null, elevationR[j5]);
            varList.add(elevationR[j5]);
        }
        Variable[] azimuthR = new Variable[number_sweeps];
        String azim = "azimuthR";
        for (int j6 = 0; j6 < number_sweeps; ++j6) {
            String azim_name = azim;
            if (number_sweeps > 1) {
                azim_name = azim + "_sweep_" + (j6 + 1);
            }
            azimuthR[j6] = new Variable(ncfile, null, null, azim_name);
            azimuthR[j6].setDataType(DataType.FLOAT);
            azimuthR[j6].setDimensions(dims0);
            azimuthR[j6].addAttribute(new Attribute("long_name", "azimuth angle"));
            azimuthR[j6].addAttribute(new Attribute("units", "degrees"));
            azimuthR[j6].addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString()));
            azimuthR[j6].addAttribute(new Attribute("missing_value", (Number)Float.valueOf(-999.99f)));
            ncfile.addVariable(null, azimuthR[j6]);
            varList.add(azimuthR[j6]);
        }
        Variable[] distanceR = new Variable[number_sweeps];
        String dName = "distanceR";
        for (int j7 = 0; j7 < number_sweeps; ++j7) {
            String dist_name = dName;
            if (number_sweeps > 1) {
                dist_name = dName + "_sweep_" + (j7 + 1);
            }
            distanceR[j7] = new Variable(ncfile, null, null, dist_name);
            distanceR[j7].setDataType(DataType.FLOAT);
            dims1.add(gateR[j7]);
            distanceR[j7].setDimensions(dims1);
            distanceR[j7].addAttribute(new Attribute("long_name", "radial distance"));
            distanceR[j7].addAttribute(new Attribute("units", "m"));
            distanceR[j7].addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString()));
            ncfile.addVariable(null, distanceR[j7]);
            varList.add(distanceR[j7]);
            dims1.clear();
        }
        dims3.add(scanR);
        Variable numGates = new Variable(ncfile, null, null, "numGates");
        numGates.setDataType(DataType.INT);
        numGates.setDimensions(dims3);
        numGates.addAttribute(new Attribute("long_name", "number of gates in the sweep"));
        ncfile.addVariable(null, numGates);
        varList.add(numGates);
        ncfile.addAttribute(null, new Attribute("definition", "SIGMET-IRIS RAW"));
        ncfile.addAttribute(null, new Attribute("description", "SIGMET-IRIS data are reading by Netcdf IOSP"));
        ncfile.addAttribute(null, new Attribute("StationName", stnName));
        ncfile.addAttribute(null, new Attribute("StationName_SetupUtility", stnName_util));
        ncfile.addAttribute(null, new Attribute("radar_lat", (Number)Float.valueOf(radar_lat)));
        ncfile.addAttribute(null, new Attribute("radar_lon", (Number)Float.valueOf(radar_lon)));
        ncfile.addAttribute(null, new Attribute("ground_height", (Number)ground_height));
        ncfile.addAttribute(null, new Attribute("radar_height", (Number)radar_height));
        ncfile.addAttribute(null, new Attribute("radar_alt", (Number)radar_alt));
        ncfile.addAttribute(null, new Attribute("num_data_types", (Number)nparams));
        ncfile.addAttribute(null, new Attribute("number_sweeps", (Number)((short)number_sweeps)));
        String sn = "start_sweep";
        for (int j8 = 0; j8 < number_sweeps; ++j8) {
            String snn = sn;
            if (number_sweeps > 1) {
                snn = sn + "_" + (j8 + 1);
            }
            ncfile.addAttribute(null, new Attribute(snn, tsu[j8]));
        }
        ncfile.addAttribute(null, new Attribute("num_rays", (Number)num_rays));
        ncfile.addAttribute(null, new Attribute("max_number_gates", (Number)bins));
        ncfile.addAttribute(null, new Attribute("range_first", (Number)Float.valueOf(range_first)));
        ncfile.addAttribute(null, new Attribute("range_last", (Number)Float.valueOf(range_last)));
        ncfile.addAttribute(null, new Attribute("DataType", "Radial"));
        ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        this.doNetcdfFileCoordinate(ncfile, this.volScan.base_time, this.volScan.year, this.volScan.month, this.volScan.day, varList, recHdr);
        ncfile.finish();
        return varList;
    }

    public void doNetcdfFileCoordinate(NetcdfFile ncfile, int[] bst, short[] yr, short[] m, short[] dda, ArrayList<Variable> varList, Map<String, Number> recHdr) {
        String sss22;
        String sss2;
        int num_rays = recHdr.get("num_rays").shortValue();
        float range_first = (float)recHdr.get("range_first").intValue() * 0.01f;
        float range_last = (float)recHdr.get("range_last").intValue() * 0.01f;
        int number_sweeps = recHdr.get("number_sweeps").shortValue();
        int nparams = recHdr.get("nparams").intValue();
        int last_t = this.volScan.lastRay.getTime();
        String sss1 = Short.toString(m[0]);
        if (sss1.length() < 2) {
            sss1 = "0" + sss1;
        }
        if ((sss2 = Short.toString(dda[0])).length() < 2) {
            sss2 = "0" + sss2;
        }
        String base_date0 = yr[0] + "-" + sss1 + "-" + sss2;
        String sss11 = Short.toString(m[number_sweeps - 1]);
        if (sss11.length() < 2) {
            sss11 = "0" + sss11;
        }
        if ((sss22 = Short.toString(dda[number_sweeps - 1])).length() < 2) {
            sss22 = "0" + sss22;
        }
        String base_date1 = yr[number_sweeps - 1] + "-" + sss11 + "-" + sss22;
        String start_time = base_date0 + "T" + SigmetIOServiceProvider.calcTime(bst[0], 0) + "Z";
        String end_time = base_date1 + "T" + SigmetIOServiceProvider.calcTime(bst[number_sweeps - 1], last_t) + "Z";
        ncfile.addAttribute(null, new Attribute("time_coverage_start", start_time));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", end_time));
        try {
            int i;
            int ngates;
            Ray[] rtemp = new Ray[num_rays];
            Variable[] distanceR = new Variable[number_sweeps];
            ArrayFloat.D1[] distArr = new ArrayFloat.D1[number_sweeps];
            Index[] distIndex = new Index[number_sweeps];
            String distName = "distanceR";
            for (int i2 = 0; i2 < number_sweeps; ++i2) {
                if (number_sweeps > 1) {
                    distName = "distanceR_sweep_" + (i2 + 1);
                }
                for (Variable aVarList : varList) {
                    if (!aVarList.getShortName().equals(distName.trim())) continue;
                    distanceR[i2] = aVarList;
                    break;
                }
                distArr[i2] = (ArrayFloat.D1)Array.factory((DataType)DataType.FLOAT, (int[])distanceR[i2].getShape());
                distIndex[i2] = distArr[i2].getIndex();
                ngates = this.sweep_bins[i2];
                float stp = SigmetIOServiceProvider.calcStep(range_first, range_last, (short)ngates);
                for (int ii = 0; ii < ngates; ++ii) {
                    distArr[i2].setFloat(distIndex[i2].set(ii), range_first + (float)ii * stp);
                }
            }
            List<List<Ray>> rgp = this.volScan.getGroup("TotalPower");
            if (rgp == null || rgp.isEmpty()) {
                rgp = this.volScan.getGroup("TotalPower_2");
            }
            if (rgp == null || rgp.isEmpty()) {
                rgp = this.volScan.getGroup("Reflectivity");
            }
            if (rgp == null || rgp.isEmpty()) {
                rgp = this.volScan.getGroup("Reflectivity_2");
            }
            ArrayList[] sgp = new ArrayList[number_sweeps];
            for (int sweepMinus1 = 0; sweepMinus1 < number_sweeps; ++sweepMinus1) {
                List<Ray> found = null;
                for (int i3 = 0; i3 < rgp.size() && found == null; ++i3) {
                    Ray r;
                    List<Ray> rlist = rgp.get(i3);
                    if (rlist.size() <= 0 || (r = rlist.get(0)).getNsweep() != sweepMinus1 + 1) continue;
                    found = rlist;
                }
                sgp[sweepMinus1] = found;
            }
            Variable[] time = new Variable[number_sweeps];
            ArrayInt.D1[] timeArr = new ArrayInt.D1[number_sweeps];
            Index[] timeIndex = new Index[number_sweeps];
            String t_n = "time";
            for (int i4 = 0; i4 < number_sweeps; ++i4) {
                int jj;
                if (number_sweeps > 1) {
                    t_n = "time_sweep_" + (i4 + 1);
                }
                for (Variable aVarList : varList) {
                    if (!aVarList.getShortName().equals(t_n.trim())) continue;
                    time[i4] = aVarList;
                    break;
                }
                timeArr[i4] = (ArrayInt.D1)Array.factory((DataType)DataType.INT, (int[])time[i4].getShape());
                timeIndex[i4] = timeArr[i4].getIndex();
                ArrayList rlist = sgp[i4];
                if (rlist == null) {
                    for (int jj2 = 0; jj2 < num_rays; ++jj2) {
                        timeArr[i4].setInt(timeIndex[i4].set(jj2), -999);
                    }
                    continue;
                }
                int num_rays_actual = Math.min(num_rays, rlist.size());
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    rtemp[jj] = (Ray)rlist.get(jj);
                }
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    timeArr[i4].setInt(timeIndex[i4].set(jj), rtemp[jj].getTime());
                }
            }
            Variable[] azimuthR = new Variable[number_sweeps];
            ArrayFloat.D1[] azimArr = new ArrayFloat.D1[number_sweeps];
            Index[] azimIndex = new Index[number_sweeps];
            String azimName = "azimuthR";
            for (int i5 = 0; i5 < number_sweeps; ++i5) {
                int jj;
                if (number_sweeps > 1) {
                    azimName = "azimuthR_sweep_" + (i5 + 1);
                }
                for (Variable aVarList : varList) {
                    if (!aVarList.getShortName().equals(azimName.trim())) continue;
                    azimuthR[i5] = aVarList;
                    break;
                }
                azimArr[i5] = (ArrayFloat.D1)Array.factory((DataType)DataType.FLOAT, (int[])azimuthR[i5].getShape());
                azimIndex[i5] = azimArr[i5].getIndex();
                ArrayList rlist = sgp[i5];
                if (rlist == null) {
                    for (int jj3 = 0; jj3 < num_rays; ++jj3) {
                        azimArr[i5].setFloat(azimIndex[i5].set(jj3), -999.99f);
                    }
                    continue;
                }
                int num_rays_actual = Math.min(num_rays, rlist.size());
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    rtemp[jj] = (Ray)rlist.get(jj);
                }
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    azimArr[i5].setFloat(azimIndex[i5].set(jj), rtemp[jj].getAz());
                }
            }
            Variable[] elevationR = new Variable[number_sweeps];
            ArrayFloat.D1[] elevArr = new ArrayFloat.D1[number_sweeps];
            Index[] elevIndex = new Index[number_sweeps];
            String elevName = "elevationR";
            for (int i6 = 0; i6 < number_sweeps; ++i6) {
                int jj;
                if (number_sweeps > 1) {
                    elevName = "elevationR_sweep_" + (i6 + 1);
                }
                for (Variable aVarList : varList) {
                    if (!aVarList.getShortName().equals(elevName.trim())) continue;
                    elevationR[i6] = aVarList;
                    break;
                }
                elevArr[i6] = (ArrayFloat.D1)Array.factory((DataType)DataType.FLOAT, (int[])elevationR[i6].getShape());
                elevIndex[i6] = elevArr[i6].getIndex();
                ArrayList rlist = sgp[i6];
                if (rlist == null) {
                    for (int jj4 = 0; jj4 < num_rays; ++jj4) {
                        elevArr[i6].setFloat(elevIndex[i6].set(jj4), -999.99f);
                    }
                    continue;
                }
                int num_rays_actual = Math.min(num_rays, rlist.size());
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    rtemp[jj] = (Ray)rlist.get(jj);
                }
                for (jj = 0; jj < num_rays_actual; ++jj) {
                    elevArr[i6].setFloat(elevIndex[i6].set(jj), rtemp[jj].getElev());
                }
            }
            Variable numGates = null;
            block22: for (int i7 = 0; i7 < number_sweeps; ++i7) {
                for (Variable aVarList : varList) {
                    if (!aVarList.getShortName().equals("numGates")) continue;
                    numGates = aVarList;
                    continue block22;
                }
            }
            ArrayInt.D1 gatesArr = (ArrayInt.D1)Array.factory((DataType)DataType.INT, (int[])numGates.getShape());
            Index gatesIndex = gatesArr.getIndex();
            for (i = 0; i < number_sweeps; ++i) {
                ArrayList rlist = sgp[i];
                if (rlist == null) {
                    gatesArr.setInt(gatesIndex.set(i), -999);
                    continue;
                }
                int num_rays_actual = Math.min(num_rays, rlist.size());
                for (int jj = 0; jj < num_rays_actual; ++jj) {
                    rtemp[jj] = (Ray)rlist.get(jj);
                }
                ngates = rtemp[0].getBins();
                gatesArr.setInt(gatesIndex.set(i), ngates);
            }
            for (i = 0; i < number_sweeps; ++i) {
                distanceR[i].setCachedData((Array)distArr[i], false);
                time[i].setCachedData((Array)timeArr[i], false);
                azimuthR[i].setCachedData((Array)azimArr[i], false);
                elevationR[i].setCachedData((Array)elevArr[i], false);
            }
            numGates.setCachedData((Array)gatesArr, false);
        }
        catch (Exception e) {
            logger.error("doNetcdfFileCoordinate", (Throwable)e);
        }
    }

    public Array readData1(Variable v2, Section section) throws IOException, InvalidRangeException {
        int[] sh = section.getShape();
        Array temp = Array.factory((DataType)v2.getDataType(), (int[])sh);
        long pos0 = 0L;
        LayoutRegular index = new LayoutRegular(pos0, v2.getElementSize(), v2.getShape(), section);
        temp = v2.getShortName().startsWith("time") | v2.getShortName().startsWith("numGates") ? this.readIntData(index, v2) : this.readFloatData(index, v2);
        return temp;
    }

    public Array readData(Variable v2, Section section) throws IOException {
        List<List<Ray>> groups;
        Array data = Array.factory((DataType)v2.getDataType(), (int[])section.getShape());
        IndexIterator ii = data.getIndexIterator();
        String shortName = v2.getShortName();
        String groupName = shortName;
        int posSweep = groupName.indexOf("_sweep_");
        if (posSweep > 0) {
            groupName = groupName.substring(0, posSweep);
        }
        if (groupName.startsWith(RAW_VARIABLE_PREFIX)) {
            groupName = groupName.substring(RAW_VARIABLE_PREFIX.length());
        }
        if ((groups = this.volScan.getGroup(groupName)) == null) {
            throw new IllegalStateException("Illegal variable name = " + shortName);
        }
        if (section.getRank() == 2) {
            Range radialRange = section.getRange(0);
            Range gateRange = section.getRange(1);
            List<Ray> lli = groups.get(0);
            this.readOneScan(lli, radialRange, gateRange, ii);
        } else {
            Range scanRange = section.getRange(0);
            Range radialRange = section.getRange(1);
            Range gateRange = section.getRange(2);
            Iterator iterator = scanRange.iterator();
            while (iterator.hasNext()) {
                int scanIdx = (Integer)iterator.next();
                this.readOneScan(groups.get(scanIdx), radialRange, gateRange, ii);
            }
        }
        return data;
    }

    private void readOneScan(List<Ray> mapScan, Range radialRange, Range gateRange, IndexIterator ii) throws IOException {
        int siz = mapScan.size();
        short dataType = 1;
        int bytesPerBin = 1;
        Iterator iterator = radialRange.iterator();
        while (iterator.hasNext()) {
            int radialIdx = (Integer)iterator.next();
            if (radialIdx >= siz) {
                this.readOneRadialMissing(dataType, bytesPerBin, gateRange, ii);
                continue;
            }
            Ray r = mapScan.get(radialIdx);
            dataType = r.datatype;
            bytesPerBin = r.bytesPerBin;
            this.readOneRadial(r, gateRange, ii);
        }
    }

    private void readOneRadial(Ray r, Range gateRange, IndexIterator ii) throws IOException {
        r.readData(this.volScan.raf, gateRange, ii);
    }

    private void readOneRadialMissing(short datatype, int bytesPerBin, Range gateRange, IndexIterator ii) {
        DataType dType = SigmetIOServiceProvider.calcDataType(datatype, bytesPerBin);
        switch (dType) {
            case FLOAT: {
                for (int i = 0; i < gateRange.length(); ++i) {
                    ii.setFloatNext(Float.NaN);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < gateRange.length(); ++i) {
                    ii.setDoubleNext(Double.NaN);
                }
                break;
            }
            case BYTE: {
                for (int i = 0; i < gateRange.length(); ++i) {
                    ii.setByteNext((byte)0);
                }
                break;
            }
            default: {
                for (int i = 0; i < gateRange.length(); ++i) {
                    ii.setObjectNext((Object)SigmetVolumeScan.MISSING_VALUE_BYTE_ARRAY_BB);
                }
            }
        }
    }

    public Array readIntData(LayoutRegular index, Variable v2) throws IOException {
        int[] var = (int[])v2.read().get1DJavaArray(v2.getDataType());
        int[] data = new int[(int)index.getTotalNelems()];
        while (index.hasNext()) {
            Layout.Chunk chunk = index.next();
            System.arraycopy(var, (int)chunk.getSrcPos() / 4, data, (int)chunk.getDestElem(), chunk.getNelems());
        }
        return Array.factory((DataType)v2.getDataType(), (int[])new int[]{(int)index.getTotalNelems()}, (Object)data);
    }

    public Array readFloatData(LayoutRegular index, Variable v2) throws IOException {
        float[] var = (float[])v2.read().get1DJavaArray(v2.getDataType().getPrimitiveClassType());
        float[] data = new float[(int)index.getTotalNelems()];
        while (index.hasNext()) {
            Layout.Chunk chunk = index.next();
            System.arraycopy(var, (int)chunk.getSrcPos() / 4, data, (int)chunk.getDestElem(), chunk.getNelems());
        }
        return Array.factory((DataType)v2.getDataType(), (int[])new int[]{(int)index.getTotalNelems()}, (Object)data);
    }

    public long readToByteChannel11(Variable v2, Section section, WritableByteChannel channel) throws IOException {
        Array data = this.readData(v2, section);
        float[] ftdata = new float[(int)data.getSize()];
        byte[] bytedata = new byte[(int)data.getSize() * 4];
        IndexIterator iter = data.getIndexIterator();
        int i = 0;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytedata.length);
        while (iter.hasNext()) {
            ftdata[i] = iter.getFloatNext();
            bytedata[i] = new Float(ftdata[i]).byteValue();
            buffer.put(bytedata[i]);
            ++i;
        }
        buffer = ByteBuffer.wrap(bytedata);
        int count = channel.write(buffer);
        if (buffer.hasRemaining()) {
            buffer.compact();
        } else {
            buffer.clear();
        }
        return count;
    }

    static float calcAngle(short angle) {
        double maxval = 65536.0;
        double ang = angle;
        if (ang < 0.0) {
            ang = maxval + ang;
        }
        double temp = ang / maxval * 360.0;
        BigDecimal bd = new BigDecimal(temp);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static float calcAngle(int ang) {
        double maxval = 4.294967296E9;
        double temp = (double)ang / maxval * 360.0;
        BigDecimal bd = new BigDecimal(temp);
        BigDecimal result = bd.setScale(3, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static float calcElev(short angle) {
        double maxval = 65536.0;
        double ang = angle;
        if (angle < 0) {
            ang = ~angle + 1;
        }
        double temp = ang / maxval * 360.0;
        BigDecimal bd = new BigDecimal(temp);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static float calcStep(float range_first, float range_last, short num_bins) {
        float step = (range_last - range_first) / (float)(num_bins - 1);
        BigDecimal bd = new BigDecimal(step);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static float calcAz(short az0, short az1) {
        double temp;
        float azim0 = SigmetIOServiceProvider.calcAngle(az0);
        float azim1 = SigmetIOServiceProvider.calcAngle(az1);
        float d = Math.abs(azim0 - azim1);
        if (az0 < 0 & az1 > 0) {
            d = Math.abs(360.0f - azim0) + Math.abs(azim1);
        }
        if ((temp = (double)azim0 + (double)d * 0.5) > 360.0) {
            temp -= 360.0;
        }
        BigDecimal bd = new BigDecimal(temp);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static DataType calcDataType(short dty, int bytes) {
        switch (dty) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return DataType.FLOAT;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return DataType.DOUBLE;
            }
        }
        if (bytes == 1) {
            return DataType.BYTE;
        }
        return DataType.OPAQUE;
    }

    static float calcData(Map<String, Number> recHdr, short dty, byte data) {
        short[] coef = new short[]{1, 2, 3, 4};
        short multiprf = recHdr.get("multiprf").shortValue();
        float vNyq = recHdr.get("vNyq").floatValue();
        double temp = -999.99f;
        switch (dty) {
            case 1: 
            case 2: {
                if (data == 0 || data == -1) break;
                temp = (double)((data & 0xFF) - 64) * 0.5;
                break;
            }
            case 3: {
                if (data == 0) break;
                temp = (double)((data & 0xFF) - 128) / 127.0 * (double)vNyq * (double)coef[multiprf];
                break;
            }
            case 4: {
                if (data == 0 || data == -1) break;
                double v = (double)((data & 0xFF) - 128) / 127.0 * (double)vNyq * (double)coef[multiprf];
                temp = (double)(data & 0xFF) / 256.0 * v;
                break;
            }
            case 5: {
                if (data == 0 || data == -1) break;
                temp = (double)((data & 0xFF) - 128) / 16.0;
                break;
            }
            default: {
                temp = data & 0xFF;
                BigDecimal bd = new BigDecimal(temp);
                return bd.floatValue();
            }
        }
        BigDecimal bd = new BigDecimal(temp);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }

    static double calcData(Map<String, Number> recHdr, short dty, int data) {
        double temp = -999.99;
        switch (dty) {
            case 7: 
            case 8: {
                if (data == 0 || data == 65535) break;
                temp = (double)(data - 32768) / 100.0;
                break;
            }
            case 9: {
                if (data == 0 || data == 65535) break;
                temp = (double)(data - 32768) / 100.0;
                break;
            }
            case 10: {
                if (data == 0 || data == 65535) break;
                temp = (double)data / 100.0;
                break;
            }
            case 11: {
                if (data == 0 || data == 65535) break;
                temp = (double)(data - 32768) / 100.0;
                break;
            }
            default: {
                temp = data;
            }
        }
        BigDecimal bd = new BigDecimal(temp);
        return bd.doubleValue();
    }

    static String calcTime(int t, int t0) {
        StringBuilder tim = new StringBuilder();
        int[] tt = new int[3];
        int mmh = (t + t0) / 60;
        tt[2] = (t + t0) % 60;
        tt[0] = mmh / 60;
        tt[1] = mmh % 60;
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toString(tt[i]);
            int len = s.length();
            if (len < 2) {
                s = "0" + tt[i];
            }
            if (i != 2) {
                s = s + ":";
            }
            tim.append(s);
        }
        return tim.toString();
    }

    static float calcNyquist(int prf, int wave) {
        double tmp = (double)(prf * wave) * 0.01 * 0.25;
        BigDecimal bd = new BigDecimal(tmp *= 0.01);
        BigDecimal result = bd.setScale(2, RoundingMode.HALF_DOWN);
        return result.floatValue();
    }
}

