/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.s3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.ReadableRemoteFile;
import ucar.unidata.io.RemoteRandomAccessFile;
import ucar.unidata.io.s3.AmazonS3URI;
import ucar.unidata.io.spi.RandomAccessFileProvider;

public final class S3RandomAccessFile
extends RemoteRandomAccessFile
implements ReadableRemoteFile,
Closeable {
    private static final int s3BufferSize = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.bufferSize", String.valueOf(262144)));
    private static final int s3MaxReadCacheSize = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.maxReadCacheSize", String.valueOf(0xA00000)));
    private static final int maxConnections = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.httpMaxConnections", "128"));
    private static final int connectionTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.connectionTimeout", String.valueOf(10000)));
    private static final int socketTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.socketTimeout", "100000"));
    private AmazonS3URI uri;
    private S3Client client;
    private String bucket;
    private String key;
    private HeadObjectResponse objectHeadResponse;

    private S3RandomAccessFile(String url) {
        super(url, s3BufferSize, s3MaxReadCacheSize);
        this.uri = new AmazonS3URI(url);
        this.bucket = this.uri.getBucket();
        this.key = this.uri.getKey();
        ApacheHttpClient.Builder httpConfig = ApacheHttpClient.builder().maxConnections(Integer.valueOf(maxConnections)).connectionTimeout(Duration.ofMillis(connectionTimeout)).socketTimeout(Duration.ofMillis(socketTimeout));
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)httpConfig);
        AwsCredentialsProviderChain defaultThenAnonymous = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{DefaultCredentialsProvider.create(), AnonymousCredentialsProvider.create()}).build();
        this.client = (S3Client)((S3ClientBuilder)s3ClientBuilder.credentialsProvider((AwsCredentialsProvider)defaultThenAnonymous)).build();
        this.objectHeadResponse = this.client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(this.key).build());
    }

    public void closeRemote() {
        if (this.client != null) {
            this.client.close();
        }
        this.uri = null;
        this.client = null;
        this.bucket = null;
        this.key = null;
        this.objectHeadResponse = null;
    }

    public int readRemote(long pos, byte[] buff, int offset, int len) throws IOException {
        String range = String.format("bytes=%d-%d", pos, pos + (long)len);
        GetObjectRequest rangeObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.key).range(range).build();
        ResponseBytes objectPortion = this.client.getObjectAsBytes(rangeObjectRequest);
        int totalBytes = 0;
        try (InputStream objectData = objectPortion.asInputStream();){
            int bytes = objectData.read(buff, offset + totalBytes, len - totalBytes);
            while (bytes > 0 && len - totalBytes > 0) {
                bytes = objectData.read(buff, offset + (totalBytes += bytes), len - totalBytes);
            }
        }
        return totalBytes;
    }

    public long length() {
        return this.objectHeadResponse.contentLength();
    }

    public long getLastModified() {
        return this.objectHeadResponse.lastModified().toEpochMilli();
    }

    public static class Provider
    implements RandomAccessFileProvider {
        public boolean isOwnerOf(String location) {
            return location.startsWith("s3:");
        }

        public RandomAccessFile open(String location) {
            return new S3RandomAccessFile(location);
        }
    }
}

