/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.s3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.ReadableRemoteFile;
import ucar.unidata.io.RemoteRandomAccessFile;
import ucar.unidata.io.s3.CdmS3Uri;
import ucar.unidata.io.spi.RandomAccessFileProvider;

public final class S3RandomAccessFile
extends RemoteRandomAccessFile
implements ReadableRemoteFile,
Closeable {
    private static final int s3BufferSize = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.bufferSize", String.valueOf(262144)));
    private static final long s3MaxReadCacheSize = Long.parseLong(System.getProperty("ucar.unidata.io.s3.maxReadCacheSize", String.valueOf(0xA00000L)));
    private static final int maxConnections = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.httpMaxConnections", "128"));
    private static final int connectionTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.connectionTimeout", String.valueOf(10000)));
    private static final int socketTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.socketTimeout", "100000"));
    private final CdmS3Uri uri;
    private final S3Client client;
    private HeadObjectResponse objectHeadResponse;

    private S3RandomAccessFile(String url) throws IOException {
        super(url, s3BufferSize, s3MaxReadCacheSize);
        Optional<Region> profileRegion = ProfileFile.defaultProfileFile().profile("default").map(p -> (String)p.properties().get("region")).map(Region::of);
        try {
            this.uri = new CdmS3Uri(url);
        }
        catch (URISyntaxException urie) {
            throw new IOException(urie.getCause());
        }
        ApacheHttpClient.Builder httpConfig = ApacheHttpClient.builder().maxConnections(Integer.valueOf(maxConnections)).connectionTimeout(Duration.ofMillis(connectionTimeout)).socketTimeout(Duration.ofMillis(socketTimeout));
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)httpConfig);
        this.uri.getEndpoint().ifPresent(arg_0 -> ((S3ClientBuilder)s3ClientBuilder).endpointOverride(arg_0));
        AwsCredentialsProviderChain.Builder cdmCredentialsProviderChainBuilder = AwsCredentialsProviderChain.builder();
        if (this.uri.getProfile().isPresent()) {
            String profileName = this.uri.getProfile().get();
            ProfileCredentialsProvider namedProfileCredentials = ProfileCredentialsProvider.builder().profileName(profileName).build();
            cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)namedProfileCredentials);
            Optional<Region> namedProfileRegion = ProfileFile.defaultProfileFile().profile(profileName).map(p -> (String)p.properties().get("region")).map(Region::of);
            if (namedProfileRegion.isPresent()) {
                profileRegion = namedProfileRegion;
            }
        }
        cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create());
        AwsCredentialsProviderChain cdmCredentialsProviderChain = cdmCredentialsProviderChainBuilder.build();
        s3ClientBuilder.credentialsProvider((AwsCredentialsProvider)cdmCredentialsProviderChain);
        s3ClientBuilder.region(profileRegion.orElse(Region.AWS_GLOBAL));
        this.client = (S3Client)s3ClientBuilder.build();
        HeadObjectRequest headdObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.uri.getBucket()).key(this.uri.getKey()).build();
        this.objectHeadResponse = this.client.headObject(headdObjectRequest);
    }

    public void closeRemote() {
        if (this.client != null) {
            this.client.close();
        }
        this.objectHeadResponse = null;
    }

    public int readRemote(long pos, byte[] buff, int offset, int len) throws IOException {
        String range = String.format("bytes=%d-%d", pos, pos + (long)len);
        GetObjectRequest rangeObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.uri.getBucket()).key(this.uri.getKey()).range(range).build();
        ResponseBytes objectPortion = this.client.getObjectAsBytes(rangeObjectRequest);
        int totalBytes = 0;
        try (InputStream objectData = objectPortion.asInputStream();){
            int bytes = objectData.read(buff, offset + totalBytes, len - totalBytes);
            while (bytes > 0 && len - totalBytes > 0) {
                bytes = objectData.read(buff, offset + (totalBytes += bytes), len - totalBytes);
            }
        }
        return totalBytes;
    }

    public long length() {
        return this.objectHeadResponse.contentLength();
    }

    public long getLastModified() {
        return this.objectHeadResponse.lastModified().toEpochMilli();
    }

    public static class Provider
    implements RandomAccessFileProvider {
        public boolean isOwnerOf(String location) {
            return location.startsWith("cdms3:") || location.startsWith("s3:");
        }

        public RandomAccessFile open(String location) throws IOException {
            return new S3RandomAccessFile(location);
        }
    }
}

