/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem.s3;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import thredds.inventory.CollectionConfig;
import thredds.inventory.MController;
import thredds.inventory.MControllerProvider;
import thredds.inventory.MFile;
import thredds.inventory.s3.MFileS3;
import ucar.unidata.io.s3.CdmS3Client;
import ucar.unidata.io.s3.CdmS3Uri;

public class ControllerS3
implements MController {
    private static final Logger logger = LoggerFactory.getLogger(ControllerS3.class);
    private S3Client client;
    private CdmS3Uri initialUri;
    boolean limit = false;
    static final int LIMIT_COUNT_MAX = 2000;

    private void init(CollectionConfig mc) {
        if (mc != null) {
            try {
                this.initUri(mc.getDirectoryName());
                this.initClient();
            }
            catch (IOException e) {
                logger.error("Error initializing ControllerS3 for {}.", (Object)mc.getDirectoryName(), (Object)e);
            }
        }
    }

    private void initUri(String location) throws IOException {
        try {
            this.initialUri = new CdmS3Uri(location);
        }
        catch (URISyntaxException ue) {
            throw new IOException("Cannot create a CdmS3Uri from " + location, ue);
        }
    }

    private void initClient() throws IOException {
        this.client = CdmS3Client.acquire(this.initialUri);
    }

    public Iterator<MFile> getInventoryAll(CollectionConfig mc, boolean recheck) {
        this.init(mc);
        String prefix = null;
        if (this.initialUri.getKey().isPresent()) {
            prefix = this.initialUri.getKey().get();
        }
        return new FilteredIterator(mc, new MFileS3Iterator(this.client, this.initialUri, prefix, this.limit, true), true, true);
    }

    public Iterator<MFile> getInventoryTop(CollectionConfig mc, boolean recheck) {
        this.init(mc);
        String prefix = null;
        if (this.initialUri.getKey().isPresent()) {
            prefix = this.initialUri.getKey().get();
        }
        return new FilteredIterator(mc, new MFileS3Iterator(this.client, this.initialUri, prefix, this.limit, false), false);
    }

    public Iterator<MFile> getSubdirs(CollectionConfig mc, boolean recheck) {
        List commonPrefixes;
        ListObjectsV2Response res;
        ListObjectsV2Request listObjects;
        this.init(mc);
        String prefix = null;
        if (this.initialUri.getKey().isPresent()) {
            prefix = this.initialUri.getKey().get();
        }
        if (this.initialUri.isAws()) {
            listObjects = MFileS3Iterator.getListObjectsRequestV2(this.initialUri, prefix);
            res = this.client.listObjectsV2(listObjects);
            commonPrefixes = res.commonPrefixes();
        } else {
            listObjects = MFileS3Iterator.getListObjectsRequestV1(this.initialUri, prefix);
            res = this.client.listObjects((ListObjectsRequest)listObjects);
            commonPrefixes = res.commonPrefixes();
        }
        ArrayList<MFileS3> mFiles = new ArrayList<MFileS3>(commonPrefixes.size());
        for (CommonPrefix commonPrefix : commonPrefixes) {
            try {
                CdmS3Uri cdmS3Uri = this.initialUri.resolveNewKey(commonPrefix.prefix());
                mFiles.add(new MFileS3(cdmS3Uri));
            }
            catch (URISyntaxException e) {
                logger.error("Error creating MFile for {} bucket {}", new Object[]{commonPrefix, this.initialUri.getBucket(), e});
            }
        }
        return mFiles.iterator();
    }

    public void close() {
    }

    public static class Provider
    implements MControllerProvider {
        private static String protocol = "cdms3";

        public String getProtocol() {
            return protocol;
        }

        public MController create() {
            return new ControllerS3();
        }
    }

    private static class MFileS3Iterator
    implements Iterator<MFile> {
        static final Logger logger = LoggerFactory.getLogger(MFileS3Iterator.class);
        private final CdmS3Uri bucketUri;
        private final S3Client client;
        private final String prefix;
        private final boolean fullInventory;
        private final boolean useV2;
        final List<String> errorMessages = new ArrayList<String>();
        static final int LIMIT_COUNT_MAX = 2000;
        private final boolean limit;
        private List<S3Object> objects;
        private ListObjectsResponse responseV1;
        private ListObjectsV2Response responseV2;
        private int count;
        private int totalObjectCount = 0;

        MFileS3Iterator(S3Client cdmClient, CdmS3Uri bucketUri, @Nullable String prefix, boolean limit, boolean fullInventory) {
            this.bucketUri = bucketUri;
            this.prefix = prefix;
            this.client = cdmClient;
            this.limit = limit;
            this.fullInventory = fullInventory;
            this.useV2 = bucketUri.isAws();
            this.updateObjectList(null);
        }

        private void updateObjectList(String continuationToken) {
            this.objects = this.useV2 ? this.getObjectsV2(continuationToken) : this.getObjectsV1(continuationToken);
            this.count = 0;
            if (this.limit) {
                this.totalObjectCount += this.objects.size();
            }
        }

        private List<S3Object> getObjectsV1(String continuationToken) {
            ListObjectsRequest request = MFileS3Iterator.getListObjectsRequestV1(this.bucketUri, this.prefix, continuationToken, this.fullInventory);
            this.responseV1 = this.client.listObjects(request);
            return this.responseV1.contents();
        }

        private List<S3Object> getObjectsV2(String continuationToken) {
            ListObjectsV2Request request = MFileS3Iterator.getListObjectsRequestV2(this.bucketUri, this.prefix, continuationToken, this.fullInventory);
            this.responseV2 = this.client.listObjectsV2(request);
            return this.responseV2.contents();
        }

        static ListObjectsRequest getListObjectsRequestV1(CdmS3Uri uri, String prefix) {
            return MFileS3Iterator.getListObjectsRequestV1(uri, prefix, null, false);
        }

        static ListObjectsV2Request getListObjectsRequestV2(CdmS3Uri uri, String prefix) {
            return MFileS3Iterator.getListObjectsRequestV2(uri, prefix, null, false);
        }

        private static ListObjectsRequest getListObjectsRequestV1(CdmS3Uri uri, String prefix, String continuationToken, boolean fullInventory) {
            ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder().bucket(uri.getBucket());
            if (uri.getDelimiter().isPresent() && !fullInventory) {
                listObjectsBuilder.delimiter(uri.getDelimiter().get());
            }
            if (prefix != null) {
                listObjectsBuilder.prefix(prefix);
            }
            if (continuationToken != null) {
                listObjectsBuilder.marker(continuationToken);
            }
            return (ListObjectsRequest)listObjectsBuilder.build();
        }

        private static ListObjectsV2Request getListObjectsRequestV2(CdmS3Uri uri, String prefix, String continuationToken, boolean fullInventory) {
            ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(uri.getBucket());
            if (uri.getDelimiter().isPresent() && !fullInventory) {
                listObjectsBuilder.delimiter(uri.getDelimiter().get());
            }
            if (prefix != null) {
                listObjectsBuilder.prefix(prefix);
            }
            if (continuationToken != null) {
                listObjectsBuilder.continuationToken(continuationToken);
            }
            return (ListObjectsV2Request)listObjectsBuilder.build();
        }

        @Override
        public boolean hasNext() {
            boolean hasMore;
            if (this.count < this.objects.size()) {
                hasMore = true;
            } else if (this.objects.isEmpty()) {
                hasMore = false;
            } else {
                hasMore = this.useV2 ? this.responseV2.isTruncated() : this.responseV1.isTruncated();
                if (hasMore) {
                    String continuationToken = this.useV2 ? this.responseV2.nextContinuationToken() : this.responseV1.nextMarker();
                    this.updateObjectList(continuationToken);
                }
            }
            if (this.limit && this.totalObjectCount > 2000) {
                hasMore = false;
            }
            return hasMore;
        }

        @Override
        public MFile next() {
            S3Object object = this.objects.get(this.count++);
            MFileS3 nextMFile = null;
            try {
                CdmS3Uri newUri = this.bucketUri.resolveNewKey(object.key());
                nextMFile = new MFileS3(newUri);
            }
            catch (URISyntaxException e) {
                logger.warn("Cannot create MFile for {} in bucket {}", new Object[]{object.key(), this.bucketUri.getBucket(), e});
            }
            return nextMFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FilteredIterator
    implements Iterator<MFile> {
        private final Iterator<MFile> orgIter;
        private final CollectionConfig mc;
        private final boolean wantDirs;
        private final boolean fullInventory;
        private MFile next;

        FilteredIterator(CollectionConfig mc, Iterator<MFile> iter, boolean wantDirs) {
            this.orgIter = iter;
            this.mc = mc;
            this.wantDirs = wantDirs;
            this.fullInventory = false;
        }

        FilteredIterator(CollectionConfig mc, Iterator<MFile> iter, boolean wantDirs, boolean fullInventory) {
            this.orgIter = iter;
            this.mc = mc;
            this.wantDirs = wantDirs;
            this.fullInventory = fullInventory;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredFile();
            return this.next != null;
        }

        @Override
        public MFile next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        private MFile nextFilteredFile() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (pdata.isDirectory() != this.wantDirs && !this.fullInventory || !this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    pdata = null;
                    break;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

